/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ResultObjectAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TreeGraphObject
extends ResultObjectAdapter {
    private static final long serialVersionUID = -4541908080843133543L;
    private int nodeCounter = 0;
    private ArrayList<Node> nodes = new ArrayList();
    private Node root = null;
    private ExampleSet payload = null;

    public TreeGraphObject(String rootName, Serializable rootPayload) {
        this.root = this.createNode(rootName, rootPayload);
    }

    public TreeGraphObject(Node root, Serializable rootPayload) {
        this.nodes.add(root);
        this.root = root;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        if (this.root == null) {
            this.root = node;
        }
    }

    public void addRelation(Node parent, Node child) {
        parent.add(child);
    }

    public Node createNode(String name, Serializable payload) {
        Node node = new Node(this.nodeCounter++, name, payload);
        this.nodes.add(node);
        if (this.root == null) {
            this.root = node;
        }
        return node;
    }

    public Node getNode(int id) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get((int)i).id != id) continue;
            return this.nodes.get(i);
        }
        return null;
    }

    public Node getNode(int id, Node node) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            if (child == null) {
                return null;
            }
            if (child.id == id) {
                return child;
            }
            Node result = this.getNode(id, child);
            if (result == null) continue;
            return result;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get((int)i).id != id) continue;
            return this.nodes.get(i);
        }
        return null;
    }

    public Node getRoot() {
        return this.root;
    }

    public List<Node> getChildren(Node parent) {
        LinkedList<Node> childrenList = new LinkedList<Node>();
        Enumeration<TreeNode> childrenEnum = parent.children();
        while (childrenEnum.hasMoreElements()) {
            Node child = (Node)childrenEnum.nextElement();
            childrenList.add(child);
        }
        return Collections.unmodifiableList(childrenList);
    }

    public List<Node> getParents(Node child) {
        LinkedList<Node> parentList = new LinkedList<Node>();
        if (child == this.root) {
            return Collections.unmodifiableList(parentList);
        }
        for (Node possibleParent = child.getParent(); possibleParent != null; possibleParent = possibleParent.getParent()) {
            parentList.add(possibleParent);
        }
        return Collections.unmodifiableList(parentList);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setPayload(ExampleSet payload) {
        this.payload = payload;
    }

    public ExampleSet getPayload() {
        return this.payload;
    }

    public static class Node
    extends DefaultMutableTreeNode
    implements Serializable {
        private static final long serialVersionUID = -4320304575985830192L;
        public int id;
        public String name;
        public String description;
        public Serializable payload = null;

        public Node(int id, String name, Serializable payload) {
            super(name);
            this.id = id;
            this.name = name;
            this.payload = payload;
        }

        public Node(int id, String name, String description, Serializable payload) {
            this(id, name, null);
            this.description = description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int hashCode() {
            return this.id + 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.id == other.id;
        }

        @Override
        public Node getParent() {
            return (Node)super.getParent();
        }

        public boolean equalName(String str) {
            if (str == null && this.name == null) {
                return true;
            }
            if (str == null || this.name == null) {
                return false;
            }
            return str == this.name;
        }

        public Node copy() {
            Node newNode = (Node)this.clone();
            Enumeration<TreeNode> children = this.children();
            if (!this.isLeaf()) {
                while (children.hasMoreElements()) {
                    Node child = (Node)children.nextElement();
                    newNode.add(child.copy());
                }
                return newNode;
            }
            return (Node)this.clone();
        }
    }
}

