/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects.files;

import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.tasks.RetrieveInputStreamTask;
import com.owc.tools.files.remote.tasks.WriteToLocalCheck;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class RemoteFileObject
extends com.rapidminer.operator.nio.file.FileObject {
    private static final long serialVersionUID = 5269550059819043862L;
    public static final int NUMBER_OF_REMOTE_OPERATION_RETRIES = 0;
    public static final long DELAY_BEFORE_RETRIES = 1000L;
    final FileObject vfsFileObject;
    final int numberOfRetries;
    final long delay;
    final String localName;
    private transient File tempFile = null;

    public RemoteFileObject(FileObject vfsFileObject, String localName) {
        this(vfsFileObject, localName, 0, 1000L);
    }

    public RemoteFileObject(FileObject vfsFileObject, String localName, int numberOfRetries, long delay) {
        this.vfsFileObject = vfsFileObject;
        this.numberOfRetries = numberOfRetries;
        String tempName = localName;
        while (tempName.endsWith("/")) {
            tempName = tempName.substring(0, tempName.length() - 1);
        }
        this.localName = tempName;
        this.delay = delay;
    }

    public InputStream openStream() throws OperatorException {
        FileSystemManager manager;
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e1) {
            throw new UserError(null, (Throwable)e1, "toolkit.remote_files.file_system_manager_fail", new Object[]{e1.getMessage()});
        }
        RetrieveInputStreamTask inputStreamTask = new RetrieveInputStreamTask(manager, this.getVfsFileObject());
        try {
            return RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(null, inputStreamTask, this.delay, this.numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
    }

    public File getFile() throws OperatorException {
        return this.getFile(0);
    }

    public synchronized File getFile(int currentTry) throws OperatorException {
        File file;
        if (this.tempFile != null && this.tempFile.exists()) {
            return this.tempFile;
        }
        WriteToLocalCheck writeToLocal = new WriteToLocalCheck(null, this.localName, this.vfsFileObject);
        try {
            file = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(null, writeToLocal, this.delay, this.numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        this.tempFile = file;
        return file;
    }

    public long getLength() throws OperatorException {
        try {
            return this.vfsFileObject.getContent().getSize();
        }
        catch (FileSystemException e) {
            throw new UserError(null, "");
        }
    }

    private void logRetry(String file, int numberOfRetry, UserError e) {
        String errorMessage = e != null ? e.getMessage() : "No Reason found";
        LogService.getRoot().log(Level.WARNING, "Retrying to retrieve the targeted file ''" + file + "'' for the " + numberOfRetry + " time, after it failed because of ''" + errorMessage + "''.");
    }

    public String toString() {
        return "<br>Localname: \t" + this.localName + "<br>RemoteUrl:\t" + this.getVfsFileObject().getPublicURIString() + ".";
    }

    public String getFilename() {
        return this.localName;
    }

    public String getSource() {
        return this.vfsFileObject.getPublicURIString();
    }

    public FileObject getVfsFileObject() {
        return this.vfsFileObject;
    }
}

