/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects.files;

import com.owc.vfs2.impl.AdvancedVFS;
import java.io.IOException;
import java.nio.file.SimpleFileVisitor;
import java.util.NoSuchElementException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class RemoteFiles {
    public static void walkRemoteFileTree(FileObject startLocation, SimpleFileVisitor<String[]> fileVisitor, FileObject currentLocation) {
        String startLocationPublicUri = startLocation.getPublicURIString();
        try {
            String parentRelativeToStart;
            FileObject parent = currentLocation.getParent();
            if (parent != null && parent.getName().compareTo(startLocation.getName()) != 0) {
                parentRelativeToStart = startLocation.getName().getRelativeName(parent.getName());
                parentRelativeToStart = "/" + parentRelativeToStart + "/";
            } else {
                parentRelativeToStart = "/";
            }
            String baseName = currentLocation.getName().getBaseName();
            try {
                if (currentLocation.isFile()) {
                    fileVisitor.visitFile(new String[]{baseName, parentRelativeToStart}, null);
                    return;
                }
            }
            catch (FileSystemException e) {
                e.printStackTrace();
                throw new NoSuchElementException("Error while locating and visiting potential File '" + startLocationPublicUri + "'. " + e.getMessage());
            }
            catch (IOException e) {
                throw new NoSuchElementException("Should never happen");
            }
            try {
                FileObject[] children;
                if (!currentLocation.isFolder()) {
                    throw new NoSuchElementException("Cannot handle found type \"" + currentLocation.getType().toString() + "\" for selected location \"" + startLocationPublicUri + "\"");
                }
                for (FileObject child : children = currentLocation.getChildren()) {
                    try {
                        child.refresh();
                    }
                    catch (FileSystemException e1) {
                        throw new NoSuchElementException("Failed Refreshing information on: " + child.getPublicURIString());
                    }
                    RemoteFiles.walkRemoteFileTree(startLocation, fileVisitor, child);
                }
            }
            catch (FileSystemException e) {
                AdvancedVFS.getManager().closeFileSystem(currentLocation.getFileSystem());
                e.printStackTrace();
                throw new NoSuchElementException("Error while retrieving children of " + startLocation.getPublicURIString() + ". Received Error: " + e.getMessage());
            }
        }
        catch (FileSystemException e2) {
            e2.printStackTrace();
        }
    }
}

