/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects.indexed;

import com.owc.objects.indexed.IndexedIOObject;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class IndexedIOObjectsCollection
extends IOObjectCollection<IOObject>
implements IndexedIOObject<IOObject> {
    private static final long serialVersionUID = -4442792232101591518L;
    public LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject> indexedContainer = new LinkedHashMap();
    private String[] groupAttributeNames;
    private int[] groupAttributeTypes;

    public IndexedIOObjectsCollection(String[] groupAttributeNames, int[] groupAttributeTypes) {
        this.groupAttributeNames = groupAttributeNames;
        this.groupAttributeTypes = groupAttributeTypes;
    }

    public IndexedIOObjectsCollection(LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject> indexedObjects, String[] groupAttributeNames, int[] groupAttributeTypes) {
        this.indexedContainer = indexedObjects;
        this.groupAttributeNames = groupAttributeNames;
        this.groupAttributeTypes = groupAttributeTypes;
    }

    public ExampleSet getGroupInformation() {
        ExampleSetCreator creator = new ExampleSetCreator(this.groupAttributeNames, this.groupAttributeTypes);
        for (IndexedIOObject.IndexedIOObjectKey currentGroupKey : this.indexedContainer.keySet()) {
            String[] currentGroupNominalValues = currentGroupKey.nominalValues;
            double[] currentGroupNumericalValues = currentGroupKey.numericalValues;
            for (int i = 0; i < currentGroupNominalValues.length; ++i) {
                if (currentGroupNominalValues[i] != null) {
                    creator.setValue(this.groupAttributeNames[i], currentGroupNumericalValues[i]);
                    continue;
                }
                creator.setValue(this.groupAttributeNames[i], currentGroupNominalValues[i]);
            }
            creator.commit();
        }
        return creator.finish();
    }

    public IndexedIOObjectsCollection clone() {
        LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject> newIndex = new LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, IOObject>(this.indexedContainer);
        for (Map.Entry<IndexedIOObject.IndexedIOObjectKey, IOObject> entry : newIndex.entrySet()) {
            newIndex.put(entry.getKey(), entry.getValue().copy());
        }
        return new IndexedIOObjectsCollection(newIndex, this.groupAttributeNames, this.groupAttributeTypes);
    }

    @Override
    public String[] getIndexColumnNames() {
        return this.groupAttributeNames;
    }

    @Override
    public int[] getIndexColumnTypes() {
        return this.groupAttributeTypes;
    }

    public static void isCompatible(String[] attributeNamesFirst, int[] attributeTypesFirst, String[] attributeNamesSecond, int[] attributeTypesSecond) throws UserError {
        if (attributeNamesFirst.length != attributeNamesSecond.length) {
            throw new UserError(null, "toolkit.attributes_miss_match", new Object[]{"attributessize= " + attributeNamesFirst.length, "attributessize= " + attributeNamesSecond.length});
        }
        int i = 0;
        for (String currentAttributeName : attributeNamesFirst) {
            if (!currentAttributeName.equals(attributeNamesSecond[i]) || attributeTypesFirst[i] != attributeTypesSecond[i]) {
                throw new UserError(null, "toolkit.attributes_miss_match", new Object[]{currentAttributeName + "(" + Ontology.VALUE_TYPE_NAMES[attributeTypesFirst[i]] + ")", attributeNamesSecond[i] + "(" + Ontology.VALUE_TYPE_NAMES[attributeTypesSecond[i]] + ")"});
            }
            ++i;
        }
    }

    public IOObjectCollection<IOObject> copy() {
        return this.clone();
    }

    @Override
    public synchronized void put(IndexedIOObject.IndexedIOObjectKey key, IOObject value) {
        if (value instanceof ExampleSet) {
            ExampleSet materializeExampleSet = MaterializeDataInMemory.materializeExampleSet((ExampleSet)((ExampleSet)value));
            this.indexedContainer.put(key, (IOObject)materializeExampleSet);
        } else {
            this.indexedContainer.put(key, value);
        }
    }

    public int size() {
        return this.indexedContainer.size();
    }

    @Override
    public IOObject get(IndexedIOObject.IndexedIOObjectKey key) {
        return this.indexedContainer.get(key);
    }

    @Override
    public List<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>> getAll() {
        LinkedList<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>> all = new LinkedList<Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>>();
        for (Map.Entry<IndexedIOObject.IndexedIOObjectKey, IOObject> entry : this.indexedContainer.entrySet()) {
            all.add((Pair<IndexedIOObject.IndexedIOObjectKey, IOObject>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return all;
    }

    public static <T extends IOObject> void unfold(IOObjectCollection collection, List<T> results, Class<T> desiredClass, String portName) throws UserError {
        if (desiredClass.isAssignableFrom(IndexedIOObjectsCollection.class) && collection instanceof IndexedIOObjectsCollection) {
            results.add(collection);
        } else {
            for (Object object : collection.getObjects()) {
                IOObject obj = (IOObject)object;
                if (obj instanceof IOObjectCollection && !(obj instanceof IndexedIOObjectsCollection)) {
                    IndexedIOObjectsCollection.unfold((IOObjectCollection)obj, results, desiredClass, portName);
                    continue;
                }
                if (desiredClass.isInstance(obj)) {
                    results.add(obj);
                    continue;
                }
                throw new UserError(null, 156, new Object[]{RendererService.getName(obj.getClass()), portName, RendererService.getName(desiredClass)});
            }
        }
    }

    public void add(IOObject ioobject) {
        throw new RuntimeException("Method not supported");
    }

    public List<IOObject> getObjects() {
        ArrayList<IOObject> objects = new ArrayList<IOObject>(this.indexedContainer.size());
        for (IOObject object : this.indexedContainer.values()) {
            objects.add(object);
        }
        return Collections.unmodifiableList(objects);
    }

    public List<IOObject> getObjectsRecursive() {
        ArrayList<IOObject> allChildren = new ArrayList<IOObject>();
        this.getElementsRecursive(allChildren);
        return allChildren;
    }

    private void getElementsRecursive(List<IOObject> result) {
        for (IOObject object : this.getObjects()) {
            if (object instanceof IndexedIOObjectsCollection) {
                ((IndexedIOObjectsCollection)object).getElementsRecursive(result);
                continue;
            }
            if (object instanceof IOObjectCollection) {
                result.addAll(((IOObjectCollection)object).getObjectsRecursive());
                continue;
            }
            result.add(object);
        }
    }

    public IOObject getElement(int index, boolean recursive) {
        if (!recursive) {
            IndexedIOObject.IndexedIOObjectKey[] keys = this.indexedContainer.keySet().toArray(new IndexedIOObject.IndexedIOObjectKey[0]);
            if (index < 0 || index >= keys.length) {
                throw new NoSuchElementException();
            }
            return this.get(keys[index]);
        }
        return this.getObjectsRecursive().get(index);
    }
}

