/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects.indexed;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.tools.ExampleSetMaterializer;
import com.owc.tools.ExampleSetUnify;
import com.rapidminer.Process;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.HeaderExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.studio.concurrency.internal.ExecutionExceptionHandling;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class IndexedModel
extends AbstractModel
implements IndexedIOObject<Model> {
    private static final long serialVersionUID = 1010554256652819341L;
    private LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model> modelIndex;
    private String[] indexColumnNames;
    private boolean executeParallely = true;
    int[] indexColumnTypes;

    public IndexedModel(ExampleSet trainingExampleSet, LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model> modelIndex, String[] selectedGroupAttributeNames, int[] types, boolean workParallely) {
        super(trainingExampleSet);
        this.modelIndex = modelIndex;
        this.indexColumnNames = selectedGroupAttributeNames;
        this.executeParallely = workParallely;
        this.indexColumnTypes = types;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int i;
        if (exampleSet == null || exampleSet.size() <= 0) {
            return exampleSet;
        }
        Attribute[] selectedAttributes = new Attribute[this.indexColumnNames.length];
        int v = 0;
        for (String currentGroupAttributeName : this.indexColumnNames) {
            Attribute currentGroupAttribute = exampleSet.getAttributes().get(currentGroupAttributeName);
            if (currentGroupAttribute == null) {
                throw new UserError(this.getOperator(), 160, new Object[]{currentGroupAttributeName});
            }
            selectedAttributes[v++] = currentGroupAttribute;
        }
        SortedExampleSet set = new SortedExampleSet(exampleSet, 1, false, selectedAttributes);
        int[] groupLimits = new int[set.size()];
        double[] groupValues = new double[selectedAttributes.length];
        double[] currentValues = new double[selectedAttributes.length];
        int numberOfGroups = 0;
        int exampleIndex = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Example example = (Example)iterator.next();
            i = 0;
            for (Attribute attribute : selectedAttributes) {
                currentValues[i] = example.getValue(attribute);
                ++i;
            }
            if (exampleIndex == 0) {
                System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
            } else if (!Arrays.equals(groupValues, currentValues)) {
                groupLimits[numberOfGroups++] = exampleIndex;
                System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
            }
            ++exampleIndex;
        }
        groupLimits[numberOfGroups++] = set.size();
        int[] partition = new int[set.size()];
        int batch = 0;
        for (i = 0; i < set.size(); ++i) {
            if (i == groupLimits[batch]) {
                // empty if block
            }
            partition[i] = ++batch;
        }
        SplittedExampleSet splittedSet = new SplittedExampleSet((ExampleSet)set, new Partition(partition, numberOfGroups));
        if (this.executeParallely && this.getOperator() != null && ConcurrencyExecutionServiceProvider.INSTANCE.isInitialized()) {
            return this.performPredictionAsynchronously(numberOfGroups, splittedSet, this.indexColumnNames);
        }
        return this.performPredictionSynchronously(numberOfGroups, splittedSet, this.indexColumnNames);
    }

    private ExampleSet performPredictionAsynchronously(int numberOfBatches, final SplittedExampleSet splittedSet, final String ... selectedGroupAttributeNames) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        Operator operator = this.getOperator();
        for (int i = 0; i < numberOfBatches; ++i) {
            final int currentIteration = i;
            Operator copy = operator.cloneOperator(this.getName(), true);
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(operator.getProcess(), copy, currentIteration + 1, currentIteration + 1 == numberOfBatches, (Callable)new Callable<ExampleSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ExampleSet call() throws Exception {
                    ExampleSet batchSet;
                    SplittedExampleSet splittedExampleSet = splittedSet;
                    synchronized (splittedExampleSet) {
                        splittedSet.selectSingleSubset(currentIteration);
                        batchSet = ExampleSetMaterializer.materializeExampleSet((ExampleSet)splittedSet);
                    }
                    return IndexedModel.this.performBatch(batchSet, selectedGroupAttributeNames);
                }
            });
            tasks.add(task);
        }
        List resultSets = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks(operator, tasks);
        return ExampleSetUnify.unifyExampleSets(resultSets, this.getOperator());
    }

    private ExampleSet performPredictionSynchronously(int numberOfBatches, SplittedExampleSet splittedSet, String ... selectedGroupAttributeNames) throws ProcessStoppedException, OperatorException, UserError {
        Operator op = this.getOperator();
        LinkedList<ExampleSet> resultSets = new LinkedList<ExampleSet>();
        for (int i = 0; i < numberOfBatches; ++i) {
            if (op != null) {
                op.inApplyLoop();
            }
            splittedSet.selectSingleSubset(i);
            ExampleSet batchSet = ExampleSetMaterializer.materializeExampleSet((ExampleSet)splittedSet);
            ExampleSet resultSet = this.performBatch(batchSet, selectedGroupAttributeNames);
            if (resultSet == null) continue;
            resultSets.add(resultSet);
        }
        return ExampleSetUnify.unifyExampleSets(resultSets, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExampleSet performBatch(ExampleSet batchSet, String[] selectedGroupAttributeNames) throws OperatorException, UserError {
        Model model;
        if (batchSet.size() <= 0) {
            return null;
        }
        Example firstExample = batchSet.getExample(0);
        String[] nominalValues = new String[selectedGroupAttributeNames.length];
        double[] numericalValues = new double[selectedGroupAttributeNames.length];
        int i = 0;
        for (String currentGroupAttributeName : selectedGroupAttributeNames) {
            Attribute currentGroupAttribute = batchSet.getAttributes().get(currentGroupAttributeName);
            batchSet.getAttributes().setSpecialAttribute(currentGroupAttribute, "group_" + (i + 1));
            if (currentGroupAttribute.isNominal()) {
                nominalValues[i] = firstExample.getValueAsString(currentGroupAttribute);
            } else if (currentGroupAttribute.isNumerical()) {
                numericalValues[i] = firstExample.getValue(currentGroupAttribute);
            } else if (currentGroupAttribute.isDateTime()) {
                nominalValues[i] = firstExample.getValueAsString(currentGroupAttribute);
            }
            ++i;
        }
        IndexedIOObject.IndexedIOObjectKey key = new IndexedIOObject.IndexedIOObjectKey(nominalValues, numericalValues);
        Model model2 = this.modelIndex;
        synchronized (model2) {
            model = this.modelIndex.get(key);
        }
        if (model == null) {
            Attribute label = this.getTrainingHeader().getAttributes().getLabel();
            LinkedList<Attribute> resetAttributes = new LinkedList<Attribute>();
            Attribute predictedLabel = PredictionModel.createPredictedLabel((ExampleSet)batchSet, (Attribute)label);
            resetAttributes.add(predictedLabel);
            if (label.isNominal()) {
                for (String value : predictedLabel.getMapping().getValues()) {
                    resetAttributes.add(batchSet.getAttributes().getSpecial("confidence_" + value));
                }
            }
            for (Example example : batchSet) {
                for (Attribute attribute : resetAttributes) {
                    example.setValue(attribute, Double.NaN);
                }
            }
            return batchSet;
        }
        model2 = model;
        synchronized (model2) {
            return model.apply(batchSet);
        }
    }

    protected <T> T getAndCheckForStop(final Future<T> future) throws OperatorException {
        try {
            return (T)ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeBlockingTask(new Callable<T>(){

                @Override
                public T call() throws ExecutionException, ProcessStoppedException {
                    Object t = null;
                    while (t == null) {
                        try {
                            t = future.get();
                        }
                        catch (InterruptedException e) {
                            IndexedModel.this.checkForStop();
                        }
                    }
                    return t;
                }
            });
        }
        catch (ProcessStoppedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            Process process = null;
            if (this.getOperator() != null) {
                process = this.getOperator().getProcess();
            }
            throw ExecutionExceptionHandling.INSTANCE.processExecutionException(e, process);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OperatorException("There seems to be a race condition in the parallel execution. Please try again and contact support.", (Throwable)e);
        }
    }

    public IndexedModel clone() {
        LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model> newModelIndex = new LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>(this.modelIndex);
        for (Map.Entry<IndexedIOObject.IndexedIOObjectKey, Model> entry : newModelIndex.entrySet()) {
            newModelIndex.put(entry.getKey(), (Model)entry.getValue().copy());
        }
        return new IndexedModel(this.getTrainingHeader().clone(), newModelIndex, this.indexColumnNames, this.indexColumnTypes, this.executeParallely);
    }

    public String toString() {
        return this.toResultString();
    }

    public String toResultString() {
        StringBuffer result = new StringBuffer();
        Collection<Model> values = this.modelIndex.values();
        if (values.isEmpty()) {
            return "";
        }
        result.append("Number of indexedModels:" + values.size() + Tools.getLineSeparator() + "\n");
        return result.toString();
    }

    public HeaderExampleSet getTrainingHeader() {
        Collection<Model> models = this.modelIndex.values();
        if (models.isEmpty()) {
            return super.getTrainingHeader();
        }
        Model model = models.iterator().next();
        if (model instanceof PredictionModel) {
            return ((PredictionModel)model).getTrainingHeader();
        }
        return model.getTrainingHeader();
    }

    @Override
    public synchronized void put(IndexedIOObject.IndexedIOObjectKey key, Model value) {
        this.modelIndex.put(key, value);
    }

    @Override
    public Model get(IndexedIOObject.IndexedIOObjectKey key) {
        return this.modelIndex.get(key);
    }

    @Override
    public List<Pair<IndexedIOObject.IndexedIOObjectKey, Model>> getAll() {
        LinkedList<Pair<IndexedIOObject.IndexedIOObjectKey, Model>> all = new LinkedList<Pair<IndexedIOObject.IndexedIOObjectKey, Model>>();
        for (Map.Entry<IndexedIOObject.IndexedIOObjectKey, Model> entry : this.modelIndex.entrySet()) {
            all.add((Pair<IndexedIOObject.IndexedIOObjectKey, Model>)new Pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return all;
    }

    @Override
    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    @Override
    public int[] getIndexColumnTypes() {
        return this.indexColumnTypes;
    }
}

