/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.assertions;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.meta.MetaModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.IOObjectSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.SerializationUtils;

public class AssertEqualityOperator
extends LicensedOperator {
    private InputPort inputA = this.getInputPorts().createPort("object", IOObject.class);
    private InputPort inputB = this.getInputPorts().createPort("compare to object", IOObject.class);

    public AssertEqualityOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        IOObject objectA = this.inputA.getData(IOObject.class);
        IOObject objectB = this.inputB.getData(IOObject.class);
        if (objectA instanceof IOObjectCollection && objectB instanceof IOObjectCollection) {
            IOObjectCollection objectCollectionA = (IOObjectCollection)objectA;
            IOObjectCollection objectCollectionB = (IOObjectCollection)objectB;
            Iterator iteratorA = objectCollectionA.getObjectsRecursive().iterator();
            Iterator iteratorB = objectCollectionB.getObjectsRecursive().iterator();
            while (iteratorA.hasNext()) {
                if (iteratorB.hasNext()) {
                    this.compareSingleObjects((IOObject)iteratorA.next(), (IOObject)iteratorB.next());
                    continue;
                }
                throw new UserError((Operator)this, "toolkit.objects_not_equal");
            }
        } else {
            this.compareSingleObjects(objectA, objectB);
        }
    }

    private void compareSingleObjects(IOObject objectA, IOObject objectB) throws UserError {
        block11: {
            if (objectA instanceof ExampleSet && objectB instanceof ExampleSet) {
                this.compareExampleSets(objectA, objectB);
            } else {
                if (objectA.getClass().equals(objectB.getClass())) {
                    this.clearIOObject(objectA);
                    this.clearIOObject(objectB);
                    MetaData.forIOObject((IOObject)objectA);
                    MetaData.forIOObject((IOObject)objectB);
                    if (objectA instanceof Model && objectB instanceof Model) {
                        this.compareModels(objectA, objectB);
                    }
                    if (objectA instanceof MetaModel && objectB instanceof MetaModel) {
                        MetaModel objectAModel = (MetaModel)objectA;
                        MetaModel objectBModel = (MetaModel)objectB;
                        Iterator iteratorA = objectAModel.getModels().iterator();
                        Iterator iteratorB = objectBModel.getModels().iterator();
                        while (iteratorA.hasNext()) {
                            if (!iteratorB.hasNext()) {
                                throw new UserError((Operator)this, "toolkit.objects_not_equal");
                            }
                            this.compareModels((IOObject)iteratorA.next(), (IOObject)iteratorB.next());
                        }
                    }
                    IOObjectSerializer serializer = IOObjectSerializer.getInstance();
                    ByteArrayOutputStream outA = new ByteArrayOutputStream();
                    ByteArrayOutputStream outB = new ByteArrayOutputStream();
                    try {
                        serializer.serialize((OutputStream)outA, (Object)objectA.copy());
                        serializer.serialize((OutputStream)outB, (Object)objectB.copy());
                        Serializable readA = (Serializable)serializer.deserialize((InputStream)new ByteArrayInputStream(outA.toByteArray()));
                        Serializable readB = (Serializable)serializer.deserialize((InputStream)new ByteArrayInputStream(outB.toByteArray()));
                        byte[] dataA = SerializationUtils.serialize((Serializable)readA);
                        byte[] dataB = SerializationUtils.serialize((Serializable)readB);
                        if (dataA.length == dataB.length) {
                            for (int i = 0; i < dataA.length; ++i) {
                                if (dataA[i] == dataB[i]) continue;
                                throw new UserError((Operator)this, "toolkit.objects_not_equal");
                            }
                            break block11;
                        }
                        throw new UserError((Operator)this, "toolkit.objects_not_equal");
                    }
                    catch (IOException e) {
                        throw new UserError((Operator)this, (Throwable)e, "toolkit.object_could_not_be_compared");
                    }
                }
                throw new UserError((Operator)this, "toolkit.objects_not_same_class");
            }
        }
    }

    private void compareModels(IOObject objectA, IOObject objectB) throws UserError {
        Model objectAModel = (Model)objectA;
        Model objectBModel = (Model)objectB;
        try {
            this.compareExampleSetHeaders(objectAModel.getTrainingHeader().getAttributes(), objectBModel.getTrainingHeader().getAttributes());
        }
        catch (UserError e) {
            throw new UserError((Operator)this, (Throwable)e, "toolkit.train_data_sets_are_not_equal", new Object[]{e.getMessage()});
        }
        this.clearModel(objectAModel);
        this.clearModel(objectBModel);
    }

    private void compareExampleSets(IOObject objectA, IOObject objectB) throws UserError {
        ExampleSet originalSet = (ExampleSet)objectA;
        ExampleSet comparingSet = (ExampleSet)objectB;
        if (originalSet.size() != comparingSet.size()) {
            throw new UserError((Operator)this, "toolkit.data_sets_are_not_equal_in_size");
        }
        Attributes originalAttributes = originalSet.getAttributes();
        Attributes comparingAttributes = comparingSet.getAttributes();
        this.compareExampleSetHeaders(originalAttributes, comparingAttributes);
        int row = 1;
        Iterator itOriginalExample = originalSet.iterator();
        Iterator itComparingExample = comparingSet.iterator();
        while (itOriginalExample.hasNext()) {
            Example originalExample = (Example)itOriginalExample.next();
            Example comparingExample = (Example)itComparingExample.next();
            originalAttributes = originalExample.getAttributes();
            Iterator iterator = originalAttributes.allAttributes();
            while (iterator.hasNext()) {
                double compareValue;
                double originalValue;
                Attribute attribute = (Attribute)iterator.next();
                if (!(attribute.isNominal() ? !originalExample.getValueAsString(attribute).equals(comparingExample.getValueAsString(comparingAttributes.get(attribute.getName()))) : (originalValue = originalExample.getValue(attribute)) != (compareValue = comparingExample.getValue(comparingAttributes.get(attribute.getName()))) && (!Double.isNaN(originalValue) || !Double.isNaN(compareValue)))) continue;
                throw new UserError((Operator)this, "toolkit.data_sets_are_not_equal", new Object[]{attribute.getName(), row});
            }
            ++row;
        }
    }

    private void compareExampleSetHeaders(Attributes originalAttributes, Attributes comparingAttributes) throws UserError {
        if (originalAttributes.size() != comparingAttributes.size()) {
            throw new UserError((Operator)this, "toolkit.data_sets_are_not_equal_in_size");
        }
        Iterator itOriginal = originalAttributes.iterator();
        Iterator itComparing = comparingAttributes.iterator();
        while (itOriginal.hasNext()) {
            Attribute originalAttribute = (Attribute)itOriginal.next();
            Attribute comparingAttribute = (Attribute)itComparing.next();
            if (!originalAttribute.getName().equals(comparingAttribute.getName())) {
                throw new UserError((Operator)this, "toolkit.data_sets_are_not_equal_in_attributes");
            }
            if (originalAttribute.getValueType() == comparingAttribute.getValueType()) continue;
            throw new UserError((Operator)this, "toolkit.data_sets_are_not_equal_in_attributes");
        }
    }

    private void clearModel(Model objectAModel) {
        this.clearIOObject((IOObject)objectAModel.getTrainingHeader());
        objectAModel.getTrainingHeader().getAttributes().clearRegular();
        objectAModel.getTrainingHeader().getAttributes().clearRegular();
    }

    private void clearIOObject(IOObject objectA) {
        objectA.getProcessingHistory().clear();
        objectA.getAnnotations().clear();
        objectA.setSource(null);
        objectA.getUserData("");
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

