/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.cache;

import com.owc.cache.CacheEntry;
import com.owc.cache.CacheEntryKey;
import com.owc.cache.CacheManager;
import com.owc.license.LicenseManager;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperatorChain;
import com.owc.operator.cache.ClearCacheWizard;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachingOperator
extends LicensedOperatorChain {
    public static final String PARAMETER_CACHE_NAME = "cache_name";
    public static final String PARAMETER_CACHE_DEPENDENCIES = "cache_dependencies";
    public static final String PARAMETER_RESTRICT_VALIDITY = "restrict_validity";
    public static final String PARAMETER_VALIDITY_PERIOD = "validity_period";
    private PortPairExtender inputExtender = new PortPairExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private PortPairExtender outputExtender = new PortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public CachingOperator(OperatorDescription description) {
        super(description, "Cached Process");
        this.inputExtender.start();
        this.outputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
        if (!LicenseManager.isLicenseValid("rmx_toolkit")) {
            this.getTransformer().addRule(new MDTransformationRule(){

                public void transformMD() {
                    int numberOfConnected = 0;
                    for (PortPairExtender.PortPair pair : CachingOperator.this.outputExtender.getManagedPairs()) {
                        if (!pair.getInputPort().isConnected()) continue;
                        ++numberOfConnected;
                    }
                    if (numberOfConnected > 1) {
                        for (PortPairExtender.PortPair pair : CachingOperator.this.outputExtender.getManagedPairs()) {
                            pair.getInputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)pair.getInputPort(), "toolkit.license_exceeded_cache_size", new Object[0]));
                            pair.getOutputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)pair.getInputPort(), "toolkit.license_exceeded_cache_size", new Object[0]));
                        }
                    }
                }
            });
        }
    }

    @Override
    public void doWork(boolean licenseValid) throws OperatorException {
        String cacheName = this.getName();
        if (this.isParameterSet(PARAMETER_CACHE_NAME)) {
            cacheName = this.getParameterAsString(PARAMETER_CACHE_NAME);
        }
        if (cacheName == null || cacheName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CACHE_NAME});
        }
        int generationHash = 0;
        try {
            Operator clone = this.cloneOperator("", false);
            clone.setBreakpoint(1, false);
            clone.setBreakpoint(0, false);
            String operatorXML = clone.getXML(true, true);
            generationHash = operatorXML.hashCode();
        }
        catch (Exception clone) {
            // empty catch block
        }
        CacheEntryKey key = new CacheEntryKey((Operator)this, cacheName, ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_CACHE_DEPENDENCIES)));
        CacheEntry cacheEntry = null;
        if (CacheManager.checkCompatibility(key, generationHash)) {
            cacheEntry = CacheManager.retrieve(key);
        }
        if (cacheEntry != null && this.getParameterAsBoolean(PARAMETER_RESTRICT_VALIDITY) && cacheEntry.timestamp + (long)this.getParameterAsInt(PARAMETER_VALIDITY_PERIOD) < System.currentTimeMillis()) {
            cacheEntry = null;
        }
        int payloadSize = 0;
        if (cacheEntry != null) {
            for (IOObject iOObject : cacheEntry.payload) {
                if (iOObject == null) continue;
                ++payloadSize;
            }
        }
        if (cacheEntry == null || !licenseValid && payloadSize > 1) {
            this.inputExtender.passDataThrough();
            this.getSubprocess(0).execute();
            LinkedList<IOObject> results = new LinkedList<IOObject>();
            for (PortPairExtender.PortPair pair : this.outputExtender.getManagedPairs()) {
                results.add(pair.getInputPort().getDataOrNull(IOObject.class));
            }
            cacheEntry = new CacheEntry(results);
            try {
                CacheManager.store(key, cacheEntry, generationHash);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UserError((Operator)this, (Throwable)arrayIndexOutOfBoundsException, "toolkit.cache.object_exceeds_max_size", new Object[]{CacheManager.getMaximumCacheSize()});
            }
        }
        Iterator portIterator = this.outputExtender.getManagedPairs().iterator();
        for (IOObject object : cacheEntry.payload) {
            if (!portIterator.hasNext()) continue;
            ((PortPairExtender.PortPair)portIterator.next()).getOutputPort().deliver(object);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CACHE_NAME, "The name of this cache. All caches are bound to the process they are created in, but can be shared within a process.", true, false));
        ParameterTypeConfiguration type = new ParameterTypeConfiguration(ClearCacheWizard.class, (ConfigurationListener)this);
        type.setDescription("Clears the cache.");
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_RESTRICT_VALIDITY, "If a cache needs to be refreshed after a certain time, you can check this parameter.", false, false));
        type = new ParameterTypeInt(PARAMETER_VALIDITY_PERIOD, "The number of miliseconds this cache remains valid after the results have been generated. Can be used to refresh the cache when queried after a given time.", 0, Integer.MAX_VALUE);
        type.setExpert(true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_RESTRICT_VALIDITY, true, true));
        type.setOptional(true);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeEnumeration(PARAMETER_CACHE_DEPENDENCIES, "If the cache should depend on changing values of macros/process variables, you can add their names to this list. Cache will then be specific to these values. Can be used for making user or query specific caches in Web Apps.", (ParameterType)new ParameterTypeString(PARAMETER_CACHE_DEPENDENCIES, "The name of the macro/process variable that this cache should be sensitive to.")));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

