/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.cache;

import com.owc.cache.CacheEntryKey;
import com.owc.cache.CacheManager;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.util.List;

public class ClearCacheOperator
extends LicensedOperator {
    public static final String PARAMETER_CACHE_NAME = "cache_name";
    public static final String PARAMETER_CACHING_PROCESS = "caching_process";
    public static final String PARAMETER_CACHE_DEPENDENCIES = "cache_dependencies";
    private PortPairExtender extender = new PortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public ClearCacheOperator(OperatorDescription description) {
        super(description);
        this.extender.start();
        this.getTransformer().addRule(this.extender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        String cacheName = this.getParameterAsString(PARAMETER_CACHE_NAME);
        if (cacheName == null || cacheName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CACHE_NAME});
        }
        String cachingProcessName = this.getParameterAsString(PARAMETER_CACHING_PROCESS);
        RepositoryLocation location = null;
        location = cachingProcessName == null ? this.getProcess().getRepositoryLocation() : this.getParameterAsRepositoryLocation(PARAMETER_CACHING_PROCESS);
        try {
            if (location != null) {
                location.locateEntry();
            } else if (RapidMiner.getExecutionMode() == RapidMiner.ExecutionMode.APPSERVER) {
                throw new OperatorException("Could not access process in repository. Check Access Rights.");
            }
            CacheEntryKey key = new CacheEntryKey(location, this.getProcess().getMacroHandler(), cacheName, ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_CACHE_DEPENDENCIES)));
            CacheManager.remove(key);
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, "toolkit.no_user_rights_on_cache_entry", new Object[]{location.getAbsoluteLocation()});
        }
        this.extender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_CACHING_PROCESS, "Select the process that generated the cache entry you want to clear. You may select nothing to clear the cache of this process.", true, false, true));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CACHE_NAME, "The name of this cache. All caches are bound to the process they are created in, but can be shared within a process.", false, false));
        types.add((ParameterType)new ParameterTypeEnumeration(PARAMETER_CACHE_DEPENDENCIES, "If the cache should depend on changing values of macros/process variables, you can add their names to this list. Cache will then be specific to these values. Can be used for making user or query specific caches in Web Apps.", (ParameterType)new ParameterTypeString(PARAMETER_CACHE_DEPENDENCIES, "The name of the macro/process variable that this cache should be sensitive to.")));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

