/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.generation;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import java.util.List;

public class GenerateEmptyDatasetOperator
extends LicensedOperator {
    public static final String PARAMETER_NAME_VALUETYPE = "attributes";
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_VALUETYPE = "value_type";
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("example set output");

    public GenerateEmptyDatasetOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.exampleSetOutputPort){

            public MetaData modifyMetaData(ExampleSetMetaData unmodifiedMetaData) {
                try {
                    List list = GenerateEmptyDatasetOperator.this.getParameterList(GenerateEmptyDatasetOperator.PARAMETER_NAME_VALUETYPE);
                    for (String[] tupel : list) {
                        unmodifiedMetaData.addAttribute(new AttributeMetaData(tupel[0], Ontology.ATTRIBUTE_VALUE_TYPE.mapName(tupel[1])));
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return unmodifiedMetaData;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        List list = this.getParameterList(PARAMETER_NAME_VALUETYPE);
        String[] names = new String[list.size()];
        int[] types = new int[list.size()];
        int i = 0;
        for (String[] tupel : list) {
            names[i] = tupel[0];
            types[i] = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(tupel[1]);
            if (types[i] == -1) {
                throw new UserError((Operator)this, 112, new Object[]{tupel[1]});
            }
            ++i;
        }
        ExampleSetCreator creator = new ExampleSetCreator(names, types);
        this.exampleSetOutputPort.deliver((IOObject)creator.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_NAME_VALUETYPE, "You can define whether attributes of which types are in the empty example set.", (ParameterType)new ParameterTypeString(PARAMETER_NAME, "The name of the attributes"), (ParameterType)new ParameterTypeCategory(PARAMETER_VALUETYPE, "The valuetype of the newly created attribute", Ontology.VALUE_TYPE_NAMES, 7));
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

