/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.generation;

import com.owc.license.LicenseManager;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class GenerateSequenceOperator
extends AbstractExampleSetProcessing {
    public static final String PARAMETER_SEQUENCE_ATTRIBUTE_NAME = "new_attribute";
    public static final String PARAMETER_SEQUENCE_INCREMENT = "increment";
    public static final String PARAMETER_SEQUENCE_OFFSET = "offset";

    public GenerateSequenceOperator(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        if (!LicenseManager.isLicenseValidAndMaintained("rmx_toolkit") && exampleSet.size() > 10000) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_data_size", new Object[]{10000});
        }
        String nameOfAttribute = this.getParameterAsString(PARAMETER_SEQUENCE_ATTRIBUTE_NAME);
        double increment = this.getParameterAsDouble(PARAMETER_SEQUENCE_INCREMENT);
        double offset = this.getParameterAsDouble(PARAMETER_SEQUENCE_OFFSET);
        Attribute sequenceAttribute = AttributeFactory.createAttribute((String)nameOfAttribute, (int)4);
        exampleSet.getExampleTable().addAttribute(sequenceAttribute);
        exampleSet.getAttributes().addRegular(sequenceAttribute);
        for (Example example : exampleSet) {
            example.setValue(sequenceAttribute, offset);
            offset += increment;
        }
        return exampleSet;
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        metaData.addAttribute(new AttributeMetaData(this.getParameterAsString(PARAMETER_SEQUENCE_ATTRIBUTE_NAME), 4));
        return metaData;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_SEQUENCE_ATTRIBUTE_NAME, "The name of the newly create sequence attribute. No attribute with the same name may exist already.", "SequenceIndex"));
        types.add(new ParameterTypeDouble(PARAMETER_SEQUENCE_INCREMENT, "The increment from example to example.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble(PARAMETER_SEQUENCE_OFFSET, "The start value for the first example in the given example set.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }
}

