/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.generation;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.RandomGenerator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;

public class GenerateTrainingDataOperator
extends LicensedOperator {
    private static final int FRIDAY = 5;
    private static final int SATURDAY = 6;
    private static final int SUNDAY = 7;
    private static final Integer WEEKEND_START_FRIDAY_CUT_OFF_HOUR = 22;
    private static final Integer WEEKEND_END_SUNDAY_CUT_OFF_HOUR = 23;
    private static List<Integer> weekendDaysList = Arrays.asList(5, 6, 7);
    private static final ExampleSetCreator MASTER_DATA_CREATOR = new ExampleSetCreator(new String[]{"UserID", "FirstName", "Gender", "Birthday", "PostalCode"}, new int[]{3, 7, 6, 9, 3}, false);
    private static final ExampleSetCreator EVENT_DATA_CREATOR = new ExampleSetCreator(new String[]{"UserID", "GameID", "Timestamp", "Type", "Level", "Time", "ItemID", "Price", "OfferPrice", "PaymentMethod"}, new int[]{3, 7, 9, 7, 3, 3, 3, 4, 4, 7});
    private static final String PARAMETER_LOCATION_DATA = "location_data";
    private static final String PARAMETER_FIRST_NAME_DATA = "first_name_data";
    private static final String PARAMETER_DEVICE_DATA = "device_data";
    private static final String PARAMETER_GAME_DATA = "game_data";
    private static final String PARAMETER_USERS = "number_of_users";
    private static final String PARAMETER_ITEMS = "number_of_items";
    private double[] PAYMENT_METHOD_DISTRIBUTION = new double[]{0.1, 0.3, 0.8, 0.95, 1.0};
    private String[] PAYMENT_METHODS = new String[]{"Wire Transfer", "Credit Card", "Paypal", "Klarna", "Coupon"};
    private double[] PRICES = new double[]{0.1, 0.2, 0.33, 0.5, 1.0, 1.1, 1.2, 1.5, 2.0, 2.5, 3.0, 4.5, 5.0, 7.0, 7.5, 9.5, 10.0, 12.0, 15.0, 18.0, 20.0, 25.0, 35.0, 45.0};
    private double[] PRICE_DISTRIBUTION = new double[]{0.05, 0.1, 0.14, 0.3, 0.42, 0.47, 0.52, 0.57, 0.65, 0.7, 0.77, 0.81, 0.84, 0.87, 0.89, 0.92, 0.93, 0.945, 0.96, 0.97, 0.978, 0.99, 1.0};
    private double[] PRICE_MODIFIER_DISTRIBUTION = new double[]{0.6, 0.75, 0.8, 1.0};
    private double[] PRICE_ABSOLUTE_MODIFIER = new double[]{0.0, -0.01, 0.0, 0.0};
    private double[] PRICE_RELATIVE_MODIFIER = new double[]{1.0, 1.0, 0.9, 1.1};
    private GammaDistribution PROFESSIONALISM_DISTRIBUTION = new GammaDistribution(10.0, 2.9);
    private GammaDistribution AGE_DISTRIBUTION = new GammaDistribution(9.0, 2.8);
    private GammaDistribution GAME_TOTAL_PLAY_HOURS_DISTRIBUTION = new GammaDistribution(0.5, 32.0);
    private NormalDistribution DIFFICULTY_DISTRIBUTION = new NormalDistribution(1.0, 0.2);
    private NormalDistribution LEVEL_DISTRIBUTION = new NormalDistribution(32.0, 8.0);
    private GammaDistribution LEVEL_PLAY_TIME_DISTRIBUTION = new GammaDistribution(9.0, 0.5);
    private GammaDistribution GAME_START_DISTRIBUTION = new GammaDistribution(2.0, 200.0);
    private GammaDistribution GAME_INDAY_BREAK_DISTRIBUTION = new GammaDistribution(1.2, 60.0);
    private GammaDistribution GAME_DAY_BREAK_DISTRIBUTION = new GammaDistribution(2.0, 2.0);
    private OutputPort masterDataOutputPort = (OutputPort)this.getOutputPorts().createPort("master data set");
    private OutputPort eventDataOutputPort = (OutputPort)this.getOutputPorts().createPort("event data set");

    public GenerateTrainingDataOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.masterDataOutputPort, MASTER_DATA_CREATOR.getMetaData()));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.eventDataOutputPort, EVENT_DATA_CREATOR.getMetaData()));
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator((Operator)this);
        try {
            ExampleSet locationSet = this.getRepositoryData(PARAMETER_LOCATION_DATA);
            ExampleSet firstNameSet = this.getRepositoryData(PARAMETER_FIRST_NAME_DATA);
            ExampleSet deviceSet = this.getRepositoryData(PARAMETER_DEVICE_DATA);
            ExampleSet gameSet = this.getRepositoryData(PARAMETER_GAME_DATA);
            Attribute populationAttribute = locationSet.getAttributes().get("Population");
            locationSet.recalculateAttributeStatistics(populationAttribute);
            double totalPopulation = locationSet.getStatistics(populationAttribute, "sum");
            int totalItems = this.getParameterAsInt(PARAMETER_ITEMS);
            double[] itemPrices = new double[totalItems];
            block2: for (int i = 0; i < totalItems; ++i) {
                double priceDensity = randomGenerator.nextDouble();
                for (int j = 0; j < this.PRICE_DISTRIBUTION.length; ++j) {
                    if (!(priceDensity <= this.PRICE_DISTRIBUTION[j])) continue;
                    itemPrices[i] = this.PRICES[j];
                    continue block2;
                }
            }
            Attribute categoryAttribute = gameSet.getAttributes().get("Category");
            Attribute publicationYearAttribute = gameSet.getAttributes().get("Published");
            Attribute gameIDAttribute = gameSet.getAttributes().get("GameID");
            Attribute gameTitleAttribute = gameSet.getAttributes().get("GameTitle");
            gameSet.recalculateAttributeStatistics(publicationYearAttribute);
            double latestPublicationYear = gameSet.getStatistics(publicationYearAttribute, "maximum");
            ArrayList<Game> games = new ArrayList<Game>();
            for (Example example : gameSet) {
                Game game = new Game();
                game.category = example.getNominalValue(categoryAttribute);
                game.gameID = example.getNominalValue(gameIDAttribute);
                game.gameTitle = example.getNominalValue(gameTitleAttribute);
                game.publicationDate = Instant.now().minus(randomGenerator.nextLongInRange(0L, 365L), ChronoUnit.DAYS).minus((long)(latestPublicationYear - example.getValue(publicationYearAttribute)) * 365L, ChronoUnit.DAYS);
                game.numberOfLevels = (int)Math.max(this.LEVEL_DISTRIBUTION.sample(), 5.0);
                game.difficulty = this.DIFFICULTY_DISTRIBUTION.sample();
                games.add(game);
            }
            int userID = randomGenerator.nextInt(34682);
            LinkedList<User> users = new LinkedList<User>();
            for (int i = 0; i < this.getParameterAsInt(PARAMETER_USERS); ++i) {
                User user = this.generateUser(randomGenerator, locationSet, (int)totalPopulation, firstNameSet, deviceSet);
                user.id = userID++;
                users.add(user);
                WeibullDistribution numberOfGamesDistribution = new WeibullDistribution(1.8, user.professionalism * 20.0);
                int numberOfGames = Math.max(1, (int)numberOfGamesDistribution.sample());
                ArrayList availableGames = new ArrayList(games);
                for (int j = 0; j < numberOfGames; ++j) {
                    Game selectedGame = (Game)availableGames.remove(randomGenerator.nextIntInRange(0, availableGames.size()));
                    Instant virtualNow = selectedGame.publicationDate.plus((long)((int)this.GAME_START_DISTRIBUTION.sample()), ChronoUnit.DAYS);
                    while (virtualNow.isBefore(user.birthday.plus(1200L, ChronoUnit.DAYS))) {
                        virtualNow = virtualNow.plus((long)randomGenerator.nextInt(865), ChronoUnit.DAYS);
                    }
                    boolean hasStoppedPlaying = false;
                    double maxPlayTimeSeconds = this.GAME_TOTAL_PLAY_HOURS_DISTRIBUTION.sample() * 3600.0;
                    double totalPlayTimeSeconds = 0.0;
                    block8: while (!hasStoppedPlaying && !virtualNow.isAfter(Instant.now())) {
                        for (int level = 0; level < selectedGame.numberOfLevels; ++level) {
                            Event event;
                            if (randomGenerator.nextDouble() > user.professionalism) {
                                event = new Event();
                                event.game = selectedGame;
                                event.levelID = level;
                                event.playTime = virtualNow;
                                int playTimeDefault = Math.abs(event.game.gameID.hashCode()) * (level + 1) % 300;
                                if (playTimeDefault < 0) {
                                    playTimeDefault += 300;
                                }
                                event.playTimeSeconds = playTimeDefault + (int)Math.max(this.LEVEL_PLAY_TIME_DISTRIBUTION.sample() * 60.0, 0.0);
                                totalPlayTimeSeconds += (double)event.playTimeSeconds;
                                if (randomGenerator.nextDouble() < 0.33) {
                                    event.itemID = randomGenerator.nextInt(totalItems);
                                    event.transaction = new Transaction();
                                    event.transaction.price = itemPrices[event.itemID];
                                    double discountDensity = randomGenerator.nextDouble();
                                    for (int discount = 0; discount < this.PRICE_MODIFIER_DISTRIBUTION.length; ++discount) {
                                        if (!(discountDensity <= this.PRICE_MODIFIER_DISTRIBUTION[discount])) continue;
                                        event.transaction.offerPrice = event.transaction.price * this.PRICE_RELATIVE_MODIFIER[discount] + this.PRICE_ABSOLUTE_MODIFIER[discount];
                                        break;
                                    }
                                    if (user.professionalism / 5.0 > randomGenerator.nextDouble()) {
                                        for (int method = 0; method < this.PAYMENT_METHOD_DISTRIBUTION.length; ++method) {
                                            if (!(discountDensity <= this.PAYMENT_METHOD_DISTRIBUTION[method])) continue;
                                            event.transaction.paymentMethod = this.PAYMENT_METHODS[method];
                                            break;
                                        }
                                    }
                                }
                                user.events.add(event);
                                virtualNow = virtualNow.plus((long)event.playTimeSeconds, ChronoUnit.SECONDS);
                            }
                            double d = randomGenerator.nextDouble();
                            double d2 = user.professionalism;
                            int n = GenerateTrainingDataOperator.isWeekend(virtualNow) ? 3 : 1;
                            if (d > d2 / (double)n) {
                                virtualNow = virtualNow.plus((long)(this.GAME_INDAY_BREAK_DISTRIBUTION.sample() * 60.0), ChronoUnit.SECONDS);
                                double d3 = randomGenerator.nextDouble();
                                double d4 = user.professionalism;
                                int n2 = GenerateTrainingDataOperator.isWeekend(virtualNow) ? 4 : 1;
                                if (d3 > d4 / (double)n2) {
                                    virtualNow = virtualNow.plus((long)this.GAME_DAY_BREAK_DISTRIBUTION.sample(), ChronoUnit.DAYS);
                                    virtualNow = virtualNow.plus((long)(this.GAME_DAY_BREAK_DISTRIBUTION.sample() * 24.0 * 60.0), ChronoUnit.MINUTES);
                                }
                            }
                            if (totalPlayTimeSeconds > maxPlayTimeSeconds) {
                                event = new Event();
                                event.game = selectedGame;
                                event.levelID = -1;
                                event.playTime = virtualNow;
                                event.isDeinstallation = true;
                                user.events.add(event);
                                hasStoppedPlaying = true;
                                continue block8;
                            }
                            if (!virtualNow.isAfter(Instant.now())) continue;
                            hasStoppedPlaying = true;
                            System.out.println("Reached today after " + totalPlayTimeSeconds + "s and would continue until " + maxPlayTimeSeconds + "s.");
                            continue block8;
                        }
                    }
                }
            }
            ExampleSetCreator masterCreator = MASTER_DATA_CREATOR.getInstance();
            ExampleSetCreator eventCreator = EVENT_DATA_CREATOR.getInstance();
            for (User user : users) {
                masterCreator.setValue("UserID", user.id);
                masterCreator.setValue("FirstName", user.firstName);
                masterCreator.setValue("Gender", user.isMale ? "male" : "female");
                masterCreator.setValue("Birthday", user.birthday.toEpochMilli());
                masterCreator.setValue("PostalCode", user.postalcode);
                masterCreator.commit();
                for (Event event : user.events) {
                    eventCreator.setValue("UserID", user.id);
                    eventCreator.setValue("GameID", event.game.gameID);
                    eventCreator.setValue("Timestamp", event.playTime.toEpochMilli());
                    if (event.isDeinstallation) {
                        eventCreator.setValue("Type", "deinstallation");
                    } else if (event.transaction == null && event.itemID == -1) {
                        eventCreator.setValue("Type", "gaming");
                        eventCreator.setValue("Level", event.levelID);
                        eventCreator.setValue("Time", event.playTimeSeconds);
                    } else if (event.transaction.paymentMethod == null) {
                        eventCreator.setValue("Type", "offer");
                        eventCreator.setValue("Level", event.levelID);
                        eventCreator.setValue("Time", event.playTimeSeconds);
                        eventCreator.setValue("ItemID", event.itemID);
                        eventCreator.setValue("Price", event.transaction.price);
                        eventCreator.setValue("OfferPrice", event.transaction.offerPrice);
                    } else {
                        eventCreator.setValue("Type", "transaction");
                        eventCreator.setValue("Level", event.levelID);
                        eventCreator.setValue("Time", event.playTimeSeconds);
                        eventCreator.setValue("ItemID", event.itemID);
                        eventCreator.setValue("Price", event.transaction.price);
                        eventCreator.setValue("OfferPrice", event.transaction.offerPrice);
                        eventCreator.setValue("PaymentMethod", event.transaction.paymentMethod);
                    }
                    eventCreator.commit();
                }
            }
            this.masterDataOutputPort.deliver((IOObject)masterCreator.finish());
            this.eventDataOutputPort.deliver((IOObject)eventCreator.finish());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private User generateUser(RandomGenerator randomGenerator, ExampleSet locationSet, int totalPopulation, ExampleSet firstNameSet, ExampleSet deviceSet) throws UndefinedParameterError {
        int firstNameIndex;
        Example example;
        User user = new User();
        int personIndex = randomGenerator.nextIntInRange(0, totalPopulation);
        Attribute populationAttribute = locationSet.getAttributes().get("Population");
        Attribute postalCodeAttribute = locationSet.getAttributes().get("Postalcode");
        Attribute populationMaleAttribute = locationSet.getAttributes().get("Population::Male");
        int personsCovered = 0;
        for (Example example2 : locationSet) {
            double populationInArea = example2.getValue(populationAttribute);
            if (personIndex > (personsCovered = (int)((double)personsCovered + populationInArea))) continue;
            user.postalcode = (int)example2.getValue(postalCodeAttribute);
            user.isMale = randomGenerator.nextDoubleInRange(0.0, populationInArea) < example2.getValue(populationMaleAttribute);
            break;
        }
        Attribute firstNameAttribute = firstNameSet.getAttributes().get("FirstName");
        Attribute genderAttribute = firstNameSet.getAttributes().get("Gender");
        while ("male".equals((example = firstNameSet.getExample(firstNameIndex = randomGenerator.nextInt(firstNameSet.size()))).getValueAsString(genderAttribute)) != user.isMale) {
        }
        user.firstName = example.getValueAsString(firstNameAttribute);
        Instant now = Instant.now();
        double age = this.AGE_DISTRIBUTION.sample();
        user.birthday = now.minus((long)(age * 365.25), ChronoUnit.DAYS);
        user.professionalism = this.PROFESSIONALISM_DISTRIBUTION.density(age) * 4.0;
        Attribute brandAttribute = deviceSet.getAttributes().get("Brand");
        Attribute modelAttribute = deviceSet.getAttributes().get("MarketingName");
        Example example3 = deviceSet.getExample(randomGenerator.nextInt(deviceSet.size()));
        user.deviceID = example3.getNominalValue(brandAttribute) + " " + example3.getNominalValue(modelAttribute);
        return user;
    }

    private ExampleSet getRepositoryData(String parameterName) throws RepositoryException, UserError {
        RepositoryLocation location = this.getParameterAsRepositoryLocation(parameterName);
        Entry entry = location.locateEntry();
        if (entry == null) {
            throw new RepositoryException("Entry '" + location + "' does not exist.");
        }
        if (entry instanceof IOObjectEntry) {
            return (ExampleSet)((IOObjectEntry)entry).retrieveData(null);
        }
        throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
    }

    public static boolean isWeekend(Instant instant) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        if (weekendDaysList.contains(dateTime.getDayOfWeek().getValue())) {
            if (6 == dateTime.getDayOfWeek().getValue()) {
                return true;
            }
            if (5 == dateTime.getDayOfWeek().getValue() && dateTime.getHour() >= WEEKEND_START_FRIDAY_CUT_OFF_HOUR) {
                return true;
            }
            if (7 == dateTime.getDayOfWeek().getValue() && dateTime.getHour() < WEEKEND_END_SUNDAY_CUT_OFF_HOUR) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_USERS, "Number of Users", 1, Integer.MAX_VALUE));
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_ITEMS, "Number of Items", 1, Integer.MAX_VALUE));
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_LOCATION_DATA, "Location Data", false));
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_FIRST_NAME_DATA, "First Name Data", false));
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_DEVICE_DATA, "Device Data", false));
        types.add((ParameterType)new ParameterTypeRepositoryLocation(PARAMETER_GAME_DATA, "Game Data", false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    private static class Transaction {
        String paymentMethod;
        double price;
        double offerPrice;

        private Transaction() {
        }
    }

    private static class Event {
        Game game;
        int levelID;
        int playTimeSeconds;
        Instant playTime;
        int itemID = -1;
        Transaction transaction;
        boolean isDeinstallation;

        private Event() {
        }
    }

    private static class Game {
        String gameID;
        String gameTitle;
        String category;
        int numberOfLevels;
        double difficulty;
        Instant publicationDate;

        private Game() {
        }
    }

    private static class User {
        int id;
        String firstName;
        boolean isMale;
        int postalcode;
        Instant birthday;
        double professionalism;
        String deviceID;
        List<Event> events = new LinkedList<Event>();

        private User() {
        }
    }
}

