/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.license.ProductInformation;
import com.owc.objects.DiscretizationModel;
import com.owc.operator.LicensedAbstractDiscretizationOperator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.text.DecimalFormat;
import java.util.List;

public class DiscretizeBySpecificationData
extends LicensedAbstractDiscretizationOperator {
    public static final String PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE = "attribute_name_attribute";
    public static final String PARAMETER_LOWER_LIMIT_ATTRIBUTE = "lower_limit_attribute";
    public static final String PARAMETER_RANGES_ATTRIBUTE = "number_of_bins_attribute";
    public static final String PARAMETER_UPPER_LIMIT_ATTRIBUTE = "upper_limit_attribute";
    public static final String PARAMETER_CREATE_NEGATIVE_INFINITY_BIN = "create_bin_below_lower_limit";
    public static final String PARAMETER_CREATE_POSITIVE_INFINITY_BIN = "create_bin_above_upper_limit";
    public static final String PARAMETER_INCLUDE_UPPER_LIMIT = "bins_include_upper_limit";
    public static final String PARAMETER_RANGE_NAME_SCHEMA = "bin_name_schema";
    public static final String PARAMETER_RANGE_INTERVAL_FORMAT = "bin_interval_format";
    public static final String PARAMETER_RANGE_NAME_PREFIX = "bin_name_prefix";
    private InputPort specificationsInputPort = this.getInputPorts().createPort("specification set", ExampleSet.class);

    public DiscretizeBySpecificationData(OperatorDescription description) {
        super(description);
        this.specificationsInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.specificationsInputPort, (Operator)this, PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE, 1));
        this.specificationsInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.specificationsInputPort, (Operator)this, PARAMETER_LOWER_LIMIT_ATTRIBUTE, 2));
        this.specificationsInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.specificationsInputPort, (Operator)this, PARAMETER_UPPER_LIMIT_ATTRIBUTE, 2));
        this.specificationsInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.specificationsInputPort, (Operator)this, PARAMETER_RANGES_ATTRIBUTE, 2));
    }

    @Override
    public PreprocessingModel createPreprocessingModel(ExampleSet exampleSet, boolean isLicensed) throws OperatorException {
        ExampleSet specificationSet = (ExampleSet)this.specificationsInputPort.getData(ExampleSet.class);
        boolean createNegativeInfinityBin = this.getParameterAsBoolean(PARAMETER_CREATE_NEGATIVE_INFINITY_BIN);
        boolean createPositiveInfinityBin = this.getParameterAsBoolean(PARAMETER_CREATE_POSITIVE_INFINITY_BIN);
        DiscretizationModel.RangeNameSchema nameSchema = DiscretizationModel.RangeNameSchema.valueOf(this.getParameterAsString(PARAMETER_RANGE_NAME_SCHEMA));
        DecimalFormat numberFormat = nameSchema.includesInterval() ? new DecimalFormat(this.getParameterAsString(PARAMETER_RANGE_INTERVAL_FORMAT)) : null;
        String attributeNameAttributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE);
        String lowerLimitAttributeName = this.getParameterAsString(PARAMETER_LOWER_LIMIT_ATTRIBUTE);
        String upperLimitAttributeName = this.getParameterAsString(PARAMETER_UPPER_LIMIT_ATTRIBUTE);
        String numberOfRangesAttributeName = this.getParameterAsString(PARAMETER_RANGES_ATTRIBUTE);
        if (attributeNameAttributeName == null || attributeNameAttributeName.trim().isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE, ""});
        }
        if (lowerLimitAttributeName == null || lowerLimitAttributeName.trim().isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_LOWER_LIMIT_ATTRIBUTE, ""});
        }
        if (upperLimitAttributeName == null || upperLimitAttributeName.trim().isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_UPPER_LIMIT_ATTRIBUTE, ""});
        }
        if (numberOfRangesAttributeName == null || numberOfRangesAttributeName.trim().isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_RANGES_ATTRIBUTE, ""});
        }
        Attribute attributeNameAttribute = specificationSet.getAttributes().get(attributeNameAttributeName);
        Attribute lowerLimitAttribute = specificationSet.getAttributes().get(lowerLimitAttributeName);
        Attribute upperLimitAttribute = specificationSet.getAttributes().get(upperLimitAttributeName);
        Attribute numberOfBinsAttribute = specificationSet.getAttributes().get(numberOfRangesAttributeName);
        if (attributeNameAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{attributeNameAttributeName});
        }
        if (lowerLimitAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{lowerLimitAttributeName});
        }
        if (upperLimitAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{upperLimitAttributeName});
        }
        if (numberOfBinsAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{numberOfRangesAttributeName});
        }
        if (!attributeNameAttribute.isNominal()) {
            throw new UserError((Operator)this, "toolkit.1", new Object[]{attributeNameAttributeName, this.getName(), "attribute containing the attribute names"});
        }
        if (!lowerLimitAttribute.isNumerical()) {
            throw new UserError((Operator)this, "toolkit.2", new Object[]{lowerLimitAttributeName, this.getName(), "lower limit attribute"});
        }
        if (!upperLimitAttribute.isNumerical()) {
            throw new UserError((Operator)this, "toolkit.2", new Object[]{upperLimitAttributeName, this.getName(), "upper limit attribute"});
        }
        if (!numberOfBinsAttribute.isNumerical()) {
            throw new UserError((Operator)this, "toolkit.2", new Object[]{numberOfRangesAttributeName, this.getName(), "number of bins attribute"});
        }
        String[] attributeNames = new String[specificationSet.size()];
        double[][] rangeLimits = new double[specificationSet.size()][];
        int i = 0;
        for (Example specification : specificationSet) {
            attributeNames[i] = specification.getNominalValue(attributeNameAttribute);
            double lowerLimit = specification.getValue(lowerLimitAttribute);
            double upperLimit = specification.getValue(upperLimitAttribute);
            int bins = (int)specification.getValue(numberOfBinsAttribute);
            if (bins < 1) {
                throw new UserError((Operator)this, "toolkit.min_number_of_bins", new Object[]{"1", bins});
            }
            rangeLimits[i] = new double[bins + 1 + (createNegativeInfinityBin ? 1 : 0) + (createPositiveInfinityBin ? 1 : 0)];
            double stepSize = (upperLimit - lowerLimit) / (double)bins;
            if (bins == 0) {
                stepSize = 0.0;
            }
            int offset = createNegativeInfinityBin ? 1 : 0;
            for (int j = 0; j < bins + 1; ++j) {
                rangeLimits[i][j + offset] = lowerLimit + (double)j * stepSize;
            }
            if (createNegativeInfinityBin) {
                rangeLimits[i][0] = Double.NEGATIVE_INFINITY;
            }
            if (createPositiveInfinityBin) {
                rangeLimits[i][rangeLimits[i].length - 1] = Double.POSITIVE_INFINITY;
            }
            ++i;
        }
        return new DiscretizationModel(exampleSet, rangeLimits, nameSchema, numberFormat, this.getParameterAsBoolean(PARAMETER_INCLUDE_UPPER_LIMIT), attributeNames, this.getParameterAsString(PARAMETER_RANGE_NAME_PREFIX));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE, "The attribute in the specification data set that contains the name of the target attribute.", this.specificationsInputPort, false, new int[]{1}));
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_LOWER_LIMIT_ATTRIBUTE, "The attribute in the specification data set that contains the lowest limit of the desired binning. There will be one bin for smaller values or, if ranges_include_upper_limit is selected, smaller and equal values than this lowest limit.", this.specificationsInputPort, false, new int[]{2}));
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_UPPER_LIMIT_ATTRIBUTE, "The attribute in the specification data set that contains the highest limit of the desired binning. There will be one bin for greater or equal values or, if ranges_include_upper_limit is selected, strictly greater values than this highest limit.", this.specificationsInputPort, false, new int[]{2}));
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_RANGES_ATTRIBUTE, "The attribute defining the number of ranges. Needs to be at least 3.", this.specificationsInputPort, false, new int[]{2}));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_INCLUDE_UPPER_LIMIT, "Select to make bins inclusiv their upper limits and exclusiv the lower limits. Otherwise bins are exclusiv their upper and inclusiv their lower limits.", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CREATE_NEGATIVE_INFINITY_BIN, "Select to create a bin for values smaller or smaller and equal than the lower limit, depending whether the upper limit is inclusive or not. If not selected all values smaller than the lower value will become missing.", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CREATE_POSITIVE_INFINITY_BIN, "Select to create a bin for values larger or larger and equal than the upper limit, depending whether the upper limit is inclusive or not. If not selected all values larger than the upper value will become missing.", false, false));
        DiscretizationModel.RangeNameSchema[] namingSchemas = DiscretizationModel.RangeNameSchema.values();
        String[] namingSchemaNames = new String[namingSchemas.length];
        for (int i = 0; i < namingSchemas.length; ++i) {
            namingSchemaNames[i] = namingSchemas[i].name();
        }
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_RANGE_NAME_SCHEMA, "Select the naming style", namingSchemaNames, 0));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_RANGE_INTERVAL_FORMAT, "The format string for the interval naming. 0 forces the digit, # allows it. 0000.#### will output a for digit integer part with a fraction of 4 digits max and less if possible.", "0.###");
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_RANGE_NAME_SCHEMA, namingSchemaNames, true, new int[]{2, 3}));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_RANGE_NAME_PREFIX, "The prefix used for building the name.", "bin", false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    public Class<? extends PreprocessingModel> getPreprocessingModelClass() {
        return DiscretizationModel.class;
    }
}

