/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.transformation;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.LinkedList;
import java.util.List;

public class SortOperator
extends LicensedOperator {
    public static final String PARAMETER_PRIMARY_SORT_ATTRIBUTE = "primary_sort_attribute";
    public static final String PARAMETER_ADDITIONAL_SORT_ATTRIBUTES = "additional_sort_attributes";
    public static final String PARAMETER_ADDITIONAL_SORT_ATTRIBUTE = "additional_sort_attribute";
    public static final String PARAMETER_SORT_DIRECTION = "sort_direction";
    public static final String PARAMETER_SORT_DIRECTIONS = "sort_directions";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set input", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private OutputPort originalOutput = (OutputPort)this.getOutputPorts().createPort("original example set");

    public SortOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.originalOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        LinkedList<String> sortAttributeNames = new LinkedList<String>();
        List parameterList = this.getParameterList(PARAMETER_ADDITIONAL_SORT_ATTRIBUTES);
        sortAttributeNames.add(this.getParameterAsString(PARAMETER_PRIMARY_SORT_ATTRIBUTE));
        int[] sortDirectionsOfSpecificArgument = new int[parameterList.size() + 1];
        if (this.getParameterAsInt(PARAMETER_SORT_DIRECTION) == 0) {
            sortDirectionsOfSpecificArgument[0] = 1;
        }
        if (this.getParameterAsInt(PARAMETER_SORT_DIRECTION) == 1) {
            sortDirectionsOfSpecificArgument[0] = -1;
        }
        int i = 1;
        for (Object array : parameterList) {
            sortAttributeNames.add(array[0]);
            if (((String)array[1]).equals("increasing")) {
                sortDirectionsOfSpecificArgument[i] = 1;
            }
            if (((String)array[1]).equals("decreasing")) {
                sortDirectionsOfSpecificArgument[i] = -1;
            }
            ++i;
        }
        Attribute[] sortAttributes = new Attribute[sortAttributeNames.size()];
        i = 0;
        for (String attributeName : sortAttributeNames) {
            sortAttributes[i] = set.getAttributes().get(attributeName);
            if (sortAttributes[i] == null) {
                throw new UserError((Operator)this, 160, new Object[]{attributeName});
            }
            ++i;
        }
        SortedExampleSet sortedExampleSet = new SortedExampleSet(set, sortDirectionsOfSpecificArgument, true, sortAttributes);
        this.exampleSetOutput.deliver((IOObject)sortedExampleSet);
        this.originalOutput.deliver((IOObject)set);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_SORT_DIRECTION, "The sort direction.", SortedExampleSet.SORTING_DIRECTIONS, 0));
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_PRIMARY_SORT_ATTRIBUTE, "The example set will be sorted primarily according to this attribute. Additional attributes can be specified in the list.", this.exampleSetInput, false));
        types.add((ParameterType)new ParameterTypeList(PARAMETER_ADDITIONAL_SORT_ATTRIBUTES, "You can specify any additional number of attributes here to sort according to their values with descending importance.", (ParameterType)new ParameterTypeAttribute(PARAMETER_ADDITIONAL_SORT_ATTRIBUTE, "Additional attribute for sorting", this.exampleSetInput), (ParameterType)new ParameterTypeCategory(PARAMETER_SORT_DIRECTIONS, "The sort direction.", SortedExampleSet.SORTING_DIRECTIONS, 0)));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

