/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import java.util.Iterator;
import java.util.List;

public class RelationalDataToTreeOperator
extends LicensedOperator {
    private static final String PARAMETER_NODE_ID_ATTRIBUTE = "node_id_attribute";
    private static final String PARAMETER_NODE_NAME_ATTRIBUTE = "node_name_attribute";
    private static final String PARAMETER_PARENT_ID_ATTRIBUTE = "parent_id_attribute";
    private InputPort exampleSetInputPort = this.getInputPorts().createPort("relational data input", ExampleSet.class);
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("tree output");
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("original data through port");

    public RelationalDataToTreeOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.treeOutputPort, TreeGraphObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        double exampleId;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        String nodeIdAttributeName = this.getParameterAsString(PARAMETER_NODE_ID_ATTRIBUTE);
        String nodeNameAttributeName = this.getParameterAsString(PARAMETER_NODE_NAME_ATTRIBUTE);
        String parentIdAttributeName = this.getParameterAsString(PARAMETER_PARENT_ID_ATTRIBUTE);
        if (nodeIdAttributeName.isEmpty()) {
            throw new UserError((Operator)this, "205", new Object[]{PARAMETER_NODE_ID_ATTRIBUTE});
        }
        if (nodeNameAttributeName.isEmpty()) {
            throw new UserError((Operator)this, "205", new Object[]{PARAMETER_NODE_NAME_ATTRIBUTE});
        }
        if (parentIdAttributeName.isEmpty()) {
            throw new UserError((Operator)this, "205", new Object[]{PARAMETER_PARENT_ID_ATTRIBUTE});
        }
        Attribute nodeIdAttribute = exampleSet.getAttributes().get(nodeIdAttributeName);
        Attribute nodeNameAttribute = exampleSet.getAttributes().get(nodeNameAttributeName);
        Attribute parentIdAttribute = exampleSet.getAttributes().get(parentIdAttributeName);
        if (nodeIdAttribute == null) {
            throw new UserError((Operator)this, "160", new Object[]{PARAMETER_NODE_ID_ATTRIBUTE});
        }
        if (nodeNameAttribute == null) {
            throw new UserError((Operator)this, "160", new Object[]{PARAMETER_NODE_NAME_ATTRIBUTE});
        }
        if (parentIdAttribute == null) {
            throw new UserError((Operator)this, "160", new Object[]{PARAMETER_PARENT_ID_ATTRIBUTE});
        }
        SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, nodeIdAttribute, 0);
        TreeGraphObject tree = null;
        Iterator sortedSetIterator = sortedSet.iterator();
        int rootId = 0;
        while (sortedSetIterator.hasNext()) {
            Example example = (Example)sortedSetIterator.next();
            double currentId = example.getValue(nodeIdAttribute);
            if (Double.isNaN(currentId)) {
                throw new UserError((Operator)this, "139", new Object[]{PARAMETER_NODE_ID_ATTRIBUTE});
            }
            if (currentId == (double)rootId) {
                int min = (int)sortedSet.getExample(0).getValue(nodeIdAttribute);
                int max = (int)sortedSet.getExample(sortedSet.size() - 1).getValue(nodeIdAttribute);
                if (min - 1 >= Integer.MIN_VALUE) {
                    rootId = min - 1;
                } else if (max + 1 >= Integer.MAX_VALUE) {
                    rootId = max + 1;
                } else {
                    throw new UserError((Operator)this, "toolkit.graph.relational_data_to_tree.root_node");
                }
            }
            if (example.getValue(parentIdAttribute) != example.getValue(nodeIdAttribute) || Double.isNaN(example.getValue(parentIdAttribute))) continue;
            throw new UserError((Operator)this, "toolkit.graph.relational_data_to_tree.illegal_entry");
        }
        tree = new TreeGraphObject(new TreeGraphObject.Node(rootId, "root", null), null);
        for (Example example : sortedSet) {
            exampleId = example.getValue(nodeIdAttribute);
            String exampleName = example.getValueAsString(nodeNameAttribute);
            TreeGraphObject.Node exampleNode = new TreeGraphObject.Node((int)exampleId, exampleName, null);
            TreeGraphObject.Node compare = tree.getNode((int)exampleId);
            if (compare == null) {
                tree.addNode(exampleNode);
                continue;
            }
            throw new UserError((Operator)this, "toolkit.graph.relational_data_to_tree.duplicate_id");
        }
        for (Example example : sortedSet) {
            exampleId = example.getValue(nodeIdAttribute);
            double parentId = example.getValue(parentIdAttribute);
            TreeGraphObject.Node exampleNode = tree.getNode((int)exampleId);
            if (!Double.isNaN(parentId)) {
                TreeGraphObject.Node parent = tree.getNode((int)parentId);
                if (parent == null) continue;
                tree.addRelation(parent, exampleNode);
                continue;
            }
            tree.addRelation(tree.getRoot(), exampleNode);
        }
        this.treeOutputPort.deliver((IOObject)tree);
        this.exampleSetOutputPort.deliver((IOObject)exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_NODE_ID_ATTRIBUTE, "Select the Node Id attribute of your Relational Data. This Attribute will be the key value for each node.", this.exampleSetInputPort, false, new int[]{3});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_NODE_NAME_ATTRIBUTE, "Select the Node Name attribute of your Relational Data. This Attribute will be the key value for each node.", this.exampleSetInputPort, false, new int[]{7});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_PARENT_ID_ATTRIBUTE, "Select the Parent Node ID attribute of your Relational Data. This Attribute will be the key value for each node.", this.exampleSetInputPort, false, new int[]{3});
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

