/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;

public class SelectAncestorsOperator
extends LicensedOperator {
    public static final String PARAMETER_SELECTED_NODE_ID = "selected_node_id";
    public static final String PARAMETER_SHOW_ONLY_IMMEDIATE_ANCESTORS = "show_only_immediate_ancestors";
    public static final String[] attributeNames = new String[]{"Id", "Name", "Level", "Level diffrence"};
    public static final int[] attributeTypes = new int[]{3, 7, 3, 3};
    private InputPort treeInputPort = this.getInputPorts().createPort("tree_input", TreeGraphObject.class);
    private OutputPort exampleOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleSet");
    private OutputPort ancestorsTreePort = (OutputPort)this.getOutputPorts().createPort("ancestors tree port");
    private OutputPort originalTreePort = (OutputPort)this.getOutputPorts().createPort("tree through port");

    public SelectAncestorsOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.exampleOutputPort, ExampleSet.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        TreeGraphObject tree = (TreeGraphObject)this.treeInputPort.getData(TreeGraphObject.class);
        TreeGraphObject ancestorTree = new TreeGraphObject(tree.getRoot().copy(), null);
        TreeGraphObject.Node selectedNode = ancestorTree.getNode(this.getParameterAsInt(PARAMETER_SELECTED_NODE_ID), ancestorTree.getRoot());
        if (selectedNode == null) {
            throw new UserError((Operator)this, "toolkit.graph.select_ancestors.node_not_found");
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes);
        TreeGraphObject ancestorsTree = null;
        LinkedList<TreeGraphObject.Node> targetNodes = new LinkedList<TreeGraphObject.Node>();
        TreeGraphObject.Node ancestor = null;
        selectedNode.removeAllChildren();
        if (this.getParameterAsBoolean(PARAMETER_SHOW_ONLY_IMMEDIATE_ANCESTORS)) {
            TreeGraphObject.Node parent = selectedNode.getParent();
            if (parent != null) {
                parent.removeFromParent();
                targetNodes.add(selectedNode.getParent());
            }
            targetNodes.add(selectedNode);
        } else {
            for (TreeNode node : selectedNode.getPath()) {
                if (!(node instanceof TreeGraphObject.Node)) continue;
                targetNodes.add((TreeGraphObject.Node)node);
            }
        }
        for (TreeGraphObject.Node currentNode : targetNodes) {
            currentNode = (TreeGraphObject.Node)currentNode.clone();
            if (ancestorsTree == null) {
                ancestorsTree = new TreeGraphObject(currentNode, null);
                ancestor = currentNode;
            } else {
                ancestorsTree.addNode(currentNode);
                ancestorsTree.addRelation(ancestor, currentNode);
                ancestor = currentNode;
            }
            int parentId = currentNode.id;
            String parentName = currentNode.name;
            int parentLevel = currentNode.getLevel();
            int levelDiffrence = parentLevel - selectedNode.getLevel();
            creator.setValue(attributeNames[0], parentId);
            if (parentName != null) {
                creator.setValue(attributeNames[1], parentName);
            }
            creator.setValue(attributeNames[2], parentLevel);
            creator.setValue(attributeNames[3], levelDiffrence);
            creator.commit();
        }
        this.exampleOutputPort.deliver((IOObject)creator.finish());
        this.ancestorsTreePort.deliver(ancestorsTree);
        this.originalTreePort.deliver((IOObject)tree);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_SELECTED_NODE_ID, "The id of the node from which the ancestors are supposed to be delivered", Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_SHOW_ONLY_IMMEDIATE_ANCESTORS, "If this is enabled, only the immediate successors will be listed.", false, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

