/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

public class TreeToRelationalDataOperator
extends LicensedOperator {
    public static final String PARAMETER_OMIT_ROOT_NODE = "omit_root_node";
    public static final String PARAMETER_PARENT_ID_ATTRIBUTE_NAME = "parent_id_attribute_name";
    public static final String PARAMETER_NODE_ID_ATTRIBUTE_NAME = "node_id_attribute_name";
    public static final String PARAMETER_NODE_NAME_ATTRIBUTE_NAME = "node_name_attribute_name";
    private static final int ATTRIBUTE_INDEX_NODE_ID = 0;
    private static final int ATTRIBUTE_INDEX_NODE_NAME = 1;
    private static final int ATTRIBUTE_INDEX_PARENT_ID = 2;
    private InputPort treeInputPort = this.getInputPorts().createPort("tree input", TreeGraphObject.class);
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleset output port");
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("tree through port");

    public TreeToRelationalDataOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.treeInputPort, this.treeOutputPort);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.exampleSetOutputPort){

            public MetaData modifyMetaData(ExampleSetMetaData metaData) {
                metaData.getNumberOfExamples().increaseByUnknownAmount();
                try {
                    metaData.addAttribute(new AttributeMetaData(TreeToRelationalDataOperator.this.getParameterAsString(TreeToRelationalDataOperator.PARAMETER_NODE_ID_ATTRIBUTE_NAME), 3));
                    metaData.addAttribute(new AttributeMetaData(TreeToRelationalDataOperator.this.getParameterAsString(TreeToRelationalDataOperator.PARAMETER_NODE_NAME_ATTRIBUTE_NAME), 7));
                    AttributeMetaData attribute = new AttributeMetaData(TreeToRelationalDataOperator.this.getParameterAsString(TreeToRelationalDataOperator.PARAMETER_PARENT_ID_ATTRIBUTE_NAME), 3);
                    attribute.containsMissingValues();
                    metaData.addAttribute(attribute);
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return metaData;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        TreeGraphObject tree = (TreeGraphObject)this.treeInputPort.getData(TreeGraphObject.class);
        String[] attributeNames = new String[]{this.getParameterAsString(PARAMETER_NODE_ID_ATTRIBUTE_NAME), this.getParameterAsString(PARAMETER_NODE_NAME_ATTRIBUTE_NAME), this.getParameterAsString(PARAMETER_PARENT_ID_ATTRIBUTE_NAME)};
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, new int[]{3, 7, 3});
        TreeGraphObject.Node root = tree.getRoot();
        if (!this.getParameterAsBoolean(PARAMETER_OMIT_ROOT_NODE)) {
            creator.setValue(attributeNames[0], root.id);
            if (root.name != null) {
                creator.setValue(attributeNames[1], root.name);
                creator.setValue(attributeNames[2], Double.NaN);
            }
            creator.commit();
        }
        this.outputTree(creator, tree, root, attributeNames);
        this.exampleSetOutputPort.deliver((IOObject)creator.finish());
        this.treeOutputPort.deliver((IOObject)tree);
    }

    private void outputTree(ExampleSetCreator creator, TreeGraphObject tree, TreeGraphObject.Node root, String[] attributeNames) {
        for (TreeGraphObject.Node child : tree.getChildren(root)) {
            creator.setValue(attributeNames[0], child.id);
            if (child.name != null) {
                creator.setValue(attributeNames[1], child.name);
                if (!(root == null || root == tree.getRoot() && this.getParameterAsBoolean(PARAMETER_OMIT_ROOT_NODE))) {
                    creator.setValue(attributeNames[2], root.id);
                } else {
                    creator.setValue(attributeNames[2], Double.NaN);
                }
            }
            creator.commit();
            this.outputTree(creator, tree, child, attributeNames);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_OMIT_ROOT_NODE, "Selects whether to ignore the root node as entry in the relational data set.", true, false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_NODE_ID_ATTRIBUTE_NAME, "Specifies the name for the attribute that will contain the ids of the nodes.", "NodeId");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_NODE_NAME_ATTRIBUTE_NAME, "Specifies the name for the attribute that will contain the names of the nodes", "NodeName");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_PARENT_ID_ATTRIBUTE_NAME, "Specifies the name for the attribute that will contain the id of the respective parent of each node. Will be missing if no parent present.", "ParentId");
        type.setOptional(false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

