/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TreeToWideDataOperator
extends LicensedOperator {
    private static final String PARAMETER_GROUP_ATTRIBUTE_NAME = "group_attribute_name";
    private static final String PARAMETER_COLUMN_NUMBER = "column_number";
    private static final String PARAMETER_COLUMN_ATTRIBUTENAME = "column_attribute_name";
    private static final String PARAMETER_GROUPS_LIST = "collection_of_groups";
    private static final String PARAMETER_OMIT_ROOT_NODE = "omit_root_node";
    private static final String PARAMETER_INCLUDE_PAYLOAD = "include_meta_data";
    private static final String defaultColumnName = "Layer";
    private InputPort treeInputPort = this.getInputPorts().createPort("tree input", TreeGraphObject.class);
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleset output port");
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("tree through port");

    public TreeToWideDataOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.treeInputPort, this.treeOutputPort);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.exampleSetOutputPort){

            public MetaData modifyMetaData(ExampleSetMetaData metaData) {
                metaData.getNumberOfExamples().increaseByUnknownAmount();
                try {
                    metaData.addAttribute(new AttributeMetaData(TreeToWideDataOperator.this.getParameterAsString(TreeToWideDataOperator.PARAMETER_GROUP_ATTRIBUTE_NAME), 7));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return metaData;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        int i;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean includePayload = this.getParameterAsBoolean(PARAMETER_INCLUDE_PAYLOAD);
        TreeGraphObject tree = (TreeGraphObject)this.treeInputPort.getData(TreeGraphObject.class);
        ExampleSet nodeDataExampleSet = tree.getPayload();
        Attribute nodeDataIdAttribute = null;
        if (nodeDataExampleSet != null) {
            nodeDataIdAttribute = nodeDataExampleSet.getAttributes().get("NodeId");
            includePayload = true;
        } else {
            includePayload = false;
        }
        List groupList = this.getParameterList(PARAMETER_GROUPS_LIST);
        TreeGraphObject.Node root = tree.getRoot();
        int omitRootNode = 0;
        if (!this.getParameterAsBoolean(PARAMETER_OMIT_ROOT_NODE)) {
            omitRootNode = 1;
        }
        int treeDepth = omitRootNode + root.getDepth();
        int nodeDataSize = 0;
        if (includePayload && (nodeDataSize = nodeDataExampleSet.getAttributes().size() - 1) < 0) {
            nodeDataSize = 0;
        }
        int attributeNamesSize = treeDepth + nodeDataSize;
        String[] attributeNames = new String[attributeNamesSize];
        int[] attributeTypes = new int[attributeNamesSize];
        for (i = 0; i < treeDepth; ++i) {
            attributeNames[i] = defaultColumnName + (i + 1);
            attributeTypes[i] = 7;
        }
        for (i = 0; i < groupList.size(); ++i) {
            int selectedColumnNumber = Integer.parseInt(((String[])groupList.get(i))[0]);
            String selectedColumnName = ((String[])groupList.get(i))[1];
            if (selectedColumnNumber > attributeNames.length || selectedColumnNumber <= 0) continue;
            attributeNames[selectedColumnNumber - 1] = selectedColumnName;
        }
        if (includePayload) {
            i = treeDepth;
            Iterator attributesIterator = nodeDataExampleSet.getAttributes().allAttributes();
            while (attributesIterator.hasNext()) {
                Attribute attribute = (Attribute)attributesIterator.next();
                for (String name : attributeNames) {
                    if (name == null || !name.equals(attribute.getName())) continue;
                    throw new UserError((Operator)this, "toolkit.graph.tree_to_wide_data.duplicate_attributes");
                }
                if (i >= attributeNames.length) continue;
                attributeNames[i] = attribute.getName();
                attributeTypes[i] = attribute.getValueType();
                if (attribute == nodeDataIdAttribute) continue;
                ++i;
            }
        }
        HashMap<Integer, Example> mappedNodeData = new HashMap<Integer, Example>();
        if (nodeDataExampleSet != null) {
            for (Example nodeDataElement : nodeDataExampleSet) {
                int id = (int)nodeDataElement.getValue(nodeDataIdAttribute);
                if (mappedNodeData.get(id) != null) {
                    throw new UserError((Operator)this, "toolkit.graph.wide_data_to_tree.multiple_payload_entries");
                }
                mappedNodeData.put(id, nodeDataElement);
            }
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes);
        List<TreeGraphObject.Node> nodes = tree.getNodes();
        for (TreeGraphObject.Node selectedNode : nodes) {
            Example payload;
            if (!selectedNode.isLeaf()) continue;
            int includeRoot = 0;
            if (this.getParameterAsBoolean(PARAMETER_OMIT_ROOT_NODE)) {
                includeRoot = 1;
            }
            if ((payload = (Example)mappedNodeData.get(selectedNode.id)) != null) {
                for (Attribute addToAttribute : payload.getAttributes()) {
                    if (addToAttribute.getName().equals(nodeDataIdAttribute.getName())) continue;
                    if (addToAttribute.isNominal()) {
                        String value = payload.getValueAsString(addToAttribute);
                        creator.setValue(addToAttribute.getName(), value);
                        continue;
                    }
                    if (!addToAttribute.isNumerical()) continue;
                    double value = payload.getValue(addToAttribute);
                    creator.setValue(addToAttribute.getName(), value);
                }
            }
            creator.setValue(attributeNames[selectedNode.getLevel() - includeRoot], selectedNode.name);
            for (selectedNode = selectedNode.getParent(); !(selectedNode == null || this.getParameterAsBoolean(PARAMETER_OMIT_ROOT_NODE) && selectedNode == root); selectedNode = selectedNode.getParent()) {
                int arrayPosition = selectedNode.getLevel() - includeRoot;
                if (arrayPosition < 0) continue;
                creator.setValue(attributeNames[arrayPosition], selectedNode.name);
            }
            creator.commit();
        }
        this.exampleSetOutputPort.deliver((IOObject)creator.finish());
        this.treeOutputPort.deliver((IOObject)tree);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList(PARAMETER_GROUPS_LIST, "OPTIONAL: This paramter allows you to define the column name for a certain column number.", (ParameterType)new ParameterTypeInt(PARAMETER_COLUMN_NUMBER, "MANDATORY: Please enter the number of the column that is supposed to get a new name.", 1, Integer.MAX_VALUE, false), (ParameterType)new ParameterTypeString(PARAMETER_COLUMN_ATTRIBUTENAME, "MANDATORY: Please enter the new name for the column that is selected through the column number.", false), true);
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_OMIT_ROOT_NODE, "If enabled the root node will not be listed as a group", true);
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_INCLUDE_PAYLOAD, "Add metadata information about each leaf to the resulting exampleSet.", false);
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

