/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.graph;

import com.owc.license.ProductInformation;
import com.owc.objects.TreeGraphObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class WideDataToTreeOperator
extends LicensedOperator {
    private InputPort exampleSetInputPort = this.getInputPorts().createPort("group data input", ExampleSet.class);
    private OutputPort treeOutputPort = (OutputPort)this.getOutputPorts().createPort("tree output");
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("original data through port");
    private static final String PARAMETER_ATTRIBUTE_COLLECTION = "attribute_selection";
    private static final String PARAMETER_ATTRIBUTE_SELECTION = "selected_attributes";
    private static final String PARAMETER_ADD_NODE_DATA = "add_node_data";
    private AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInputPort);

    public WideDataToTreeOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInputPort.addPrecondition(this.selector.makePrecondition());
        this.getTransformer().addGenerationRule(this.treeOutputPort, TreeGraphObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        boolean includePayload = this.getParameterAsBoolean(PARAMETER_ADD_NODE_DATA);
        List<String> selectedAttributeNames = Arrays.asList(ParameterTypeEnumeration.transformString2Enumeration((String)this.getParameterAsString(PARAMETER_ATTRIBUTE_COLLECTION)));
        LinkedList<Attribute> selectedAttributes = new LinkedList<Attribute>();
        LinkedList<String> selectedPayloadAttributeNames = new LinkedList<String>();
        Set selectedPayloadAttributes = this.selector.getAttributeSubset(exampleSet, false);
        for (String attributeName : selectedAttributeNames) {
            Iterator attributesIterator = exampleSet.getAttributes().allAttributes();
            boolean attributeFound = false;
            while (attributesIterator.hasNext() && !attributeFound) {
                Attribute currentAttribute = (Attribute)attributesIterator.next();
                if (!currentAttribute.getName().equals(attributeName)) continue;
                selectedAttributes.add(currentAttribute);
                attributeFound = true;
            }
            if (attributeFound) continue;
            throw new UserError((Operator)this, 160, new Object[]{attributeName});
        }
        int[] payloadTypes = new int[1 + selectedPayloadAttributes.size()];
        payloadTypes[0] = 2;
        int i = 1;
        if (includePayload) {
            for (Attribute selectedAttribute : selectedPayloadAttributes) {
                payloadTypes[i] = selectedAttribute.getValueType();
                ++i;
                if (selectedAttributeNames.contains(selectedAttribute.getName())) {
                    throw new UserError((Operator)this, "toolkit.graph.wide_data_to_tree.duplicate_attributes");
                }
                selectedPayloadAttributeNames.add(selectedAttribute.getName());
            }
        }
        selectedPayloadAttributeNames.add(0, "NodeId");
        String[] selectedPayloadAttributeNamesArray = selectedPayloadAttributeNames.toArray(new String[selectedPayloadAttributeNames.size()]);
        ExampleSetCreator payloadCreator = new ExampleSetCreator(selectedPayloadAttributeNamesArray, payloadTypes);
        TreeGraphObject tree = new TreeGraphObject("", null);
        for (Example example : exampleSet) {
            TreeGraphObject.Node lastFoundNode = tree.getRoot();
            Iterator selectedAttributesIterator = selectedAttributes.iterator();
            boolean allLegalEntriesAdded = false;
            while (selectedAttributesIterator.hasNext() && !allLegalEntriesAdded) {
                Attribute selectedAttrbute = (Attribute)selectedAttributesIterator.next();
                String value = example.getValueAsString(selectedAttrbute);
                if (Double.isNaN(example.getValue(selectedAttrbute))) {
                    value = null;
                }
                if (value != null) {
                    boolean foundParentNode = false;
                    for (TreeGraphObject.Node node : tree.getChildren(lastFoundNode)) {
                        if (!node.equalName(value)) continue;
                        lastFoundNode = node;
                        foundParentNode = true;
                        break;
                    }
                    if (foundParentNode) continue;
                    TreeGraphObject.Node newNode = tree.createNode(value, null);
                    lastFoundNode.add(newNode);
                    lastFoundNode = newNode;
                    continue;
                }
                allLegalEntriesAdded = true;
            }
            if (!includePayload) continue;
            for (Attribute selectedPayloadAttribute : selectedPayloadAttributes) {
                if (selectedPayloadAttribute.isNumerical()) {
                    payloadCreator.setValue(selectedPayloadAttribute.getName(), example.getNumericalValue(selectedPayloadAttribute));
                    continue;
                }
                if (!selectedPayloadAttribute.isNominal()) continue;
                payloadCreator.setValue(selectedPayloadAttribute.getName(), example.getNominalValue(selectedPayloadAttribute));
            }
            payloadCreator.setValue((String)selectedPayloadAttributeNames.get(0), lastFoundNode.id);
            payloadCreator.commit();
        }
        if (includePayload) {
            ExampleSet payload = payloadCreator.finish();
            tree.setPayload(payload);
        }
        this.treeOutputPort.deliver((IOObject)tree);
        this.exampleSetOutputPort.deliver((IOObject)exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute selectAttribute = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_SELECTION, "Select an attribute that is being included in the resulting tree.", this.exampleSetInputPort);
        ParameterTypeEnumeration type = new ParameterTypeEnumeration(PARAMETER_ATTRIBUTE_COLLECTION, "Collection of Attribute names.", (ParameterType)selectAttribute, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_ADD_NODE_DATA, "This allows you to add additional data to a node", false);
        types.add((ParameterType)type);
        for (ParameterType slectorType : this.selector.getParameterTypes()) {
            slectorType.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ADD_NODE_DATA, false, true));
            types.add(slectorType);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

