/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.owc.license.ProductInformation;
import com.owc.objects.files.RemoteFileObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.tools.files.remote.tasks.DeleteRemoteFolderCheck;
import com.owc.tools.files.remote.tasks.DeleteRemoteFolderChildrenCheck;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileTask;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileWithUriTask;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class DeleteRemoteFileOperator
extends LicensedOperator
implements PortProvider {
    public final PortPairExtender throughPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());
    public final InputPort inputFile = (InputPort)this.getInputPorts().createPort("file");
    public static final String PARAMETER_CONNECTION = "connection";
    public static final String PARAMETER_FILE_PATH = "file_path";
    public static final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public static final String PARAMETER_DELAY_BEFORE_RETRIES = "delay";

    public DeleteRemoteFileOperator(OperatorDescription description) {
        super(description);
        this.throughPorts.start();
        this.inputFile.addPrecondition((Precondition)new SimplePrecondition(this.inputFile, new MetaData(RemoteFileObject.class)){

            protected boolean isMandatory() {
                return this.getInputPort().isConnected();
            }
        });
        this.getTransformer().addRule(this.throughPorts.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        FileSystemOptions options;
        RemoteFileConnectionConfigurable config = null;
        boolean useRemoteFileObject = this.inputFile.isConnected();
        int numberOfRetries = this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES);
        long delay = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
        FileSystemManager manager = null;
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            throw new UserError((Operator)this, "toolkit.remote_files.file_system_manager_fail", new Object[]{e.getMessage()});
        }
        FileObject file = null;
        if (useRemoteFileObject) {
            RemoteFileObject remoteFile = (RemoteFileObject)this.inputFile.getData(RemoteFileObject.class);
            file = remoteFile.getVfsFileObject();
            DeleteRemoteFolderChildrenCheck deleteCheck = new DeleteRemoteFolderChildrenCheck(manager, file.getName().getBaseName());
            ResolveRemoteFileTask resolveTask = new ResolveRemoteFileTask(manager, file, deleteCheck);
            try {
                RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(this, resolveTask, delay, numberOfRetries);
            }
            catch (RemoteFileSystemTaskFailedException e) {
                throw e.getUserError();
            }
        }
        String configurableName = this.getParameter(PARAMETER_CONNECTION);
        if (configurableName == null || configurableName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CONNECTION, ""});
        }
        try {
            config = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", configurableName, this.getProcess().getRepositoryAccessor());
            if (config == null) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
            }
        }
        catch (ConfigurationException e) {
            throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
        }
        String filePath = this.getParameter(PARAMETER_FILE_PATH);
        if (filePath == null || filePath.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_FILE_PATH});
        }
        try {
            filePath = config.getVfsUri() + filePath;
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        try {
            options = config.getVfsOptions();
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        DeleteRemoteFolderChildrenCheck delteCheck = new DeleteRemoteFolderChildrenCheck(manager, filePath);
        ResolveRemoteFileWithUriTask resolveTask = new ResolveRemoteFileWithUriTask(manager, filePath, options, delteCheck);
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(this, resolveTask, delay, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        DeleteRemoteFolderCheck deleteRoot = new DeleteRemoteFolderCheck(manager, filePath);
        ResolveRemoteFileWithUriTask resolveSingleDeleteTask = new ResolveRemoteFileWithUriTask(manager, filePath, options, deleteRoot);
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(this, resolveSingleDeleteTask, delay, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        this.throughPorts.passDataThrough();
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_CONNECTION, "Select the targeted remote Filesystem which contains your file.", "RemoteFileConnection");
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FILE_PATH, "Relative path starting from the root directory.", true, false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_RETRIES, "Defines how many times RemoteFileSystem operations may repeatedly fail before they will be declared as failed operation.", 0, Integer.MAX_VALUE, 0, false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_DELAY_BEFORE_RETRIES, "Defines the delay in milliseconds before a failed operation on a remote filesystem will be retried.(Takes effect if Parameter for the number of retries is higher than 0).", 0L, Long.MAX_VALUE, 0L);
        type.setOptional(false);
        types.add((ParameterType)type);
        return types;
    }

    public Port getPort() {
        return this.inputFile;
    }
}

