/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.owc.license.ProductInformation;
import com.owc.objects.files.RemoteFileObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.tools.files.remote.tasks.ExistsRemoteFolderAndFileCheck;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileWithUriTask;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class OpenRemoteFileOperator
extends LicensedOperator {
    public final OutputPort outputFile = (OutputPort)this.getOutputPorts().createPort("file");
    public static final String PARAMETER_CONNECTION = "connection";
    public static final String PARAMETER_FILE_PATH = "file_path";
    public static final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public static final String PARAMETER_DELAY_BEFORE_RETRIES = "delay";

    public OpenRemoteFileOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.outputFile, RemoteFileObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        FileObject remoteFile;
        FileSystemOptions options;
        RemoteFileConnectionConfigurable config = null;
        String configurableName = this.getParameter(PARAMETER_CONNECTION);
        int numberOfRetries = this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES);
        long delay = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
        if (configurableName == null || configurableName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CONNECTION});
        }
        try {
            config = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", configurableName, this.getProcess().getRepositoryAccessor());
            if (config == null) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
            }
        }
        catch (ConfigurationException e) {
            throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
        }
        String filePath = this.getParameter(PARAMETER_FILE_PATH);
        if (filePath == null || filePath.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_FILE_PATH});
        }
        try {
            filePath = config.getVfsUri() + filePath;
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        try {
            options = config.getVfsOptions();
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        FileSystemManager manager = null;
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e) {
            throw new UserError((Operator)this, (Throwable)e, "toolkit.remote_files.file_system_manager_fail", new Object[]{e.getMessage()});
        }
        ExistsRemoteFolderAndFileCheck existensCheck = new ExistsRemoteFolderAndFileCheck(manager, filePath);
        ResolveRemoteFileWithUriTask resolveRemoteFileTask = new ResolveRemoteFileWithUriTask(manager, filePath, options, existensCheck);
        try {
            remoteFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(this, resolveRemoteFileTask, delay, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e1) {
            UserError ue = e1.getUserError();
            ue.setOperator((Operator)this);
            throw ue;
        }
        catch (UserError e) {
            e.setOperator((Operator)this);
            throw e;
        }
        String localFileName = remoteFile.getName().getBaseName();
        RemoteFileObject resultingFileObject = new RemoteFileObject(remoteFile, localFileName, numberOfRetries, delay);
        this.addAnnotation(resultingFileObject, numberOfRetries);
        this.outputFile.deliver((IOObject)resultingFileObject);
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_CONNECTION, "Select the targeted remote Filesystem which contains your file.", "RemoteFileConnection");
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FILE_PATH, "Relative path starting from the root directory.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_RETRIES, "Number of times remote filesystem operations will be retried before they are declared as failed operations.", 0, Integer.MAX_VALUE, 0, false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_DELAY_BEFORE_RETRIES, "Defines the delay in milliseconds before a failed operation on a remote filesystem will be retried.(Takes effect if Parameter for the number of retries is higher than 0).", 0L, Long.MAX_VALUE, 0L);
        types.add((ParameterType)type);
        return types;
    }

    private void addAnnotation(RemoteFileObject remoteFileObject, int maxTry) throws OperatorException {
        Annotations annotations = remoteFileObject.getAnnotations();
        annotations.setAnnotation("Filename", remoteFileObject.getFilename());
        annotations.setAnnotation("Source", remoteFileObject.getSource());
    }
}

