/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.io;

import com.owc.license.ProductInformation;
import com.owc.objects.files.RemoteFileObject;
import com.owc.operator.LicensedOperator;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.tools.files.remote.tasks.CopyLocalFileToRemoteFileCheck;
import com.owc.tools.files.remote.tasks.NotExistsRemoteFolderAndFileCheck;
import com.owc.tools.files.remote.tasks.RefreshRemoteFileObjectCheck;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileWithUriTask;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class WriteRemoteFileOperator
extends LicensedOperator {
    public static final String PARAMETER_CONNECTION = "connection";
    public static final String PARAMETER_DIRECTORY = "file_entry";
    public static final String PARAMETER_OVERWRITE_EXISTING_ENTRY = "overwrite_existing_entry";
    public static final String PARAMETER_DELAY_BEFORE_RETRIES = "delay";
    public static final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public final InputPort inputFile = (InputPort)this.getInputPorts().createPort("file");
    public final OutputPort outputFile = (OutputPort)this.getOutputPorts().createPort("file");
    public final OutputPort outputRemoteFile = (OutputPort)this.getOutputPorts().createPort("remote file");

    public WriteRemoteFileOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.inputFile, this.outputFile);
        this.getTransformer().addGenerationRule(this.outputRemoteFile, RemoteFileObject.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        FileObject remoteFile;
        FileSystemOptions options;
        com.rapidminer.operator.nio.file.FileObject input = (com.rapidminer.operator.nio.file.FileObject)this.inputFile.getData(com.rapidminer.operator.nio.file.FileObject.class);
        boolean overwriteFiles = this.getParameterAsBoolean(PARAMETER_OVERWRITE_EXISTING_ENTRY);
        int numberOfRetries = this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES);
        long delayMillis = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
        String filePath = this.getParameter(PARAMETER_DIRECTORY);
        if (filePath == null || filePath.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_DIRECTORY});
        }
        String configurableName = this.getParameter(PARAMETER_CONNECTION);
        if (configurableName == null || configurableName.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_CONNECTION});
        }
        if (input == null) {
            throw new UserError((Operator)this, 149, new Object[]{this.inputFile.getName()});
        }
        RemoteFileConnectionConfigurable config = null;
        try {
            config = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", configurableName, this.getProcess().getRepositoryAccessor());
            if (config == null) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
        }
        try {
            filePath = config.getVfsUri() + filePath;
            options = config.getVfsOptions();
        }
        catch (UserError ue) {
            ue.setOperator((Operator)this);
            throw ue;
        }
        FileSystemManager manager = null;
        try {
            manager = AdvancedVFS.getManager();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            throw new UserError((Operator)this, "toolkit.remote_files.file_system_manager_fail", new Object[]{e.getMessage()});
        }
        RefreshRemoteFileObjectCheck refreshCheck = new RefreshRemoteFileObjectCheck(manager);
        NotExistsRemoteFolderAndFileCheck nonExistenceCheck = new NotExistsRemoteFolderAndFileCheck(manager, filePath);
        CopyLocalFileToRemoteFileCheck copyCheck = new CopyLocalFileToRemoteFileCheck(manager, input, filePath);
        ResolveRemoteFileWithUriTask resolveOutputFile = overwriteFiles ? new ResolveRemoteFileWithUriTask(manager, filePath, options, refreshCheck, copyCheck) : new ResolveRemoteFileWithUriTask(manager, filePath, options, refreshCheck, nonExistenceCheck, copyCheck);
        try {
            remoteFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(this, resolveOutputFile, delayMillis, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e1) {
            throw e1.getUserError();
        }
        RemoteFileObject resultingRemoteFile = new RemoteFileObject(remoteFile, input.getName(), numberOfRetries, delayMillis);
        this.addAnnotation(resultingRemoteFile);
        this.outputRemoteFile.deliver((IOObject)resultingRemoteFile);
        this.outputFile.deliver((IOObject)input);
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_CONNECTION, "Please select the targeted Fileysystem where the provided file will be safed at.", "RemoteFileConnection");
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_DIRECTORY, "Please select a direcotry realtive to the selected root.", false, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_OVERWRITE_EXISTING_ENTRY, "Overwrites existing files with the same name", true, false);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_RETRIES, "Defines how many times RemoteFileSystem operations may repeatedly fail before they will be declared as failed operation.", 0, Integer.MAX_VALUE, 0, false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_DELAY_BEFORE_RETRIES, "Defines the delay in milliseconds before a failed operation on a remote filesystem will be retried.(Takes effect if Parameter for the number of retries is higher than 0).", 0L, Long.MAX_VALUE, 0L);
        type.setOptional(false);
        types.add((ParameterType)type);
        return types;
    }

    private void addAnnotation(RemoteFileObject remoteFileObject) throws OperatorException {
        Annotations annotations = remoteFileObject.getAnnotations();
        annotations.setAnnotation("Filename", remoteFileObject.getFilename());
        annotations.setAnnotation("Source", remoteFileObject.getSource());
    }
}

