/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.learner.meta;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedModel;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.tools.Ontology;
import java.util.LinkedHashMap;
import java.util.List;

public class ExtendIndexedModelOperator
extends LicensedOperator {
    public InputPort indexedModelInputPort = (InputPort)this.getInputPorts().createPort("indexed_model");
    public InputPort modelInputPort = this.getInputPorts().createPort("model", Model.class);
    public OutputPort indexedModelOutputPort = (OutputPort)this.getOutputPorts().createPort("indexed_model");
    public static String PARAMETER_GROUP_INFORMATION = "group_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_INFORMATION = "group_attribute_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_NAME = "attribute_name";
    public static String PARAMETER_GROUP_ATTRIBUTE_TYPE = "attribute_type";
    public static String PARAMETER_GROUP_ATTRIBUTE_VALUE = "value";
    public static String PARAMETER_ENABLE_PARALLEL_EXECUTION = "parallel_execution";

    public ExtendIndexedModelOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.indexedModelOutputPort, IndexedModel.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        Model model;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean enableParallelExecution = this.getParameterAsBoolean(PARAMETER_ENABLE_PARALLEL_EXECUTION);
        IndexedModel indexedModel = (IndexedModel)this.indexedModelInputPort.getDataOrNull(IndexedModel.class);
        if (indexedModel != null) {
            indexedModel = indexedModel.clone();
        }
        if ((model = (Model)this.modelInputPort.getDataOrNull(Model.class)) == null) {
            throw new UserError((Operator)this, 123, new Object[]{Model.class, 1});
        }
        List groupInfos = this.getParameterList(PARAMETER_GROUP_INFORMATION);
        String[] selectedGroupAttributes = new String[groupInfos.size()];
        int[] selectedGroupAttributeType = new int[groupInfos.size()];
        String[] nominalValues = new String[groupInfos.size()];
        double[] numericalValues = new double[groupInfos.size()];
        if (groupInfos.isEmpty()) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_GROUP_INFORMATION, "Please provide the attribute names, types and values for each group."});
        }
        int i = 0;
        for (String[] currentGroupInfo : groupInfos) {
            String attributeInfo = currentGroupInfo[0];
            String currentGroupValue = currentGroupInfo[1];
            String[] attributeInfoPair = ParameterTypeTupel.transformString2Tupel((String)attributeInfo);
            String currentAttributeName = attributeInfoPair[0];
            String currentAttributeType = attributeInfoPair[1];
            if (currentAttributeName == null) {
                throw new UserError((Operator)this, 205, new Object[]{PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each group attribute name."});
            }
            selectedGroupAttributes[i] = currentAttributeName;
            if (currentAttributeType.equals(Ontology.VALUE_TYPE_NAMES[1])) {
                nominalValues[i] = currentGroupValue;
                selectedGroupAttributeType[i] = 1;
            } else {
                try {
                    numericalValues[i] = Double.parseDouble(currentGroupValue);
                    selectedGroupAttributeType[i] = 2;
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 120, new Object[]{currentAttributeName, Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]});
                }
            }
            ++i;
        }
        IndexedIOObject.IndexedIOObjectKey newKey = new IndexedIOObject.IndexedIOObjectKey(nominalValues, numericalValues);
        if (indexedModel == null) {
            ExampleSetCreator creator = new ExampleSetCreator(selectedGroupAttributes, selectedGroupAttributeType);
            indexedModel = new IndexedModel(creator.finish(), new LinkedHashMap<IndexedIOObject.IndexedIOObjectKey, Model>(), selectedGroupAttributes, selectedGroupAttributeType, enableParallelExecution);
        } else {
            int selectedAttributeSize;
            int indexAttributeSize = indexedModel.getIndexColumnTypes().length;
            if (indexAttributeSize != (selectedAttributeSize = selectedGroupAttributes.length)) {
                throw new UserError((Operator)this, "toolkit.incompatible_indexed_models", new Object[]{"index attributessize:" + indexAttributeSize, "selected attributessize:" + selectedAttributeSize});
            }
            String[] attributeNames = indexedModel.getIndexColumnNames();
            for (i = 0; i < selectedAttributeSize; ++i) {
                if (!attributeNames[i].equals(selectedGroupAttributes[i])) {
                    throw new UserError((Operator)this, "toolkit.incompatible_indexed_models", new Object[]{attributeNames[i], selectedGroupAttributes[i]});
                }
                if (selectedGroupAttributeType[i] != indexedModel.getIndexColumnTypes()[i]) {
                    throw new UserError((Operator)this, "toolkit.incompatible_indexed_models", new Object[]{attributeNames[i] + "-" + Ontology.VALUE_TYPE_NAMES[indexedModel.getIndexColumnTypes()[i]], selectedGroupAttributes[i] + "-" + selectedGroupAttributeType[i]});
                }
                ++i;
            }
        }
        indexedModel.put(newKey, model);
        this.indexedModelOutputPort.deliver((IOObject)indexedModel);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ENABLE_PARALLEL_EXECUTION, "If enabled the resulting indexModel will later on be applied parallely onto each group batch.", true, false);
        types.add((ParameterType)type);
        ParameterTypeString parameterAttributeName = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each attribute that contains group information. If an indexedModel is provided, the selected Group attributes must be using matching names in the same order!", false);
        ParameterTypeCategory parameterAttributeType = new ParameterTypeCategory(PARAMETER_GROUP_ATTRIBUTE_TYPE, "Please select if the group attribute is either nominal or numerical.", new String[]{Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]}, 0, false);
        ParameterTypeTupel parameterGroupAttribute = new ParameterTypeTupel(PARAMETER_GROUP_ATTRIBUTE_INFORMATION, "Please provide Information on the respective attribute- name and type.", new ParameterType[]{parameterAttributeName, parameterAttributeType});
        ParameterTypeString parameterValue = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_VALUE, "Please provide a value for the provided Group Attribute.", false, false);
        type = new ParameterTypeList(PARAMETER_GROUP_INFORMATION, "This Parameter contains information on attributename, type and value of each listed group attribute.", (ParameterType)parameterGroupAttribute, (ParameterType)parameterValue, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

