/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class LoopBatchesOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_BATCH_SIZE = "batch_size";
    public static final String PARAMETER_KEEP_GROUPS_TOGETHER = "keep_groups_together";
    private final InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", (MetaData)new ExampleSetMetaData());
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("batch of example set");
    private AttributeSubsetSelector groupAttributesSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInputPort);

    public LoopBatchesOperator(OperatorDescription description) {
        super(description, "Batch Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new PassThroughRule(this.exampleSetInputPort, this.exampleSetInnerSource, false));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        Object set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        if (set.size() > 0) {
            int batchSize = this.getParameterAsInt(PARAMETER_BATCH_SIZE);
            boolean keepGroupsTogether = this.getParameterAsBoolean(PARAMETER_KEEP_GROUPS_TOGETHER);
            LinkedList attributeSubset = null;
            if (keepGroupsTogether && (attributeSubset = new LinkedList(this.groupAttributesSubsetSelector.getAttributeSubset(set, false))).isEmpty()) {
                throw new UserError((Operator)this, 153, new Object[]{1, 0});
            }
            int[] batchLimits = new int[set.size() * 2 / batchSize + 1];
            int numberOfBatches = 0;
            if (!keepGroupsTogether || set.size() == 0) {
                for (int batchLimit = batchSize; batchLimit < set.size(); batchLimit += batchSize) {
                    batchLimits[numberOfBatches] = batchLimit;
                    ++numberOfBatches;
                }
                batchLimits[numberOfBatches] = set.size();
                ++numberOfBatches;
            } else {
                set = new SortedExampleSet((ExampleSet)set, 1, true, attributeSubset.toArray(new Attribute[0]));
                int[] groupLimits = new int[set.size()];
                double[] groupValues = new double[attributeSubset.size()];
                double[] currentValues = new double[attributeSubset.size()];
                int numberOfGroups = 0;
                int exampleIndex = 0;
                for (Example example : set) {
                    int i = 0;
                    for (Attribute attribute : attributeSubset) {
                        currentValues[i] = example.getValue(attribute);
                        ++i;
                    }
                    if (exampleIndex == 0) {
                        System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                    } else if (!Arrays.equals(groupValues, currentValues)) {
                        groupLimits[numberOfGroups++] = exampleIndex;
                        System.arraycopy(currentValues, 0, groupValues, 0, groupValues.length);
                    }
                    ++exampleIndex;
                }
                groupLimits[numberOfGroups++] = set.size();
                int batchStart = 0;
                for (int i = 0; i < numberOfGroups; ++i) {
                    if (i + 1 >= numberOfGroups || groupLimits[i + 1] - batchStart <= batchSize) continue;
                    batchLimits[numberOfBatches] = groupLimits[i];
                    ++numberOfBatches;
                    batchStart = groupLimits[i];
                }
                batchLimits[numberOfBatches] = groupLimits[numberOfGroups - 1];
                ++numberOfBatches;
            }
            int[] partition = new int[set.size()];
            int batch = 0;
            for (int i = 0; i < set.size(); ++i) {
                if (i == batchLimits[batch]) {
                    // empty if block
                }
                partition[i] = ++batch;
            }
            SplittedExampleSet splittedSet = new SplittedExampleSet(set, new Partition(partition, numberOfBatches));
            boolean executeParallely = this.checkParallelizability();
            if (executeParallely) {
                this.doLoopAsynchronously(numberOfBatches, splittedSet, inputData);
            } else {
                this.doLoopSynchronously(numberOfBatches, splittedSet, inputData);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopAsynchronously(int numberOfBatches, final SplittedExampleSet splittedSet, final List<IOObject> inputData) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        for (int i = 0; i < numberOfBatches; ++i) {
            final int currentIteration = i;
            final LoopBatchesOperator copy = (LoopBatchesOperator)this.cloneOperator(this.getName(), true);
            Callable operatorTask = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration + 1, currentIteration + 1 == numberOfBatches, (Callable)new Callable<List<IOObject>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<IOObject> call() throws Exception {
                    ExampleSet batchSet;
                    copy.inputExtender.deliver(LoopBatchesOperator.this.getDataCopy(inputData));
                    SplittedExampleSet splittedExampleSet = splittedSet;
                    synchronized (splittedExampleSet) {
                        splittedSet.selectSingleSubset(currentIteration);
                        batchSet = (ExampleSet)LoopBatchesOperator.this.getDataCopy((IOObject)splittedSet);
                    }
                    return copy.performBatch(batchSet);
                }
            });
            tasks.add(operatorTask);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResults : results) {
            int i = 0;
            for (IOObject result : loopResults) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private void doLoopSynchronously(int numberOfBatches, SplittedExampleSet splittedSet, List<IOObject> inputData) throws ProcessStoppedException, OperatorException, UserError {
        this.loopExtender.deliver(this.getDataCopy(inputData));
        for (int i = 0; i < numberOfBatches; ++i) {
            this.inApplyLoop();
            this.inputExtender.deliver(this.getDataCopy(inputData));
            splittedSet.selectSingleSubset(i);
            ExampleSet batchSet = (ExampleSet)this.getDataCopy((IOObject)splittedSet);
            try {
                this.performBatch(batchSet);
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
            this.outputExtender.collect();
        }
    }

    private List<IOObject> performBatch(ExampleSet batchSet) throws OperatorException, UserError {
        try {
            this.exampleSetInnerSource.deliver((IOObject)batchSet);
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ParameterType type2;
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_BATCH_SIZE, "The target size of the batch. If groups are kept together, the actual batch size might differ to contain the entire group.", 1, Integer.MAX_VALUE, 10000, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_KEEP_GROUPS_TOGETHER, "If checked, you can select a number of attributes that are used to identify groups. All examples of a group are guaranteed to be contained in the same batch.", false, false));
        List subsetSelectorTypes = this.groupAttributesSubsetSelector.getParameterTypes();
        for (ParameterType type2 : subsetSelectorTypes) {
            type2.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_KEEP_GROUPS_TOGETHER, true, true));
        }
        types.addAll(subsetSelectorTypes);
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        type2 = superTypes.get(0);
        if (types.remove(type2)) {
            types.add(0, type2);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

