/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class LoopOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_NUMBER_OF_ITERATIONS = "number_of_iterations";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";

    public LoopOperator(OperatorDescription description) {
        super(description, "Loop");
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        boolean executeParallely = this.checkParallelizability();
        if (executeParallely) {
            this.doLoopAsynchronously(inputData);
        } else {
            this.doLoopSynchronously(inputData);
        }
    }

    private void doLoopAsynchronously(final List<IOObject> inputData) throws OperatorException {
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        int numberOfIterations = this.getParameterAsInt(PARAMETER_NUMBER_OF_ITERATIONS);
        final boolean setIterationMacro = this.isParameterSet(PARAMETER_ITERATION_MACRO);
        String iterationMacroNameCopy = null;
        if (setIterationMacro) {
            iterationMacroNameCopy = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        }
        final String iterationMacroName = iterationMacroNameCopy;
        if (numberOfIterations > 0) {
            for (int i = 0; i < numberOfIterations; ++i) {
                final String iterationMacroValue = i + "";
                final LoopOperator copy = (LoopOperator)this.cloneOperator(this.getName(), true);
                Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, i + 1, i + 1 == numberOfIterations, (Callable)new Callable<List<IOObject>>(){

                    @Override
                    public List<IOObject> call() throws Exception {
                        copy.inputExtender.deliver(LoopOperator.this.getDataCopy(inputData));
                        if (setIterationMacro) {
                            copy.getProcess().getMacroHandler().addMacro(iterationMacroName, iterationMacroValue);
                        }
                        return copy.performIteration();
                    }
                });
                tasks.add(task);
            }
            List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
            List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
            for (List loopResult : results) {
                int i = 0;
                for (IOObject result : loopResult) {
                    managedPairs.get(i++).getInputPort().receive(result);
                }
                this.outputExtender.collect();
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopSynchronously(List<IOObject> inputData) throws ProcessStoppedException, OperatorException, UserError {
        this.loopExtender.deliver(this.getDataCopy(inputData));
        int numberOfIterations = this.getParameterAsInt(PARAMETER_NUMBER_OF_ITERATIONS);
        for (int i = 0; i < numberOfIterations; ++i) {
            if (this.isParameterSet(PARAMETER_ITERATION_MACRO)) {
                this.getProcess().getMacroHandler().addMacro(this.getParameterAsString(PARAMETER_ITERATION_MACRO), i + "");
            }
            this.inApplyLoop();
            this.inputExtender.deliver(this.getDataCopy(inputData));
            try {
                this.performIteration();
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
            this.outputExtender.collect();
        }
    }

    private List<IOObject> performIteration() throws OperatorException, UserError {
        try {
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_NUMBER_OF_ITERATIONS, "The number of times that the inner process will be executed.", 0, Integer.MAX_VALUE, false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_ITERATION_MACRO, "Name of a macro that will contain the current iteration. Can be left blank if no macro is needed.", true, false));
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        ParameterType type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, type);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

