/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.license.ProductInformation;
import com.owc.objects.files.RemoteFileObject;
import com.owc.objects.files.RemoteFiles;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.process.ports.OneToOneExtender;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurable;
import com.owc.tools.files.remote.tasks.DeliverRemoteFileObjectToOutputport;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileWithUriTask;
import com.owc.vfs2.impl.AdvancedVFS;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import com.rapidminer.studio.concurrency.internal.ConcurrencyExecutionServiceProvider;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class LoopRemoteFilesOperator
extends ParallelLoopingOperatorChain
implements PortProvider {
    public static final String KEY_CURRENT_LOCAL_LOCATION = "Current Local Location";
    public static final String KEY_CURRENT_LOCAL_NAME = "Current Local Name";
    private FileSystemManager manager = null;
    public static final String PARAMETER_PATH_ATTRIBUTE = "path_attribute";
    public static final String PARAMETER_DIRECTORY = "directory";
    public static final String PARAMETER_FILTER_TYPE = "filter_type";
    public static final String PARAMETER_FILTER_REGEXP = "filter_by_regex";
    public static final String PARAMETER_FILTER_GLOBB = "filter_by_glob";
    public static final String PARAMETER_ENABLE_MACROS = "enable_macros";
    public static final String PARAMETER_FILE_NAME_MACRO = "macro_for_file_name";
    public static final String PARAMETER_FILE_TYPE_MACRO = "macro_for_file_type";
    public static final String PARAMETER_FOLDER_NAME_MACRO = "macro_for_folder_name";
    public static final String PARAMETER_REMOTE_FILE_CONNECTION = "connection";
    public static final String PARAMETER_FILTER_REGEX_PATH = "filter_path_by_regex";
    public static final String PARAMETER_FILTER_REGEX_NAME = "filter_name_by_regex";
    public static final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public static final String PARAMETER_DELAY_BEFORE_RETRIES = "delay";
    private final InputPort fileSetInputPort = (InputPort)this.getInputPorts().createPort("reference set");
    private final OutputPort fileObjectInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("file object");

    public LoopRemoteFilesOperator(OperatorDescription description) {
        super(description, "File Processing");
        this.fileSetInputPort.addPrecondition((Precondition)new AttributeSetPrecondition(this.fileSetInputPort, AttributeSetPrecondition.getAttributesByParameter((ParameterHandler)this, (String[])new String[]{PARAMETER_PATH_ATTRIBUTE}), new String[0]));
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new GenerateNewMDRule(this.fileObjectInnerSource, RemoteFileObject.class));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        String rootURIString;
        Iterator<String[]> fileIterator;
        List<IOObject> inputData;
        FileSystemOptions options;
        block33: {
            String relativeStartDirectory;
            String filePath;
            if (!isLicensed) {
                throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
            }
            RemoteFileConnectionConfigurable config = null;
            String configurableName = this.getParameter(PARAMETER_REMOTE_FILE_CONNECTION);
            if (configurableName == null || configurableName.isEmpty()) {
                throw new UserError((Operator)this, 205, new Object[]{PARAMETER_REMOTE_FILE_CONNECTION});
            }
            try {
                config = (RemoteFileConnectionConfigurable)ConfigurationManager.getInstance().lookup("RemoteFileConnection", configurableName, this.getProcess().getRepositoryAccessor());
                if (config == null) {
                    throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
                }
            }
            catch (ConfigurationException e) {
                throw new UserError((Operator)this, "toolkit.remote_files.retrieve_configurable");
            }
            try {
                filePath = config.getVfsUri();
                options = config.getVfsOptions();
            }
            catch (UserError ue) {
                ue.setOperator((Operator)this);
                throw ue;
            }
            try {
                this.manager = AdvancedVFS.getManager();
            }
            catch (FileSystemException e) {
                e.printStackTrace();
                throw new UserError((Operator)this, "toolkit.remote_files.file_system_manager_fail", new Object[]{e.getMessage()});
            }
            inputData = this.inputExtender.getDataOrNull(IOObject.class);
            ExampleSet set = (ExampleSet)this.fileSetInputPort.getDataOrNull(ExampleSet.class);
            fileIterator = null;
            try {
                relativeStartDirectory = this.getParameterAsString(PARAMETER_DIRECTORY);
            }
            catch (UndefinedParameterError e) {
                relativeStartDirectory = "";
            }
            String startDirectory = relativeStartDirectory != null ? (filePath + relativeStartDirectory).replace("\\", "/") : filePath.replaceAll("\\\\", "/");
            try (FileObject startDirectoryFile = this.manager.resolveFile(startDirectory, options);){
                rootURIString = startDirectoryFile.getPublicURIString();
                if (set != null) {
                    String pathAttributeName = this.getParameterAsString(PARAMETER_PATH_ATTRIBUTE);
                    Attribute pathAttribute = set.getAttributes().get(pathAttributeName);
                    if (pathAttribute == null) {
                        throw new UserError((Operator)this, 160, new Object[]{pathAttributeName});
                    }
                    Iterator setIterator = set.iterator();
                    fileIterator = new TableBasedFileIterator(pathAttribute, setIterator, this.manager, options, rootURIString);
                    break block33;
                }
                startDirectoryFile.refresh();
                try {
                    ScanningFileIteratorFilterMethod filterType = ScanningFileIteratorFilterMethod.getValueOf(this.getParameterAsString(PARAMETER_FILTER_TYPE));
                    fileIterator = filterType == ScanningFileIteratorFilterMethod.GLOB ? new ScanningFileIterator(startDirectoryFile, this.getParameterAsString(PARAMETER_FILTER_GLOBB), null, filterType, rootURIString, this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES), this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES)) : (filterType == ScanningFileIteratorFilterMethod.REGEX ? new ScanningFileIterator(startDirectoryFile, this.getParameterAsString(PARAMETER_FILTER_REGEXP), null, filterType, rootURIString, this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES), this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES)) : new ScanningFileIterator(startDirectoryFile, this.getParameterAsString(PARAMETER_FILTER_REGEX_PATH), this.getParameterAsString(PARAMETER_FILTER_REGEX_NAME), filterType, rootURIString, this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES), this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES)));
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, "io.directory_not_found", new Object[]{this.getParameterAsString(PARAMETER_DIRECTORY)});
                }
            }
            catch (FileSystemException e) {
                e.printStackTrace();
                throw new UserError((Operator)this, (Throwable)e, "toolkit.remote_files.resolve_file", new Object[]{startDirectory, e.getMessage()});
            }
        }
        if (fileIterator.hasNext()) {
            if (this.checkParallelizability()) {
                this.doLoopAsynchronously(inputData, fileIterator, options, rootURIString);
            } else {
                this.doLoopSynchronously(inputData, fileIterator, options, rootURIString);
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private void doLoopSynchronously(List<IOObject> inputData, Iterator<String[]> iterator, FileSystemOptions options, String rootURIString) throws UndefinedParameterError, ProcessStoppedException, OperatorException, UserError {
        this.inputExtender.deliver(this.getDataCopy(inputData));
        if (this.loopExtender.isConnected()) {
            this.loopExtender.deliver(this.getDataCopy(inputData));
        }
        while (iterator.hasNext()) {
            long delayMillis;
            int numberOfRetries;
            String[] fileInfo = iterator.next();
            if (fileInfo == null) continue;
            String relativeFileUrl = fileInfo[1] + fileInfo[0];
            String fileURL = rootURIString + relativeFileUrl;
            try {
                numberOfRetries = this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES);
            }
            catch (UndefinedParameterError e) {
                numberOfRetries = 0;
            }
            try {
                delayMillis = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
            }
            catch (UndefinedParameterError e) {
                delayMillis = 0L;
            }
            DeliverRemoteFileObjectToOutputport deliverFile = new DeliverRemoteFileObjectToOutputport(this.manager, this.fileObjectInnerSource);
            ResolveRemoteFileWithUriTask resolveTask = new ResolveRemoteFileWithUriTask(this.manager, fileURL, options, deliverFile);
            try {
                if (this.fileObjectInnerSource.isConnected()) {
                    RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask((Operator)this, resolveTask, delayMillis, numberOfRetries);
                }
            }
            catch (RemoteFileSystemTaskFailedException e) {
                throw e.getUserError();
            }
            this.setMacros(fileInfo[0], fileInfo[1]);
            this.inApplyLoop();
            try {
                this.getSubprocess(0).execute();
                if (this.loopExtender.isConnected()) {
                    this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
                }
                this.outputExtender.collect();
            }
            catch (SkipIterationException si) {
                si.finishSkippedOperators((Operator)this);
            }
            catch (BreakIterationException e) {
                e.finishBrokenOperators((Operator)this);
                break;
            }
        }
    }

    private void doLoopAsynchronously(List<IOObject> inputData, Iterator<String[]> iterator, final FileSystemOptions options, String rootURIString) throws OperatorException {
        int currentIteration = 0;
        LinkedList<Callable> tasks = new LinkedList<Callable>();
        while (iterator.hasNext()) {
            String[] fileInfo = iterator.next();
            if (fileInfo == null) continue;
            String relativeFilePath = fileInfo[1] + fileInfo[0];
            final String fileUrl = rootURIString + relativeFilePath;
            final LoopRemoteFilesOperator copy = (LoopRemoteFilesOperator)this.cloneOperator(this.getName(), true);
            final int numberOfRetries = this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES);
            final long delayMillis = this.getParameterAsLong(PARAMETER_DELAY_BEFORE_RETRIES);
            LoopRemoteFilesOperator op = this;
            Callable task = ConcurrencyExecutionServiceProvider.INSTANCE.getService().prepareOperatorTask(this.getProcess(), (Operator)copy, currentIteration++, !iterator.hasNext(), (Callable)new Callable<List<IOObject>>((Operator)op, inputData, fileInfo){
                final /* synthetic */ Operator val$op;
                final /* synthetic */ List val$inputData;
                final /* synthetic */ String[] val$fileInfo;
                {
                    this.val$op = operator;
                    this.val$inputData = list;
                    this.val$fileInfo = stringArray;
                }

                @Override
                public List<IOObject> call() throws Exception {
                    DeliverRemoteFileObjectToOutputport deliverFile = new DeliverRemoteFileObjectToOutputport(LoopRemoteFilesOperator.this.manager, copy.fileObjectInnerSource);
                    ResolveRemoteFileWithUriTask resolveTask = new ResolveRemoteFileWithUriTask(LoopRemoteFilesOperator.this.manager, fileUrl, options, deliverFile);
                    try {
                        if (copy.fileObjectInnerSource.isConnected()) {
                            RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask((Operator)copy, resolveTask, delayMillis, numberOfRetries);
                        }
                    }
                    catch (RemoteFileSystemTaskFailedException e) {
                        UserError ue = e.getUserError();
                        ue.setOperator(this.val$op);
                        throw ue;
                    }
                    copy.inputExtender.deliver(LoopRemoteFilesOperator.this.getDataCopy(this.val$inputData));
                    copy.setMacros(this.val$fileInfo[0], this.val$fileInfo[1]);
                    copy.inApplyLoop();
                    try {
                        copy.getSubprocess(0).execute();
                    }
                    catch (SkipIterationException e) {
                        e.finishSkippedOperators((Operator)copy);
                        return new LinkedList<IOObject>();
                    }
                    return copy.outputExtender.getDataOrNull(IOObject.class);
                }
            });
            tasks.add(task);
        }
        List results = ConcurrencyExecutionServiceProvider.INSTANCE.getService().executeOperatorTasks((Operator)this, tasks);
        List<OneToOneExtender.PortPair> managedPairs = this.outputExtender.getManagedPairs();
        for (List loopResults : results) {
            int i = 0;
            for (IOObject result : loopResults) {
                managedPairs.get(i++).getInputPort().receive(result);
            }
            this.outputExtender.collect();
        }
    }

    private void setMacros(String fileName, String relativeParentUri) throws UndefinedParameterError {
        if (this.getParameterAsBoolean(PARAMETER_ENABLE_MACROS)) {
            String nameMacro = this.getParameterAsString(PARAMETER_FILE_NAME_MACRO);
            String typeMacro = this.getParameterAsString(PARAMETER_FILE_TYPE_MACRO);
            String folderMacro = this.getParameterAsString(PARAMETER_FOLDER_NAME_MACRO);
            if (nameMacro != null && !nameMacro.isEmpty()) {
                this.getProcess().getMacroHandler().addMacro(nameMacro, fileName);
            }
            if (folderMacro != null && !folderMacro.isEmpty()) {
                this.getProcess().getMacroHandler().addMacro(folderMacro, relativeParentUri);
            }
            if (typeMacro != null && !typeMacro.isEmpty()) {
                String fileExtension = FilenameUtils.getExtension(fileName);
                this.getProcess().getMacroHandler().addMacro(typeMacro, fileExtension);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_REMOTE_FILE_CONNECTION, "Please select a \"Remote File Connection\" which will be used to retrieve the remote filesystem.", "RemoteFileConnection");
        type.setOptional(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_DIRECTORY, "Select the directory from where to start scanning for files.", true));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_FILTER_TYPE, "Specifies how to filter file names. You can either use standard, command shell like globb filtering or a regular expression.", ScanningFileIteratorFilterMethod.getValuesAsString(), 0, false));
        type = new ParameterTypeString(PARAMETER_FILTER_GLOBB, "Specifies a globb expression which is used as filter for the file and directory names. It is more simple than regular expressions. A detailed explanation can be found in the help, but it is as used from operating systems. Ignored if empty.", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.GLOB.getFilterType()}));
        types.add((ParameterType)type);
        type = new ParameterTypeRegexp(PARAMETER_FILTER_REGEXP, "Specifies a regular expression which is used as filter for the file and directory names, e.g. 'a.*b' for all files starting with 'a' and ending with 'b'. Ignored if empty.", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.REGEX.getFilterType()}));
        types.add((ParameterType)type);
        type = new ParameterTypeRegexp(PARAMETER_FILTER_REGEX_PATH, "Specifies a regular expression which is used as filter for the directory names, e.g. 'a.*b' for all files placed in a path where the name is starting with 'a' and ending with 'b'. Parameter will be Ignored if empty. The relative path of the parent folder ends with its name and does not end with a path separator (slash or backslash).", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.REGEX_PATH_AND_NAME.getFilterType()}));
        types.add((ParameterType)type);
        type = new ParameterTypeRegexp(PARAMETER_FILTER_REGEX_NAME, "Specifies a regular expression which is used as filter for the file names, e.g. 'a.*b' for all files where the name is starting with 'a' and ending with 'b'. Parameter will be Ignored if empty.", true, false);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_FILTER_TYPE, false, new String[]{ScanningFileIteratorFilterMethod.REGEX_PATH_AND_NAME.getFilterType()}));
        types.add((ParameterType)type);
        for (ParameterType type2 : types) {
            type2.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, false, false));
        }
        type = new ParameterTypeAttribute(PARAMETER_PATH_ATTRIBUTE, "Select the attribute of the given example set that contains the file paths.", this.fileSetInputPort, new int[]{1});
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, (PortProvider)this, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_MACROS, "If checked, the operator will set macros with file depending values as name, path or type. This allows to get some control in the subprocess.", false));
        type = new ParameterTypeString(PARAMETER_FILE_NAME_MACRO, "If filled, a macro with this name will be set to the name of the current entry. To get access on the full relative path to the targeted starting directory, combine this with the folder macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FILE_TYPE_MACRO, "Will be set to the file's extension. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_FOLDER_NAME_MACRO, "If filled, a macro with this name will be set to the relative path of the containing folder of the current file to the targeted starting directory. To get access on the full relative path you can combine this with the name macro. Can be left blank.", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_MACROS, false, true));
        types.add((ParameterType)type);
        for (ParameterType currentType : types) {
            currentType.setExpert(false);
        }
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_RETRIES, "Defines how many times operations for each file on the remote filesystem will be retried before an error will be declared.", 0, Integer.MAX_VALUE, 0, true);
        type.setExpert(false);
        type.setOptional(false);
        types.add((ParameterType)type);
        type = new ParameterTypeLong(PARAMETER_DELAY_BEFORE_RETRIES, "Defines the delay in milliseconds before a failed operation on a remote filesystem will be retried.(Takes effect if Parameter for the number of retries is higher than 0).", 0L, Long.MAX_VALUE, 0L);
        type.setOptional(false);
        type.setExpert(false);
        types.add((ParameterType)type);
        List<ParameterType> superTypes = super.getParameterTypes();
        types.addAll(superTypes);
        type = superTypes.get(0);
        if (types.remove(type)) {
            types.add(0, (ParameterType)type);
        }
        return types;
    }

    public Port getPort() {
        return this.fileSetInputPort;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    private final class TableBasedFileIterator
    implements Iterator<String[]> {
        private final Attribute pathAttribute;
        private final Iterator<Example> setIterator;
        private final FileSystemManager manager;
        private final FileSystemOptions options;
        private final String rootUri;

        private TableBasedFileIterator(Attribute pathAttribute, Iterator<Example> setIterator, FileSystemManager manager, FileSystemOptions options, String rootUri) {
            this.pathAttribute = pathAttribute;
            this.setIterator = setIterator;
            this.manager = manager;
            this.options = options;
            this.rootUri = rootUri;
        }

        @Override
        public String[] next() {
            Example next = this.setIterator.next();
            if (Double.isNaN(next.getValue(this.pathAttribute))) {
                return null;
            }
            String relativePath = next.getNominalValue(this.pathAttribute);
            try {
                FileObject locatedFile = this.manager.resolveFile(this.rootUri + relativePath, this.options);
                if (!locatedFile.isFile()) {
                    throw new NoSuchElementException("Located Object is a folder and not a file");
                }
                String relativeParent = "";
                int lastOccurenceOfBaseName = relativePath.lastIndexOf(locatedFile.getName().getBaseName());
                if (lastOccurenceOfBaseName >= 0) {
                    relativeParent = relativePath.substring(0, lastOccurenceOfBaseName);
                }
                return new String[]{relativePath, relativeParent};
            }
            catch (FileSystemException e) {
                throw new NoSuchElementException("Failed to locate file " + relativePath + ". " + e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.setIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ScanningFileIterator
    implements Iterator<String[]> {
        private Iterator<String[]> iterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScanningFileIterator(FileObject startDirectory, String filterPath, final String filterFile, ScanningFileIteratorFilterMethod filterType, String rootURIString, int numberOfRetries, long delayBeforeRetries) throws IOException {
            boolean matchFileName;
            PathMatcher pathMatcher;
            final FileSystem fileSystem = FileSystems.getDefault();
            final boolean ignoreFilterPath = filterPath == null || filterPath.isEmpty();
            final boolean ignoreFilterFile = filterFile == null || filterFile.isEmpty();
            if (filterType.getFilterType().equals(ScanningFileIteratorFilterMethod.REGEX_PATH_AND_NAME.getFilterType())) {
                pathMatcher = fileSystem.getPathMatcher(ScanningFileIteratorFilterMethod.REGEX.getFilterType() + ":" + filterPath);
                matchFileName = true;
            } else {
                pathMatcher = fileSystem.getPathMatcher(filterType.getFilterType() + ":" + filterPath);
                matchFileName = false;
            }
            final LinkedList fileList = new LinkedList();
            SimpleFileVisitor<String[]> simpleFileVisitor = new SimpleFileVisitor<String[]>(){

                @Override
                public FileVisitResult visitFile(String[] file, BasicFileAttributes attrs) throws IOException {
                    String filePath = file[1];
                    String fileName = file[0];
                    Path currentPath = fileSystem.getPath(filePath, new String[0]);
                    if (!matchFileName) {
                        filePath = filePath + fileName;
                        if (ignoreFilterPath || pathMatcher.matches(currentPath)) {
                            fileList.add(file);
                        }
                    } else if ((ignoreFilterPath || pathMatcher.matches(currentPath)) && (ignoreFilterFile || fileName.matches(filterFile))) {
                        fileList.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            int i = 0;
            while (true) {
                try {
                    fileList.clear();
                    RemoteFiles.walkRemoteFileTree(startDirectory, simpleFileVisitor, startDirectory);
                    break;
                }
                catch (Exception e) {
                    if (i >= numberOfRetries) {
                        throw e;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(delayBeforeRetries);
                    }
                    catch (InterruptedException e1) {
                        throw e;
                    }
                }
                finally {
                    try {
                        startDirectory.close();
                    }
                    catch (FileSystemException fileSystemException) {}
                }
                ++i;
            }
            this.iterator = fileList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String[] next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException("No more remote files!");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum ScanningFileIteratorFilterMethod {
        GLOB("glob"),
        REGEX("regex"),
        REGEX_PATH_AND_NAME("regex path and name");

        private String filterType;

        private ScanningFileIteratorFilterMethod(String filterType) {
            this.filterType = filterType;
        }

        public String getFilterType() {
            return this.filterType;
        }

        public static ScanningFileIteratorFilterMethod getValueOf(String value) {
            for (ScanningFileIteratorFilterMethod method : ScanningFileIteratorFilterMethod.values()) {
                if (!method.getFilterType().matches(value)) continue;
                return method;
            }
            return null;
        }

        public static String[] getValuesAsString() {
            return new String[]{GLOB.getFilterType(), REGEX.getFilterType(), REGEX_PATH_AND_NAME.getFilterType()};
        }
    }
}

