/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops.time;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.operator.loops.time.ExampleSetBasedTimepointIterator;
import com.owc.operator.loops.time.IntervalbasedTimepointIterator;
import com.owc.parameters.ParameterTools;
import com.owc.process.ports.metadata.AttributeParameterPrecondition;
import com.owc.tools.DateTools;
import com.owc.tools.ExampleSetModifier;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDate;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LoopTimeWindowsByIntervalOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_SLIDE_FROM = "slide_window_start_from";
    public static final String PARAMETER_SLIDE_UNTIL = "slide_window_start_until";
    public static final String PARAMETER_EVERY = "window_start_every";
    public static final String PARAMETER_WINDOW_START_ATTRIBUTE = "window_start_attribute";
    public static final String PARAMETER_INTERVAL_START_ATTRIBUTE = "interval_start_attribute";
    public static final String PARAMETER_INTERVAL_END_ATTRIBUTE = "interval_end_attribute";
    public static final String PARAMETER_TIME_MODE = "mode";
    public static final String PARAMETER_WINDOW_WIDTH = "window_width";
    public static final String PARAMETER_DEFINE_WINDOW_MACROS = "define_window_macros";
    public static final String PARAMETER_WINDOW_START_MACRO = "window_start_macro_name";
    public static final String PARAMETER_WINDOW_END_MACRO = "window_end_macro_name";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_CREATE_OVERLAP_ATTRIBUTE = "create_overlap_attribute";
    public static final String PARAMETER_OVERLAP_ATTRIBUTE_NAME = "overlap_attribute_name";
    private final InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", (MetaData)new ExampleSetMetaData());
    private final InputPort timeSetInputPort = (InputPort)this.getInputPorts().createPort("time set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("window of example set");

    public LoopTimeWindowsByIntervalOperator(OperatorDescription description) {
        super(description, "Window Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new PassThroughRule(this.exampleSetInputPort, this.exampleSetInnerSource, false));
        ExampleSetPrecondition precondition = new ExampleSetPrecondition(this.timeSetInputPort);
        precondition.setOptional(true);
        this.timeSetInputPort.addPrecondition((Precondition)precondition);
        this.timeSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.timeSetInputPort, (Operator)this, PARAMETER_WINDOW_START_ATTRIBUTE, 9));
        this.exampleSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInputPort, (Operator)this, PARAMETER_INTERVAL_START_ATTRIBUTE, 9));
        this.exampleSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInputPort, (Operator)this, PARAMETER_INTERVAL_END_ATTRIBUTE, 9));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        ChronoUnit windowWidthUnit;
        int windowWidthValue;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean extractMacros = this.getParameterAsBoolean(PARAMETER_DEFINE_WINDOW_MACROS);
        String startMacroName = null;
        String endMacroName = null;
        DateTimeFormatter dateFormat = null;
        if (extractMacros) {
            startMacroName = this.getParameterAsString(PARAMETER_WINDOW_START_MACRO);
            if (startMacroName.isEmpty()) {
                throw new UserError((Operator)this, "toolkit.macro_name_empty");
            }
            endMacroName = this.getParameterAsString(PARAMETER_WINDOW_END_MACRO);
            if (endMacroName.isEmpty()) {
                throw new UserError((Operator)this, "toolkit.macro_name_empty");
            }
            dateFormat = DateTimeFormatter.ofPattern(this.getParameterAsString(PARAMETER_DATE_FORMAT));
        }
        ZoneId zoneId = DateTools.evaluateZoneParameter((Operator)this);
        String windowStartFromDate = this.getParameterAsString(PARAMETER_SLIDE_FROM);
        ZonedDateTime windowStartFrom = ParameterTools.getParameterAsDate(PARAMETER_SLIDE_FROM, (Operator)this).toInstant().atZone(zoneId);
        String windowStartToDate = this.getParameterAsString(PARAMETER_SLIDE_UNTIL);
        ZonedDateTime windowStartUntil = ParameterTools.getParameterAsDate(PARAMETER_SLIDE_UNTIL, (Operator)this).toInstant().atZone(zoneId);
        Iterator<ZonedDateTime> windowStartIterator = null;
        windowStartIterator = this.timeSetInputPort.isConnected() ? new ExampleSetBasedTimepointIterator((Operator)this, (ExampleSet)this.timeSetInputPort.getData(ExampleSet.class), this.getParameterAsString(PARAMETER_WINDOW_START_ATTRIBUTE), windowStartFrom, windowStartUntil) : new IntervalbasedTimepointIterator((Operator)this, windowStartFrom, windowStartUntil, this.getParameterAsString(PARAMETER_EVERY));
        String[] windowWidthTupel = ParameterTypeTupel.transformString2Tupel((String)this.getParameterAsString(PARAMETER_WINDOW_WIDTH));
        try {
            if (windowWidthTupel[0] == null) {
                throw new UndefinedParameterError(PARAMETER_WINDOW_WIDTH, (Operator)this);
            }
            windowWidthValue = Integer.parseInt(windowWidthTupel[0]);
            windowWidthUnit = ChronoUnit.valueOf(windowWidthTupel[1]);
        }
        catch (NumberFormatException e1) {
            throw new OperatorException("toolkit.illegal_numeric_parameter_value", (Throwable)e1, new Object[]{PARAMETER_WINDOW_WIDTH, windowWidthTupel[0]});
        }
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        ExampleSet set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        boolean createOverlapAttribute = this.getParameterAsBoolean(PARAMETER_CREATE_OVERLAP_ATTRIBUTE);
        String overlapAttributeName = this.getParameterAsString(PARAMETER_OVERLAP_ATTRIBUTE_NAME);
        if (createOverlapAttribute) {
            set = (ExampleSet)set.clone();
            ExampleSetModifier.createAttribute(set, overlapAttributeName, 4, false);
        }
        String intervalStartAttributeName = this.getParameterAsString(PARAMETER_INTERVAL_START_ATTRIBUTE);
        String intervalEndAttributeName = this.getParameterAsString(PARAMETER_INTERVAL_END_ATTRIBUTE);
        Attribute intervalStartAttribute = set.getAttributes().get(intervalStartAttributeName);
        Attribute intervalEndAttribute = set.getAttributes().get(intervalEndAttributeName);
        if (intervalStartAttribute == null) {
            throw new UserError((Operator)this, "toolkit.attribute_not_found", new Object[]{intervalStartAttributeName});
        }
        if (intervalEndAttribute == null) {
            throw new UserError((Operator)this, "toolkit.attribute_not_found", new Object[]{intervalEndAttributeName});
        }
        if (set.size() > 0) {
            SortedExampleSet sortedSet = new SortedExampleSet(set, 1, false, intervalEndAttribute);
            int setSize = sortedSet.size();
            int[] startSetIndices = new int[setSize];
            for (int i2 = 0; i2 < startSetIndices.length; ++i2) {
                startSetIndices[i2] = i2;
            }
            startSetIndices = Arrays.stream(startSetIndices).boxed().sorted((arg_0, arg_1) -> LoopTimeWindowsByIntervalOperator.lambda$doWork$0((ExampleSet)sortedSet, intervalStartAttribute, arg_0, arg_1)).mapToInt(i -> i).toArray();
            int[] partition = new int[setSize];
            byte[] rowStatusCounter = new byte[setSize];
            Arrays.fill(rowStatusCounter, (byte)4);
            int startIntervalStartWindowPointer = 0;
            int startIntervalEndWindowPointer = 0;
            int endIntervalStartWindowPointer = 0;
            int endIntervalEndWindowPointer = 0;
            while (windowStartIterator.hasNext()) {
                double currentTimestamp;
                ZonedDateTime windowStart = windowStartIterator.next();
                double windowStartTimestamp = windowStart.toInstant().toEpochMilli();
                ZonedDateTime windowEnd = windowStart.plus(windowWidthValue, windowWidthUnit);
                double windowEndTimestamp = windowEnd.toInstant().toEpochMilli();
                while (startIntervalStartWindowPointer < setSize && !((currentTimestamp = sortedSet.getExample(startSetIndices[startIntervalStartWindowPointer]).getValue(intervalStartAttribute)) >= windowStartTimestamp)) {
                    int n = startSetIndices[startIntervalStartWindowPointer];
                    rowStatusCounter[n] = (byte)(rowStatusCounter[n] - 1);
                    ++startIntervalStartWindowPointer;
                }
                while (startIntervalEndWindowPointer < setSize && !((currentTimestamp = sortedSet.getExample(startSetIndices[startIntervalEndWindowPointer]).getValue(intervalStartAttribute)) >= windowEndTimestamp)) {
                    int n = startSetIndices[startIntervalEndWindowPointer];
                    rowStatusCounter[n] = (byte)(rowStatusCounter[n] - 1);
                    ++startIntervalEndWindowPointer;
                }
                while (endIntervalStartWindowPointer < setSize && !((currentTimestamp = sortedSet.getExample(endIntervalStartWindowPointer).getValue(intervalEndAttribute)) >= windowStartTimestamp)) {
                    int n = endIntervalStartWindowPointer++;
                    rowStatusCounter[n] = (byte)(rowStatusCounter[n] - 1);
                }
                while (endIntervalEndWindowPointer < setSize && !((currentTimestamp = sortedSet.getExample(endIntervalEndWindowPointer).getValue(intervalEndAttribute)) >= windowEndTimestamp)) {
                    int n = endIntervalEndWindowPointer++;
                    rowStatusCounter[n] = (byte)(rowStatusCounter[n] - 1);
                }
                for (int i3 = 0; i3 < partition.length; ++i3) {
                    partition[i3] = rowStatusCounter[i3] << 30 >>> 30 > 0 ? 1 : 0;
                }
                SplittedExampleSet splittedSet = new SplittedExampleSet((ExampleSet)sortedSet, new Partition(partition, 2));
                splittedSet.selectSingleSubset(1);
                ExampleSet batchSet = (ExampleSet)this.getDataCopy((IOObject)splittedSet);
                Attribute overlapAttribute = batchSet.getAttributes().get(overlapAttributeName);
                Attribute batchIntervalStartAttribute = batchSet.getAttributes().get(intervalStartAttributeName);
                Attribute batchIntervalEndAttribute = batchSet.getAttributes().get(intervalEndAttributeName);
                if (createOverlapAttribute) {
                    for (Example example : batchSet) {
                        double startInterval = example.getValue(batchIntervalStartAttribute);
                        double endInterval = example.getValue(batchIntervalEndAttribute);
                        double totalLength = endInterval - startInterval;
                        double effectiveLength = Math.min(endInterval, windowEndTimestamp) - Math.max(startInterval, windowStartTimestamp);
                        example.setValue(overlapAttribute, effectiveLength / totalLength);
                    }
                }
                if (extractMacros) {
                    this.getProcess().getMacroHandler().addMacro(startMacroName, windowStart.format(dateFormat));
                    this.getProcess().getMacroHandler().addMacro(endMacroName, windowEnd.format(dateFormat));
                }
                this.inputExtender.deliver(this.getDataCopy(inputData));
                this.inApplyLoop();
                try {
                    this.performBatch(batchSet);
                }
                catch (BreakIterationException e) {
                    e.finishBrokenOperators((Operator)this);
                    break;
                }
                this.outputExtender.collect();
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private List<IOObject> performBatch(ExampleSet batchSet) throws OperatorException, UserError {
        try {
            this.exampleSetInnerSource.deliver(this.getDataCopy((IOObject)batchSet));
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ChronoUnit[] timeUnits = ChronoUnit.values();
        String[] timeUnitNames = new String[timeUnits.length];
        int unitSecondsIndex = 0;
        for (int i = 0; i < timeUnits.length; ++i) {
            timeUnitNames[i] = timeUnits[i].name();
            if (timeUnits[i] != ChronoUnit.SECONDS) continue;
            unitSecondsIndex = i;
        }
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeDate(PARAMETER_SLIDE_FROM, "Limits the possible starts of the time window. The window won't begin before this time, regardless from where it's start point is derrived. This is the start point, if interval setting is used rather than delivering a data set to the time set port with specific time points.", true, false));
        types.add((ParameterType)new ParameterTypeDate(PARAMETER_SLIDE_UNTIL, "Limits the possible starts of the time window. The window won't begin after this time. Any window starting later will be discarded.", true, false));
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_WINDOW_START_ATTRIBUTE, "The timestamp attribute that is used to defined the windows.", this.exampleSetInputPort, true, new int[]{9});
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return LoopTimeWindowsByIntervalOperator.this.timeSetInputPort;
            }
        }, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeTupel(PARAMETER_EVERY, "Begin a window every X Units as set here after the slide from parameter.", new ParameterType[]{new ParameterTypeInt("time_value", "Set time value", 0, Integer.MAX_VALUE, false), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, unitSecondsIndex, false)});
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return LoopTimeWindowsByIntervalOperator.this.timeSetInputPort;
            }
        }, true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeTupel(PARAMETER_WINDOW_WIDTH, "Width of the windows.", new ParameterType[]{new ParameterTypeInt("time_value", "Set time value", 0, Integer.MAX_VALUE, false), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, unitSecondsIndex, false)});
        types.add((ParameterType)type);
        type.setExpert(false);
        type.setOptional(false);
        type = new ParameterTypeAttribute(PARAMETER_INTERVAL_START_ATTRIBUTE, "The timestamp attribute indicating the begin of the interval represented by the example. The interval is used to filter the given example set according to the windows.", this.exampleSetInputPort, false, false, new int[]{9});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_INTERVAL_END_ATTRIBUTE, "The timestamp attribute indicating the end of the interval represented by the example. The interval is used to filter the given example set according to the windows.", this.exampleSetInputPort, false, false, new int[]{9});
        types.add((ParameterType)type);
        types.add(DateTools.getZoneParameter());
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CREATE_OVERLAP_ATTRIBUTE, "If checked, a new attribute will be created containing the percentual overlap of the example's interval with the current time window.", true, false));
        type = new ParameterTypeString(PARAMETER_OVERLAP_ATTRIBUTE_NAME, "The name of the attribute containing the calculated overlap.", "Overlap");
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CREATE_OVERLAP_ATTRIBUTE, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DEFINE_WINDOW_MACROS, "If checked, macros will be created, containing the beginning timestamp of the current window.", true, false));
        type = new ParameterTypeString(PARAMETER_WINDOW_START_MACRO, "The name of the macro containing the beginning timestamp of the current window.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_WINDOW_END_MACRO, "The name of the macro containing the end timestamp of the current window.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros", "yyyy-MM-dd HH:mm:ss", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, true, true));
        types.add((ParameterType)type);
        types.addAll(super.getParameterTypes());
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }

    private static /* synthetic */ int lambda$doWork$0(ExampleSet sortedSet, Attribute intervalStartAttribute, Integer a, Integer b) {
        return Double.compare(sortedSet.getExample(a.intValue()).getValue(intervalStartAttribute), sortedSet.getExample(b.intValue()).getValue(intervalStartAttribute));
    }
}

