/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops.time;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.operator.loops.ParallelLoopingOperatorChain;
import com.owc.operator.loops.control.BreakIterationException;
import com.owc.operator.loops.control.SkipIterationException;
import com.owc.operator.loops.time.ExampleSetBasedTimepointIterator;
import com.owc.operator.loops.time.IntervalbasedTimepointIterator;
import com.owc.parameters.ParameterTools;
import com.owc.process.ports.metadata.AttributeParameterPrecondition;
import com.owc.tools.DateTools;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDate;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LoopTimeWindowsOperator
extends ParallelLoopingOperatorChain {
    public static final String PARAMETER_SLIDE_FROM = "slide_window_start_from";
    public static final String PARAMETER_SLIDE_UNTIL = "slide_window_start_until";
    public static final String PARAMETER_EVERY = "window_start_every";
    public static final String PARAMETER_WINDOW_START_ATTRIBUTE = "window_start_attribute";
    public static final String PARAMETER_TIMESTAMP_ATTRIBUTE = "timestamp_attribute";
    public static final String PARAMETER_WINDOW_WIDTH = "window_width";
    public static final String PARAMETER_DEFINE_WINDOW_MACROS = "define_window_macros";
    public static final String PARAMETER_WINDOW_START_MACRO_NAME = "window_start_macro_name";
    public static final String PARAMETER_WINDOW_END_MACRO_NAME = "window_end_macro_name";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    private final InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", (MetaData)new ExampleSetMetaData());
    private final InputPort timeSetInputPort = (InputPort)this.getInputPorts().createPort("time set");
    private final OutputPort exampleSetInnerSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("window of example set");

    public LoopTimeWindowsOperator(OperatorDescription description) {
        super(description, "Window Processing");
        this.getTransformer().addRuleAtBeginning((MDTransformationRule)new PassThroughRule(this.exampleSetInputPort, this.exampleSetInnerSource, false));
        ExampleSetPrecondition precondition = new ExampleSetPrecondition(this.timeSetInputPort);
        precondition.setOptional(true);
        this.timeSetInputPort.addPrecondition((Precondition)precondition);
        this.timeSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.timeSetInputPort, (Operator)this, PARAMETER_WINDOW_START_ATTRIBUTE, 9));
        this.exampleSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInputPort, (Operator)this, PARAMETER_TIMESTAMP_ATTRIBUTE, 9));
    }

    @Override
    public void doWork(boolean isLicensed, boolean isParallizable) throws OperatorException {
        ChronoUnit windowWidthUnit;
        int windowWidthValue;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        boolean extractMacros = this.getParameterAsBoolean(PARAMETER_DEFINE_WINDOW_MACROS);
        String windowStartMacroName = null;
        String windowEndMacroName = null;
        DateTimeFormatter dateFormat = null;
        if (extractMacros) {
            windowStartMacroName = this.getParameterAsString(PARAMETER_WINDOW_START_MACRO_NAME);
            if (windowStartMacroName.isEmpty()) {
                throw new UserError((Operator)this, "toolkit.macro_name_empty");
            }
            windowEndMacroName = this.getParameterAsString(PARAMETER_WINDOW_END_MACRO_NAME);
            dateFormat = DateTimeFormatter.ofPattern(this.getParameterAsString(PARAMETER_DATE_FORMAT));
        }
        ZoneId zoneId = DateTools.evaluateZoneParameter((Operator)this);
        ZonedDateTime windowStartFrom = ParameterTools.getParameterAsDate(PARAMETER_SLIDE_FROM, (Operator)this).toInstant().atZone(zoneId);
        ZonedDateTime windowStartUntil = ParameterTools.getParameterAsDate(PARAMETER_SLIDE_UNTIL, (Operator)this).toInstant().atZone(zoneId);
        Iterator<ZonedDateTime> startIterator = null;
        startIterator = this.timeSetInputPort.isConnected() ? new ExampleSetBasedTimepointIterator((Operator)this, (ExampleSet)this.timeSetInputPort.getData(ExampleSet.class), this.getParameterAsString(PARAMETER_WINDOW_START_ATTRIBUTE), windowStartFrom, windowStartUntil) : new IntervalbasedTimepointIterator((Operator)this, windowStartFrom, windowStartUntil, this.getParameterAsString(PARAMETER_EVERY));
        String[] windowWidthTupel = ParameterTypeTupel.transformString2Tupel((String)this.getParameterAsString(PARAMETER_WINDOW_WIDTH));
        try {
            if (windowWidthTupel[0] == null) {
                throw new UndefinedParameterError(PARAMETER_WINDOW_WIDTH, (Operator)this);
            }
            windowWidthValue = Integer.parseInt(windowWidthTupel[0]);
            windowWidthUnit = ChronoUnit.valueOf(windowWidthTupel[1]);
        }
        catch (NumberFormatException e1) {
            throw new OperatorException("toolkit.illegal_numeric_parameter_value", (Throwable)e1, new Object[]{PARAMETER_WINDOW_WIDTH, windowWidthTupel[0]});
        }
        List<IOObject> inputData = this.inputExtender.getDataOrNull(IOObject.class);
        Object set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        String timestampAttributeName = this.getParameterAsString(PARAMETER_TIMESTAMP_ATTRIBUTE);
        Attribute timestampAttribute = set.getAttributes().get(timestampAttributeName);
        if (timestampAttribute == null) {
            throw new UserError((Operator)this, "toolkit.attribute_not_found", new Object[]{timestampAttributeName});
        }
        if (set.size() > 0) {
            set = new SortedExampleSet((ExampleSet)set, 1, false, new Attribute[]{timestampAttribute});
            int[] partition = new int[set.size()];
            int endPointer = 0;
            int startPointer = 0;
            while (startPointer < set.size() && startIterator.hasNext()) {
                double currentTimestamp;
                ZonedDateTime start = startIterator.next();
                double startTimestamp = start.toInstant().toEpochMilli();
                ZonedDateTime end = start.plus(windowWidthValue, windowWidthUnit);
                double endTimestamp = end.toInstant().toEpochMilli();
                while (startPointer < set.size()) {
                    partition[startPointer] = 0;
                    currentTimestamp = set.getExample(startPointer).getValue(timestampAttribute);
                    if (currentTimestamp >= startTimestamp) {
                        endPointer = startPointer;
                        break;
                    }
                    ++startPointer;
                }
                for (endPointer = Math.max(endPointer, startPointer); endPointer < set.size() && endTimestamp > (currentTimestamp = set.getExample(endPointer).getValue(timestampAttribute)); ++endPointer) {
                    partition[endPointer] = 1;
                }
                SplittedExampleSet splittedSet = new SplittedExampleSet(set, new Partition(partition, 2));
                splittedSet.selectSingleSubset(1);
                ExampleSet batchSet = (ExampleSet)this.getDataCopy((IOObject)splittedSet);
                if (extractMacros) {
                    this.getProcess().getMacroHandler().addMacro(windowStartMacroName, start.format(dateFormat));
                    if (windowEndMacroName != null && !windowEndMacroName.trim().isEmpty()) {
                        this.getProcess().getMacroHandler().addMacro(windowEndMacroName, end.format(dateFormat));
                    }
                }
                this.inputExtender.deliver(this.getDataCopy(inputData));
                this.inApplyLoop();
                try {
                    this.performBatch(batchSet);
                }
                catch (BreakIterationException e) {
                    e.finishBrokenOperators((Operator)this);
                    break;
                }
                this.outputExtender.collect();
            }
        } else {
            this.inputExtender.deliver(this.getDataCopy(inputData));
            this.loopExtender.deliver(this.getDataCopy(inputData));
            this.outputExtender.reset();
        }
    }

    private List<IOObject> performBatch(ExampleSet batchSet) throws OperatorException, UserError {
        try {
            this.exampleSetInnerSource.deliver(this.getDataCopy((IOObject)batchSet));
            this.getSubprocess(0).execute();
            if (this.loopExtender.isConnected()) {
                this.loopExtender.deliver(this.loopExtender.getDataOrNull(IOObject.class));
            }
            return this.outputExtender.getDataOrNull(IOObject.class);
        }
        catch (SkipIterationException e) {
            e.finishSkippedOperators((Operator)this);
            return new LinkedList<IOObject>();
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ChronoUnit[] timeUnits = ChronoUnit.values();
        String[] timeUnitNames = new String[timeUnits.length];
        int unitSecondsIndex = 0;
        for (int i = 0; i < timeUnits.length; ++i) {
            timeUnitNames[i] = timeUnits[i].name();
            if (timeUnits[i] != ChronoUnit.SECONDS) continue;
            unitSecondsIndex = i;
        }
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeDate(PARAMETER_SLIDE_FROM, "Limits the possible starts of the time window. The window won't begin before this time, regardless from where it's start point is derrived. This is the start point, if interval setting is used rather than delivering a data set to the time set port with specific time points.", true, false));
        types.add((ParameterType)new ParameterTypeDate(PARAMETER_SLIDE_UNTIL, "Limits the possible starts of the time window. The window won't begin after this time. Any window starting later will be discarded.", true, false));
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_WINDOW_START_ATTRIBUTE, "The timestamp attribute that is used to defined the windows.", this.exampleSetInputPort, true, new int[]{9});
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return LoopTimeWindowsOperator.this.timeSetInputPort;
            }
        }, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeTupel(PARAMETER_EVERY, "Begin a window every X Units as set here after the slide from parameter.", new ParameterType[]{new ParameterTypeInt("time_value", "Set time value", 0, Integer.MAX_VALUE, false), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, unitSecondsIndex, false)});
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return LoopTimeWindowsOperator.this.timeSetInputPort;
            }
        }, true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeTupel(PARAMETER_WINDOW_WIDTH, "Width of the windows.", new ParameterType[]{new ParameterTypeInt("time_value", "Set time value", 0, Integer.MAX_VALUE, false), new ParameterTypeCategory("Select_time_unit", "Select time unit.", timeUnitNames, unitSecondsIndex, false)});
        types.add((ParameterType)type);
        type.setExpert(false);
        type.setOptional(false);
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_TIMESTAMP_ATTRIBUTE, "The timestamp attribute that is used filter the given example set according to the windows.", this.exampleSetInputPort, new int[]{9}));
        types.add(DateTools.getZoneParameter());
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DEFINE_WINDOW_MACROS, "If checked, a macro will be created, containing the beginning timestamp of the current window.", true, false));
        type = new ParameterTypeString(PARAMETER_WINDOW_START_MACRO_NAME, "The name of the macro containing the beginning timestamp of the current window, inclusive.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_WINDOW_END_MACRO_NAME, "The name of the macro containing the ending timestamp of the current window, exclusive.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros", "yyyy-MM-dd HH:mm:ss", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DEFINE_WINDOW_MACROS, true, true));
        types.add((ParameterType)type);
        types.addAll(super.getParameterTypes());
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

