/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.preprocessing.generation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeOrderingRules;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class GenerateConcatenationOperator
extends AbstractExampleSetProcessing {
    private AttributeSubsetSelector selector = new AttributeSubsetSelector(this.getParameterHandler(), this.getExampleSetInputPort(), new int[]{0});
    private static final String PARAMETER_REMOVE_CONCATENATED_ATTRIBUTES = "remove_concatenated_attributes";
    private static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private static final String PARAMETER_SEPARATOR = "separator";
    private static final String PARAMETER_CONCAT_ATTRIBUTES = "concat_attributes";
    private static final String PARAMETER_DATE_FORMAT = "date_format";
    private static final String PARAMETER_NUMBER_FORMAT = "number_format";
    public static final String PARAMETER_SELECTION = "selection";
    public static final String PARAMETER_POSTFIX = "postfix";
    public static final String PARAMETER_PREFIX = "prefix";
    public static final String PARAMETER_MODES = "modes";
    private static final String[] SELECTION_MODES = new String[]{"order", "selection"};
    public static final int MODE_SELECT = 1;
    public static final int MODE_ORDER = 0;
    private static final String ATTRIBUTE_NAME_POSTFIX = "";
    private static final String ATTRIBUTE_NAME_PREFIX = "";

    public GenerateConcatenationOperator(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String numberFormatString;
        Collection<Attribute> concatAttributes;
        Attributes attributes = exampleSet.getAttributes();
        Attribute resultAttribute = AttributeFactory.createAttribute((String)this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), (int)7);
        if (this.getParameterAsInt(PARAMETER_MODES) == 1) {
            concatAttributes = this.selector.getAttributeSubset(exampleSet, false, true);
        } else {
            concatAttributes = new LinkedList();
            for (String attributeName : this.getParameterAsString(PARAMETER_CONCAT_ATTRIBUTES).split("\\|")) {
                Attribute attribute = attributes.get(attributeName);
                if (attribute == null) {
                    throw new UserError((Operator)this, "toolkit.no_selected_attribute", new Object[]{this.getName()});
                }
                concatAttributes.add(attribute);
            }
        }
        exampleSet.getExampleTable().addAttribute(resultAttribute);
        attributes.addRegular(resultAttribute);
        String separator = this.getParameterAsString(PARAMETER_SEPARATOR);
        if (separator == null) {
            separator = "";
        }
        if ((numberFormatString = this.getParameterAsString(PARAMETER_NUMBER_FORMAT)) == null) {
            numberFormatString = "";
        }
        DecimalFormat numberFormat = new DecimalFormat(numberFormatString);
        String dateFormatString = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        if (dateFormatString == null) {
            dateFormatString = "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
        for (Example example : exampleSet) {
            StringBuilder builder = new StringBuilder();
            boolean isFirst = true;
            String prefix = this.getParameterAsString(PARAMETER_PREFIX);
            String postfix = this.getParameterAsString(PARAMETER_POSTFIX);
            builder.append(prefix);
            for (Attribute concatAttribute : concatAttributes) {
                if (!isFirst) {
                    builder.append(separator);
                }
                if (concatAttribute.isNominal()) {
                    builder.append(example.getNominalValue(concatAttribute));
                } else if (concatAttribute.isNumerical()) {
                    builder.append(numberFormat.format(example.getValue(concatAttribute)));
                } else if (concatAttribute.isDateTime()) {
                    builder.append(dateFormat.format(new Date((long)example.getValue(concatAttribute))));
                }
                isFirst = false;
            }
            builder.append(postfix);
            example.setValue(resultAttribute, builder.toString());
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_CONCATENATED_ATTRIBUTES)) {
            for (Attribute attribute : concatAttributes) {
                attributes.remove(attribute);
            }
        }
        return exampleSet;
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        ExampleSetMetaData emd = metaData.clone();
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_CONCATENATED_ATTRIBUTES)) {
            String[] concatAttributeNames = this.getParameterAsString(PARAMETER_CONCAT_ATTRIBUTES).split("\\|");
            if (concatAttributeNames == null || concatAttributeNames.length <= 0) {
                this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "toolkit.no_selected_attribute", new Object[0]));
            }
            for (String attributeName : concatAttributeNames) {
                AttributeMetaData attribute = emd.getAttributeByName(attributeName);
                if (attribute == null) {
                    this.addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), "attribute_missing", new Object[]{attributeName}));
                    continue;
                }
                emd.removeAttribute(attribute);
            }
        }
        emd.addAttribute(new AttributeMetaData(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), 7));
        return emd;
    }

    public boolean writesIntoExistingData() {
        return false;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_MODES, "Determines whether to merge according to a sequence, or with the use of a selection", SELECTION_MODES, 0));
        types.add(new ParameterTypeString(PARAMETER_SEPARATOR, "The separator between the attribute's values"));
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the new attribute containing the concatenation.", false));
        types.addAll(this.selector.getParameterTypes());
        List select = this.selector.getParameterTypes();
        for (ParameterType parameter : select) {
            parameter.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_MODES, SELECTION_MODES, true, new int[]{1}));
            types.add(parameter);
        }
        ParameterTypeAttributeOrderingRules order = new ParameterTypeAttributeOrderingRules(PARAMETER_CONCAT_ATTRIBUTES, "The order of the attributes to concatenate.", this.getExampleSetInputPort(), false, new int[]{1});
        order.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_MODES, SELECTION_MODES, true, new int[]{0}));
        order.setOptional(true);
        types.add(order);
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_CONCATENATED_ATTRIBUTES, "If checked, all attributes that have been concatenated will be removed from the result.", false));
        types.add(new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "Date format used for date and time attributes.", "yyyy-MM-dd HH:mm:ss", false));
        types.add(new ParameterTypeString(PARAMETER_NUMBER_FORMAT, "Number format used for numerical attributes.", "0.#", false));
        ParameterTypeString prefix = new ParameterTypeString(PARAMETER_PREFIX, "A prefix that will be added to selected examples.", "", false);
        prefix.setOptional(true);
        types.add(prefix);
        ParameterTypeString postfix = new ParameterTypeString(PARAMETER_POSTFIX, "A postfix that will be added to the selected examples.", "", false);
        postfix.setOptional(true);
        types.add(postfix);
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }
}

