/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.preprocessing.generation;

import com.owc.tools.Base64Tools;
import com.owc.tools.expressions.HashFunction;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.Charsets;

public class GenerateHashOperator
extends AbstractExampleSetProcessing {
    private static final String[] AVAILABLE_METHODS = new String[]{"MD2", "MD5", "SHA", "SHA-224", "SHA-256", "SHA-384", "SHA-512"};
    private static final String PARAMETER_REMOVE_HASHED_ATTRIBUTES = "remove_hashed_attributes";
    private static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private static final String PARAMETER_HASH_METHOD = "hash_method";
    private AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.getExampleSetInputPort());

    public GenerateHashOperator(OperatorDescription description) {
        super(description);
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        ExampleSetMetaData emd = metaData.clone();
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_HASHED_ATTRIBUTES)) {
            Collection selectedAttributes = this.subsetSelector.getMetaDataSubset(emd, false).getAllAttributes();
            for (AttributeMetaData selectedAttribute : selectedAttributes) {
                emd.removeAttribute(emd.getAttributeByName(selectedAttribute.getName()));
            }
        }
        emd.addAttribute(new AttributeMetaData(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), 7));
        return emd;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        MessageDigest digest;
        Attributes attributes = exampleSet.getAttributes();
        ArrayList hashAttributes = new ArrayList(this.subsetSelector.getAttributeSubset(exampleSet, false));
        Collections.sort(hashAttributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (hashAttributes.isEmpty()) {
            throw new UserError((Operator)this, "toolkit.needs_at_least_one_selected_attribute", new Object[]{this.getName()});
        }
        Attribute resultAttribute = AttributeFactory.createAttribute((String)this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), (int)7);
        exampleSet.getExampleTable().addAttribute(resultAttribute);
        attributes.addRegular(resultAttribute);
        try {
            digest = MessageDigest.getInstance(this.getParameterAsString(PARAMETER_HASH_METHOD));
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperatorException("toolkit.hash_method_unavailable.", (Throwable)e, new Object[]{this.getParameterAsString(PARAMETER_HASH_METHOD)});
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : hashAttributes) {
                if (attribute.isNominal()) {
                    digest.update(example.getValueAsString(attribute).getBytes(Charsets.UTF_8));
                    continue;
                }
                digest.update(HashFunction.longToByteArray(Double.doubleToLongBits(example.getValue(attribute))));
            }
            example.setValue(resultAttribute, Base64Tools.encode(digest.digest()));
        }
        if (this.getParameterAsBoolean(PARAMETER_REMOVE_HASHED_ATTRIBUTES)) {
            for (Attribute attribute : hashAttributes) {
                attributes.remove(attribute);
            }
        }
        return exampleSet;
    }

    public boolean writesIntoExistingData() {
        return false;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.subsetSelector.getParameterTypes());
        types.add(new ParameterTypeStringCategory(PARAMETER_HASH_METHOD, "The method to use for hashing. Different methods will create different lengths of hashs and different qualities.", AVAILABLE_METHODS, "SHA-256"));
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the new attribute containing the hashValue in Base64.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_REMOVE_HASHED_ATTRIBUTES, "If checked, all attributes that have been hashed will be removed from the result.", false));
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }
}

