/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.preprocessing.transformation;

import com.owc.tools.ExampleSetModifier;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeRegexp;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MakeNamesGreatAgainOperator
extends AbstractDataProcessing {
    private final AttributeSubsetSelector attributeSelector = new AttributeSubsetSelector((ParameterHandler)this, this.getExampleSetInputPort());
    public static final String PARAMETER_SPLIT_PATTERN = "separator";
    public static final String PARAMETER_ENABLE_GROUP = "group";
    public static final String PARAMETER_ENABLE_SPECIFIER = "specifier";
    public static final String PARAMETER_GROUP_DELIMITER = "group delimiter";
    public static final String PARAMETER_SPECIFIER_DELIMITER = "specifier delimiter";
    public static final String PARAMETER_ORDER_GROUP = "group order";
    public static final String PARAMETER_ORDER_SPECIFIER = "specifier order";
    public static final String PARAMETER_ORDER_GROUP_SPECIFIER = "group-specifier order";

    public MakeNamesGreatAgainOperator(OperatorDescription description) {
        super(description);
    }

    protected MetaData modifyMetaData(ExampleSetMetaData exampleSetMetaData) {
        ExampleSetMetaData subsetMetaData = this.attributeSelector.getMetaDataSubset(exampleSetMetaData, false);
        try {
            ArrayList<String> attributeNameList = new ArrayList<String>();
            Map<Object, Object> attributeNameMap = new HashMap();
            for (AttributeMetaData attributeMetaData : subsetMetaData.getAllAttributes()) {
                attributeNameList.add(attributeMetaData.getName());
            }
            attributeNameMap = this.renameAttributeNames(attributeNameList);
            for (AttributeMetaData attributeMetaData : subsetMetaData.getAllAttributes()) {
                String newName = (String)attributeNameMap.get(attributeMetaData.getName());
                attributeNameMap.remove(attributeMetaData.getName());
                if (attributeNameMap.containsValue(newName)) {
                    this.addError((ProcessSetupError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.getExampleSetInputPort(), "toolkit.duplicate_name", new Object[]{newName}));
                    return exampleSetMetaData;
                }
                exampleSetMetaData.getAttributeByName(attributeMetaData.getName()).setName(newName);
            }
        }
        catch (UndefinedParameterError attributeNameList) {
        }
        catch (UserError e) {
            this.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.getPortOwner(), "toolkit.failed_generating_metadata", new Object[]{e.getMessage()}));
        }
        return exampleSetMetaData;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Set attributeSubset = this.attributeSelector.getAttributeSubset(exampleSet, false);
        ArrayList<String> attributeNameList = new ArrayList<String>();
        Map<Object, Object> attributeNameMap = new HashMap();
        for (Attribute attribute : attributeSubset) {
            attributeNameList.add(attribute.getName());
        }
        attributeNameMap = this.renameAttributeNames(attributeNameList);
        for (Attribute attribute : attributeSubset) {
            attribute.setName((String)attributeNameMap.get(attribute.getName()));
        }
        return exampleSet;
    }

    private Map<String, String> renameAttributeNames(List<String> attributeNameList) throws UserError {
        boolean enableGroup = this.getParameterAsBoolean(PARAMETER_ENABLE_GROUP);
        boolean enableSpecifier = this.getParameterAsBoolean(PARAMETER_ENABLE_SPECIFIER);
        int order = 0;
        if (enableGroup && enableSpecifier) {
            order = this.getParameterAsInt(PARAMETER_ORDER_GROUP_SPECIFIER);
        } else if (enableGroup) {
            order = this.getParameterAsInt(PARAMETER_ORDER_GROUP);
        } else if (enableSpecifier) {
            order = this.getParameterAsInt(PARAMETER_ORDER_SPECIFIER);
        }
        String groupDelimiter = null;
        String specifierDelimiter = null;
        if (enableGroup) {
            groupDelimiter = this.getParameterAsString(PARAMETER_GROUP_DELIMITER);
        }
        if (enableSpecifier) {
            specifierDelimiter = this.getParameterAsString(PARAMETER_SPECIFIER_DELIMITER);
        }
        return ExampleSetModifier.getBestPracticeNameTranslations((Operator)this, attributeNameList, this.getParameterAsString(PARAMETER_SPLIT_PATTERN), groupDelimiter, specifierDelimiter, order);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.attributeSelector.getParameterTypes());
        ParameterTypeRegexp type = new ParameterTypeRegexp(PARAMETER_SPLIT_PATTERN, "The regular expression is used to split every selected attribute name into tokens. This tokens are recomposed with UpperCamelCase.", "[\\W_]");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_ENABLE_GROUP, "Enable this parameter if you want to rename selected attributes to match to the expression \"Group::Attribute[_Specifier]\".", false, true));
        types.add(new ParameterTypeBoolean(PARAMETER_ENABLE_SPECIFIER, "Enable this parameter if you want to rename selected attributes to match to the expression \"[Group::]Attribute_Specifier\".", false, true));
        type = new ParameterTypeString(PARAMETER_GROUP_DELIMITER, "The group delimiter is a sequence of one or more characters used to specify the boundary between group and attribute or group and specifier.", "_", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_GROUP, true, true));
        types.add(type);
        type = new ParameterTypeString(PARAMETER_SPECIFIER_DELIMITER, "The specifier delimiter is a sequence of one or more characters used to specify the boundary between specifier and attribute or specifier and group.", "_", true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_SPECIFIER, true, true));
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ORDER_GROUP, "The attributes will be renamed according to the following scheme: \"Group::Attribute\".", ExampleSetModifier.ORDER_OPTIONS[0], 0, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_GROUP, true, true));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_SPECIFIER, true, false));
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ORDER_SPECIFIER, "The attributes will be renamed according to the following scheme: \"Attribute_Specifier\".", ExampleSetModifier.ORDER_OPTIONS[1], 0, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_SPECIFIER, true, true));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_GROUP, true, false));
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_ORDER_GROUP_SPECIFIER, "The attributes will be renamed according to the following scheme: \"Group::Attribute_Specifier\".", ExampleSetModifier.ORDER_OPTIONS[2], 0, true);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_SPECIFIER, true, true));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_GROUP, true, true));
        types.add(type);
        return types;
    }
}

