/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.preprocessing.transformation;

import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractExampleSetProcessing;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NominalToPolynominalOperator
extends AbstractExampleSetProcessing {
    private AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.getExampleSetInputPort());

    public NominalToPolynominalOperator(OperatorDescription description) {
        super(description);
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Set transformSet = this.subsetSelector.getAttributeSubset(exampleSet, false);
        LinkedList<AttributeRole> attributeRoleList = new LinkedList<AttributeRole>();
        Iterator roleIterator = exampleSet.getAttributes().allAttributeRoles();
        while (roleIterator.hasNext()) {
            AttributeRole role = (AttributeRole)roleIterator.next();
            if (role.getAttribute().isNominal() && transformSet.contains(role.getAttribute())) {
                AttributeRole newRole = new AttributeRole(AttributeFactory.createAttribute((String)role.getAttribute().getName(), (int)7));
                newRole.setSpecial(role.getSpecialName());
                attributeRoleList.add(newRole);
                continue;
            }
            attributeRoleList.add(role);
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeRoleList);
        for (Example example : exampleSet) {
            creator.setValuesByExample(example);
            creator.commit();
        }
        return creator.finish();
    }

    protected MetaData modifyMetaData(ExampleSetMetaData metaData) throws UndefinedParameterError {
        ExampleSetMetaData emd = metaData.clone();
        Collection selectedAttributes = this.subsetSelector.getMetaDataSubset(emd, false).getAllAttributes();
        for (AttributeMetaData selectedAttribute : selectedAttributes) {
            if (!selectedAttribute.isNominal()) continue;
            emd.getAttributeByName(selectedAttribute.getName()).setType(7);
        }
        return emd;
    }

    public boolean writesIntoExistingData() {
        return false;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.subsetSelector.getParameterTypes());
        return types;
    }
}

