/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Tools;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ExtractMacrosFromExampleOperator
extends Operator {
    public static final String PARAMETER_INDEX = "example_index";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_SET_MISSING_INDICATOR = "set_missing_indicator";
    public static final String PARAMETER_MISSING_VALUE_INDICATOR = "missing_value_indicator";
    private InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInputPort);

    public ExtractMacrosFromExampleOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInputPort, this.exampleSetOutputPort);
        this.exampleSetInputPort.addPrecondition(this.subsetSelector.makePrecondition());
    }

    public void doWork() throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        Set attributeSubset = this.subsetSelector.getAttributeSubset(set, false);
        String missingValueIndicator = "";
        if (this.getParameterAsBoolean(PARAMETER_SET_MISSING_INDICATOR)) {
            missingValueIndicator = this.getParameterAsString(PARAMETER_MISSING_VALUE_INDICATOR);
        }
        String dateFormat = this.getParameterAsString(PARAMETER_DATE_FORMAT);
        int index = this.getParameterAsInt(PARAMETER_INDEX) - 1;
        if (index < 0 || index > set.size()) {
            throw new UserError((Operator)this, 110, new Object[]{index});
        }
        Example example = set.getExample(index);
        for (Attribute attribute : attributeSubset) {
            String value = missingValueIndicator;
            double doubleValue = example.getValue(attribute);
            if (!Double.isNaN(doubleValue)) {
                if (attribute.isNominal()) {
                    value = attribute.getMapping().mapIndex((int)doubleValue);
                } else if (attribute.isNumerical()) {
                    value = Tools.formatIntegerIfPossible((double)doubleValue, (int)16, (boolean)false);
                } else if (attribute.isDateTime()) {
                    value = Tools.formatDateTime((Date)new Date((long)doubleValue), (String)dateFormat);
                }
            }
            String macroName = attribute.getName();
            macroName = macroName.substring(0, 1).toLowerCase() + macroName.substring(1);
            this.getProcess().getMacroHandler().addMacro(macroName, value);
        }
        this.exampleSetOutputPort.deliver((IOObject)set);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.subsetSelector.getParameterTypes());
        types.add(new ParameterTypeInt(PARAMETER_INDEX, "The index of the example to extract the macro values from.", 1, Integer.MAX_VALUE, 1, false));
        types.add(new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros.", "yyyy-MM-dd HH:mm:ss", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SET_MISSING_INDICATOR, "If checked, the missing value indicator can be changed from the default to use an empty String.", false, false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_MISSING_VALUE_INDICATOR, "The string used for indicating that a value was missing. Can be empty to use an empty string.", "?");
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_SET_MISSING_INDICATOR, true, true));
        types.add(type);
        type.setExpert(false);
        type.setOptional(true);
        return types;
    }
}

