/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process;

import com.owc.license.ProductInformation;
import com.owc.operator.OrderedPortOperatorChain;
import com.owc.operator.loops.control.SkipIterationException;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.MultiInputPortPairExtender;
import com.rapidminer.operator.ports.MultiOutputPortPairExtender;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HandleExceptionOperator
extends OrderedPortOperatorChain {
    public static final String PARAMETER_ENABLE = "disable_error_handling";
    public static final String PARAMETER_ENABLE_RETRIES = "retry";
    public static final String PARAMETER_NUMBER_OF_RETRIES = "number_of_retries";
    public static final String PARAMETER_RETRY_DELAY = "delay_before_retry";
    public static final String PARAMETER_LOG_ERROR = "log_error";
    public static final String PARAMETER_LOG_ERROR_MESSAGE = "message";
    public static final String PARAMETER_LOG_STACK_TRACE = "log_stack_trace";
    public static final String PARAMETER_LOG_PROCESS_POSITION = "log_process_position";
    public static final String PARAMETER_MESSAGE_MACRO = "macro_for_error_message";
    public static final String PARAMETER_TYPE_MACRO = "macro_for_error_type";
    public static final String PARAMETER_TRACE_MACRO = "macro_for_error_trace";
    private final MultiOutputPortPairExtender inputExtender = new MultiOutputPortPairExtender("input", (Ports)this.getInputPorts(), (Ports[])new OutputPorts[]{this.getSubprocess(0).getInnerSources(), this.getSubprocess(1).getInnerSources()});
    private final MultiInputPortPairExtender outputExtender = new MultiInputPortPairExtender("output", (Ports)this.getOutputPorts(), (Ports[])new InputPorts[]{this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSinks()});

    public HandleExceptionOperator(OperatorDescription description) {
        super(description, "Try", "Catch");
        this.inputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
        this.outputExtender.start();
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        ExecutionUnit tryUnit = this.getSubprocess(0);
        ExecutionUnit catchUnit = this.getSubprocess(1);
        tryUnit.getInnerSinks().clear(4);
        catchUnit.getInnerSinks().clear(4);
        int retries = this.getParameterAsBoolean(PARAMETER_ENABLE_RETRIES) ? this.getParameterAsInt(PARAMETER_NUMBER_OF_RETRIES) : 0;
        int retryDelay = this.getParameterAsInt(PARAMETER_RETRY_DELAY);
        boolean success = false;
        Throwable error = null;
        for (int i = 0; i <= retries && !success; ++i) {
            try {
                this.inputExtender.passDataThrough(0);
                tryUnit.execute();
                this.outputExtender.passDataThrough(0);
                success = true;
                continue;
            }
            catch (SkipIterationException skipIteration) {
                throw skipIteration;
            }
            catch (ProcessStoppedException e) {
                throw e;
            }
            catch (Throwable e) {
                error = e;
                if (retryDelay <= 0) continue;
                try {
                    TimeUnit.MILLISECONDS.sleep(retryDelay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (error != null) {
            if (this.getParameterAsBoolean(PARAMETER_LOG_ERROR)) {
                Logger logger = LogService.getRoot();
                if (this.isParameterSet(PARAMETER_LOG_ERROR_MESSAGE)) {
                    logger.log(Level.WARNING, this.getParameterAsString(PARAMETER_LOG_ERROR_MESSAGE));
                }
                if (this.getParameterAsBoolean(PARAMETER_LOG_PROCESS_POSITION)) {
                    logger.log(Level.WARNING, "Ignored Error was from here:");
                    List processTreeList = this.getProcess().getRootOperator().createProcessTreeList(4, "", "", this.getProcess().getCurrentOperator(), "--->");
                    for (String logEntry : processTreeList) {
                        logger.log(Level.WARNING, logEntry);
                    }
                }
                if (this.getParameterAsBoolean(PARAMETER_LOG_STACK_TRACE)) {
                    logger.log(Level.WARNING, "Stack Trace:");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    error.printStackTrace(pw);
                    String message = sw.toString();
                    logger.log(Level.WARNING, message);
                }
            }
            if (this.isParameterSet(PARAMETER_MESSAGE_MACRO)) {
                String message = error.getMessage();
                if (message == null) {
                    message = "No message.";
                }
                this.getProcess().getMacroHandler().addMacro(this.getParameterAsString(PARAMETER_MESSAGE_MACRO), message);
            }
            if (this.isParameterSet(PARAMETER_TYPE_MACRO)) {
                this.getProcess().getMacroHandler().addMacro(this.getParameterAsString(PARAMETER_TYPE_MACRO), error.getClass().getName());
            }
            if (this.isParameterSet(PARAMETER_TRACE_MACRO)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                error.printStackTrace(pw);
                String message = sw.toString();
                this.getProcess().getMacroHandler().addMacro(this.getParameterAsString(PARAMETER_TRACE_MACRO), message);
            }
            this.inputExtender.passDataThrough(1);
            catchUnit.execute();
            this.outputExtender.passDataThrough(1);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_MESSAGE_MACRO, "A name of a macro that should contain message of the error for the error handling.", "exception", false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_TYPE_MACRO, "A name of a macro that should contain the the type of the error for the error handling.", "", false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_TRACE_MACRO, "A name of a macro that should contain the the trace of the error for the error handling.", "", false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_RETRIES, "If enabled, the try subprocess will be executed again. This might help if a resource was temporarily unavailable.", false, true));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_NUMBER_OF_RETRIES, "The number of times the subprocess will be executed before giving up.", 1, Integer.MAX_VALUE, 2, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_RETRIES, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeInt(PARAMETER_RETRY_DELAY, "The delay in milliseconds before the process will be executed again..", 0, Integer.MAX_VALUE, 0, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_ENABLE_RETRIES, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_LOG_ERROR, "If enabled, the operator will write a log entry when an error is encountered. This can be used for debugging, while it should be disabled when this is expected logic.", false, true));
        type = new ParameterTypeString(PARAMETER_LOG_ERROR_MESSAGE, "The message that will be written when an error is encountered. Can be used to insert specific identifiers to search for in logs.", "Error in '%{process_name}' was ignored.", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LOG_ERROR, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_LOG_PROCESS_POSITION, "If enabled, the operator will write the position of the error in the inner process into the log when an error is encountered.", false, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LOG_ERROR, false, true));
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_LOG_STACK_TRACE, "If enabled, the operator will write the stack trace of the error into the log when an error is encountered.", false, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LOG_ERROR, false, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

