/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process.collection;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedIOObjectsCollection;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.tools.container.Pair;
import java.util.LinkedList;
import java.util.List;

public class CombineIndexedIOObjectsOperator
extends LicensedOperator {
    InputPortExtender indexedIOObjectsInput = new InputPortExtender("IndexedIOObjects", (Ports)this.getInputPorts());
    OutputPort indexedIOObjectsOutput = (OutputPort)this.getOutputPorts().createPort("result");

    public CombineIndexedIOObjectsOperator(OperatorDescription description) {
        super(description);
        this.indexedIOObjectsInput.start();
        this.getTransformer().addGenerationRule(this.indexedIOObjectsOutput, IndexedIOObjectsCollection.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        LinkedList<IndexedIOObjectsCollection> indexedIOObjects = new LinkedList<IndexedIOObjectsCollection>();
        List inputIOObjects = this.indexedIOObjectsInput.getData(IOObjectCollection.class, false);
        LinkedList inputIndexedCollections = new LinkedList();
        for (IOObjectCollection ioobjectCollection : inputIOObjects) {
            IndexedIOObjectsCollection.unfold(ioobjectCollection, inputIndexedCollections, IndexedIOObjectsCollection.class, this.indexedIOObjectsInput.getNamePrefix());
        }
        for (IndexedIOObjectsCollection indexedCollection : inputIndexedCollections) {
            indexedIOObjects.add(indexedCollection.clone());
        }
        if (indexedIOObjects.isEmpty()) {
            throw new UserError((Operator)this, 149, new Object[]{this.indexedIOObjectsInput.getNamePrefix()});
        }
        IndexedIOObjectsCollection resultContainer = (IndexedIOObjectsCollection)indexedIOObjects.remove(0);
        for (IndexedIOObjectsCollection currentIndexedIOObjectsContainerClone : indexedIOObjects) {
            try {
                IndexedIOObjectsCollection.isCompatible(resultContainer.getIndexColumnNames(), resultContainer.getIndexColumnTypes(), currentIndexedIOObjectsContainerClone.getIndexColumnNames(), currentIndexedIOObjectsContainerClone.getIndexColumnTypes());
            }
            catch (UserError e) {
                e.setOperator((Operator)this);
                throw e;
            }
            for (Pair<IndexedIOObject.IndexedIOObjectKey, IOObject> pair : currentIndexedIOObjectsContainerClone.getAll()) {
                resultContainer.put((IndexedIOObject.IndexedIOObjectKey)pair.getFirst(), (IOObject)pair.getSecond());
            }
        }
        this.indexedIOObjectsOutput.deliver((IOObject)resultContainer);
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

