/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.process.collection;

import com.owc.license.ProductInformation;
import com.owc.objects.indexed.IndexedIOObject;
import com.owc.objects.indexed.IndexedIOObjectsCollection;
import com.owc.operator.LicensedOperator;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.tools.Ontology;
import java.util.List;

public class ExtendIndexedIOObjectsOperator
extends LicensedOperator {
    public InputPort indexedIoobjectInputPort = (InputPort)this.getInputPorts().createPort("indexed_ioobject");
    public InputPort ioobjectInputPort = this.getInputPorts().createPort("ioobject", IOObject.class);
    public OutputPort indexedIOObjectsOutputPort = (OutputPort)this.getOutputPorts().createPort("indexedIoobject");
    public static String PARAMETER_GROUP_INFORMATION = "group_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_INFORMATION = "group_attribute_information";
    public static String PARAMETER_GROUP_ATTRIBUTE_NAME = "attribute_name";
    public static String PARAMETER_GROUP_ATTRIBUTE_TYPE = "attribute_type";
    public static String PARAMETER_GROUP_ATTRIBUTE_VALUE = "value";

    public ExtendIndexedIOObjectsOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.indexedIOObjectsOutputPort, IndexedIOObjectsCollection.class);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        IndexedIOObjectsCollection indexedIOObjectCollection = (IndexedIOObjectsCollection)this.indexedIoobjectInputPort.getDataOrNull(IndexedIOObjectsCollection.class);
        IOObject ioobject = this.ioobjectInputPort.getDataOrNull(IOObject.class);
        if (ioobject == null) {
            throw new UserError((Operator)this, 149, new Object[]{this.ioobjectInputPort});
        }
        String groupInformationAsString = this.getParameter(PARAMETER_GROUP_INFORMATION);
        List groupInformationList = ParameterTypeList.transformString2List((String)groupInformationAsString);
        String[] selectedGroupAttributeNames = new String[groupInformationList.size()];
        String[] nominalValues = new String[groupInformationList.size()];
        double[] numericalValues = new double[groupInformationList.size()];
        int[] selectedGroupAttributeTypes = new int[groupInformationList.size()];
        int i = 0;
        for (String[] currentGroup : groupInformationList) {
            String currentGroupAttributeInfo = currentGroup[0];
            String currentGroupValue = currentGroup[1];
            String[] currentGroupAttributeInfoList = ParameterTypeTupel.transformString2Tupel((String)currentGroupAttributeInfo);
            String currentAttributeName = currentGroupAttributeInfoList[0];
            String currentAttributeTypeName = currentGroupAttributeInfoList[1];
            if (currentAttributeName == null) {
                throw new UserError((Operator)this, 205, new Object[]{PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each group attribute name."});
            }
            if (currentAttributeTypeName.equals(Ontology.VALUE_TYPE_NAMES[1])) {
                nominalValues[i] = currentGroupValue;
                selectedGroupAttributeTypes[i] = 1;
            } else {
                try {
                    numericalValues[i] = Double.parseDouble(currentGroupValue);
                    selectedGroupAttributeTypes[i] = 2;
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 120, new Object[]{currentAttributeName, Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]});
                }
            }
            selectedGroupAttributeNames[i++] = currentAttributeName;
        }
        if (indexedIOObjectCollection == null) {
            indexedIOObjectCollection = new IndexedIOObjectsCollection(selectedGroupAttributeNames, selectedGroupAttributeTypes);
        } else {
            try {
                IndexedIOObjectsCollection.isCompatible(indexedIOObjectCollection.getIndexColumnNames(), indexedIOObjectCollection.getIndexColumnTypes(), selectedGroupAttributeNames, selectedGroupAttributeTypes);
            }
            catch (UserError e) {
                e.setOperator((Operator)this);
                throw e;
            }
        }
        indexedIOObjectCollection.put(new IndexedIOObject.IndexedIOObjectKey(nominalValues, numericalValues), ioobject);
        this.indexedIOObjectsOutputPort.deliver((IOObject)indexedIOObjectCollection);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString parameterAttributeName = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_NAME, "Please provide a name for each attribute that contains group information. If an indexedModel is provided, the selected Group attributes must be using matching names in the same order!", false);
        ParameterTypeCategory parameterAttributeType = new ParameterTypeCategory(PARAMETER_GROUP_ATTRIBUTE_TYPE, "Please select if the group attribute is either nominal or numerical.", new String[]{Ontology.VALUE_TYPE_NAMES[1], Ontology.VALUE_TYPE_NAMES[2]}, 0, false);
        ParameterTypeTupel parameterGroupAttribute = new ParameterTypeTupel(PARAMETER_GROUP_ATTRIBUTE_INFORMATION, "Please provide Information on the respective attribute- name and type.", new ParameterType[]{parameterAttributeName, parameterAttributeType});
        ParameterTypeString parameterValue = new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE_VALUE, "Please provide a value for the provided Group Attribute.", false, false);
        ParameterTypeList type = new ParameterTypeList(PARAMETER_GROUP_INFORMATION, "", (ParameterType)parameterGroupAttribute, (ParameterType)parameterValue, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

