/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.series;

import java.util.Arrays;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.MathArrays;

public class LastKnownValueInterpolator
implements UnivariateFunction {
    private final double[] yValues;
    private final double[] xValues;

    public LastKnownValueInterpolator(double[] x, double[] y) throws NullArgumentException, NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (x == null || y == null) {
            throw new NullArgumentException();
        }
        if (x.length == 0 || y.length == 0) {
            throw new NoDataException();
        }
        if (y.length != x.length) {
            throw new DimensionMismatchException(y.length, x.length);
        }
        MathArrays.checkOrder(x, MathArrays.OrderDirection.INCREASING, false);
        this.yValues = MathArrays.copyOf(x);
        this.xValues = MathArrays.copyOf(y);
    }

    @Override
    public double value(double x) {
        int index = Arrays.binarySearch(this.yValues, x);
        double fx = 0.0;
        fx = index < -1 ? this.xValues[-index - 2] : (index >= 0 ? this.xValues[index] : Double.NaN);
        return fx;
    }
}

