/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.series;

import com.owc.data.exampleset.SortedExampleSet;
import com.owc.license.ProductInformation;
import com.owc.metadata.PortExtenderMetaDataProvider;
import com.owc.metadata.UnionExampleSetsRule;
import com.owc.operator.LicensedOperator;
import com.owc.operator.series.LastKnownValueInterpolator;
import com.owc.operator.series.LinearInterpolator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.MetaDataProvider;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.Ontology;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.math3.analysis.UnivariateFunction;

public class ResampleMultipleSeriesOperator
extends LicensedOperator {
    public static final String PARAMETER_INCLUDE_SPECIAL = "include_special";
    public static final String PARAMETER_TIME_INDEX_ATTRIBUTE = "time_index_attribute";
    public static final String PARAMETER_SAMPLE_DISTANCE = "sample_distance";
    public static final String PARAMETER_DUPLICATE_SUFFIX = "suffix_for_duplicates";
    public static final String PARAMETER_INTERPOLATION_METHOD = "interpolation_method";
    public static final String PARAMETER_DIVIDE_BY_GAPS = "divide_by_gaps";
    public static final String PARAMETER_GAP_DISTANCE = "gap_distance";
    public static final String PARAMETER_GAP_COUNTER = "span_attribute";
    public static final String[] INTERPOLATION_METHODS = new String[]{"Last Known Value", "Linear Interpolation"};
    private InputPortExtender exampleSetInputExtender = new InputPortExtender("example sets", (Ports)this.getInputPorts());
    private OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("exampleSet output");

    public ResampleMultipleSeriesOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInputExtender.start();
        this.getTransformer().addRule((MDTransformationRule)new UnionExampleSetsRule(this, PARAMETER_DUPLICATE_SUFFIX, null, this.exampleSetInputExtender, this.exampleSetOutputPort, new InputPort[0]){

            @Override
            protected ExampleSetMetaData finalTransform(ExampleSetMetaData emd) {
                if (ResampleMultipleSeriesOperator.this.getParameterAsBoolean(ResampleMultipleSeriesOperator.PARAMETER_DIVIDE_BY_GAPS)) {
                    try {
                        emd.addAttribute(new AttributeMetaData(ResampleMultipleSeriesOperator.this.getParameterAsString(ResampleMultipleSeriesOperator.PARAMETER_GAP_COUNTER), 3));
                    }
                    catch (UndefinedParameterError undefinedParameterError) {
                        // empty catch block
                    }
                }
                return emd;
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List sets = this.exampleSetInputExtender.getData(ExampleSet.class, true);
        Iterator iterator = sets.iterator();
        while (iterator.hasNext()) {
            if (((ExampleSet)iterator.next()).size() != 0) continue;
            iterator.remove();
        }
        if (sets == null || sets.size() == 0) {
            throw new UserError((Operator)this, "toolkit.no_data_present");
        }
        double sampleDistance = this.getParameterAsDouble(PARAMETER_SAMPLE_DISTANCE);
        String duplicateSuffix = this.getParameterAsString(PARAMETER_DUPLICATE_SUFFIX);
        String indexAttributeName = this.getParameterAsString(PARAMETER_TIME_INDEX_ATTRIBUTE);
        String interpolationMethodName = this.getParameterAsString(PARAMETER_INTERPOLATION_METHOD);
        int interpolationMethod = 0;
        for (int i = 0; i < INTERPOLATION_METHODS.length; ++i) {
            if (!INTERPOLATION_METHODS[i].equals(interpolationMethodName)) continue;
            interpolationMethod = i;
            break;
        }
        boolean divideByGaps = this.getParameterAsBoolean(PARAMETER_DIVIDE_BY_GAPS);
        String spanAttributeName = "";
        double gapDistance = 0.0;
        if (divideByGaps) {
            spanAttributeName = this.getParameterAsString(PARAMETER_GAP_COUNTER);
            gapDistance = this.getParameterAsDouble(PARAMETER_GAP_DISTANCE);
        }
        double minIndex = Double.POSITIVE_INFINITY;
        double maxIndex = Double.NEGATIVE_INFINITY;
        HashMap<String, Integer> attributeNames = new HashMap<String, Integer>();
        HashMap<String, String> attributeRoles = new HashMap<String, String>();
        UnivariateFunction[][] interpolationFunctions = new UnivariateFunction[sets.size()][];
        NominalMapping[][] targetAttributeMapping = new NominalMapping[sets.size()][];
        String[][] targetAttributeNames = new String[sets.size()][];
        int[][] targetAttributeTypes = new int[sets.size()][];
        double[][] setIndices = new double[sets.size()][];
        int[] numberOfAttributes = new int[sets.size()];
        Integer one = new Integer(1);
        int indexAttributeType = -1;
        int setIndex = 0;
        for (Object set : sets) {
            Object example2;
            Attribute indexAttribute = set.getAttributes().get(indexAttributeName);
            if (indexAttribute == null) {
                throw new UserError((Operator)this, "toolkit.resample_series_data.attribute_missing", new Object[]{indexAttributeName});
            }
            if (!indexAttribute.isNumerical() && !indexAttribute.isDateTime()) {
                throw new UserError((Operator)this, "toolkit.2", new Object[]{indexAttributeName, this.getName(), "time index attribute"});
            }
            if (indexAttributeType >= 0 && indexAttributeType != indexAttribute.getValueType()) {
                throw new UserError((Operator)this, "toolkit.different_index_attribute_types", new Object[]{indexAttributeName});
            }
            indexAttributeType = indexAttribute.getValueType();
            set = new SortedExampleSet((ExampleSet)set, 1, false, new Attribute[]{indexAttribute});
            this.checkForStop();
            LinkedHashSet<Attribute> resampleAttributes = new LinkedHashSet<Attribute>();
            Iterator attributeIterator = null;
            if (this.getParameterAsBoolean(PARAMETER_INCLUDE_SPECIAL)) {
                attributeIterator = set.getAttributes().allAttributes();
                targetAttributeTypes[setIndex] = new int[set.getAttributes().allSize()];
                targetAttributeMapping[setIndex] = new NominalMapping[set.getAttributes().allSize()];
                targetAttributeNames[setIndex] = new String[set.getAttributes().allSize()];
            } else {
                attributeIterator = set.getAttributes().iterator();
                targetAttributeTypes[setIndex] = new int[set.getAttributes().size()];
                targetAttributeMapping[setIndex] = new NominalMapping[set.getAttributes().size()];
                targetAttributeNames[setIndex] = new String[set.getAttributes().size()];
            }
            int attributeIndex = 0;
            while (attributeIterator.hasNext()) {
                String targetAttributeName;
                Integer suffixCounter;
                Attribute attribute = (Attribute)attributeIterator.next();
                if (attribute.getName().equals(indexAttribute.getName())) continue;
                resampleAttributes.add(attribute);
                targetAttributeTypes[setIndex][attributeIndex] = attribute.getValueType();
                if (attribute.isNominal()) {
                    targetAttributeMapping[setIndex][attributeIndex] = attribute.getMapping();
                }
                if ((suffixCounter = (Integer)attributeNames.get(attribute.getName())) == null) {
                    attributeNames.put(attribute.getName(), one);
                    targetAttributeName = attribute.getName();
                } else {
                    attributeNames.put(attribute.getName(), suffixCounter + 1);
                    targetAttributeName = attribute.getName() + duplicateSuffix + (suffixCounter + 1);
                }
                targetAttributeNames[setIndex][attributeIndex] = targetAttributeName;
                String role = set.getAttributes().getRole(attribute).getSpecialName();
                if (!attributeRoles.containsKey(role)) {
                    attributeRoles.put(role, targetAttributeName);
                }
                ++attributeIndex;
            }
            numberOfAttributes[setIndex] = attributeIndex;
            double[] indices = new double[set.size()];
            double lastIndexValue = Double.NaN;
            int i = 0;
            double[][] values = new double[resampleAttributes.size()][set.size()];
            for (Object example2 : set) {
                double indexValue = example2.getValue(indexAttribute);
                if (Double.compare(indexValue, lastIndexValue) != 0) {
                    indices[i] = indexValue;
                    if (Double.isNaN(indexValue)) {
                        throw new UserError((Operator)this, "toolkit.2", new Object[]{indexAttributeName, this.getName(), "time index attribute"});
                    }
                    minIndex = Math.min(minIndex, indexValue);
                    maxIndex = Math.max(maxIndex, indexValue);
                    int j = 0;
                    for (Attribute resampleAttribute : resampleAttributes) {
                        values[j++][i] = example2.getValue(resampleAttribute);
                    }
                    ++i;
                }
                lastIndexValue = indexValue;
                if (i % 10000 != 0) continue;
                this.checkForStop();
            }
            if (i < set.size()) {
                indices = Arrays.copyOf(indices, i);
                for (int j = 0; j < resampleAttributes.size(); ++j) {
                    values[j] = Arrays.copyOf(values[j], i);
                }
            }
            UnivariateFunction[] setInterpolationFunctions = new UnivariateFunction[resampleAttributes.size()];
            i = 0;
            example2 = resampleAttributes.iterator();
            while (example2.hasNext()) {
                Attribute resampleAttribute = (Attribute)example2.next();
                setInterpolationFunctions[i] = resampleAttribute.isDateTime() ? new LinearInterpolator().interpolate(indices, values[i]) : (interpolationMethod == 1 && Ontology.ATTRIBUTE_VALUE_TYPE.isA(resampleAttribute.getValueType(), 2) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(resampleAttribute.getValueType(), 3) ? new LinearInterpolator().interpolate(indices, values[i]) : new LastKnownValueInterpolator(indices, values[i]));
                ++i;
            }
            setIndices[setIndex] = indices;
            interpolationFunctions[setIndex] = setInterpolationFunctions;
            ++setIndex;
        }
        double newMinIndex = minIndex - minIndex % sampleDistance;
        if (newMinIndex < minIndex) {
            newMinIndex += sampleDistance;
        }
        minIndex = newMinIndex;
        int numberOfResultAttributes = 1;
        if (divideByGaps) {
            ++numberOfResultAttributes;
        }
        for (int i = 0; i < sets.size(); ++i) {
            numberOfResultAttributes += numberOfAttributes[i];
        }
        String[] resultAttributeNames = new String[numberOfResultAttributes];
        int[] resultAttributeTypes = new int[numberOfResultAttributes];
        resultAttributeNames[0] = indexAttributeName;
        resultAttributeTypes[0] = indexAttributeType;
        int i = 1;
        if (divideByGaps) {
            resultAttributeNames[1] = spanAttributeName;
            resultAttributeTypes[1] = 3;
            ++i;
        }
        for (setIndex = 0; setIndex < sets.size(); ++setIndex) {
            for (int attributeIndex = 0; attributeIndex < numberOfAttributes[setIndex]; ++attributeIndex) {
                resultAttributeNames[i] = targetAttributeNames[setIndex][attributeIndex];
                resultAttributeTypes[i++] = targetAttributeTypes[setIndex][attributeIndex];
            }
        }
        ExampleSetCreator creator = new ExampleSetCreator(resultAttributeNames, resultAttributeTypes, false);
        int[] indexPointers = new int[sets.size()];
        int spanCounter = 1;
        int exampleCounter = 0;
        for (double currentIndex = minIndex; currentIndex <= maxIndex; currentIndex += sampleDistance) {
            creator.setValue(indexAttributeName, currentIndex);
            for (setIndex = 0; setIndex < sets.size(); ++setIndex) {
                for (int attributeIndex = 0; attributeIndex < numberOfAttributes[setIndex]; ++attributeIndex) {
                    double value = interpolationFunctions[setIndex][attributeIndex].value(currentIndex);
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(targetAttributeTypes[setIndex][attributeIndex], 1) && !Double.isNaN(value)) {
                        creator.setValue(targetAttributeNames[setIndex][attributeIndex], targetAttributeMapping[setIndex][attributeIndex].mapIndex((int)value));
                        continue;
                    }
                    creator.setValue(targetAttributeNames[setIndex][attributeIndex], value);
                }
            }
            if (divideByGaps) {
                creator.setValue(spanAttributeName, spanCounter);
                boolean isGap = true;
                for (setIndex = 0; setIndex < indexPointers.length; ++setIndex) {
                    while (indexPointers[setIndex] < setIndices[setIndex].length && setIndices[setIndex][indexPointers[setIndex]] <= currentIndex) {
                        int n = setIndex;
                        indexPointers[n] = indexPointers[n] + 1;
                    }
                    if (indexPointers[setIndex] >= setIndices[setIndex].length || !(setIndices[setIndex][indexPointers[setIndex]] - currentIndex < gapDistance)) continue;
                    isGap = false;
                }
                if (isGap) {
                    ++spanCounter;
                    currentIndex = Double.POSITIVE_INFINITY;
                    for (setIndex = 0; setIndex < indexPointers.length; ++setIndex) {
                        if (indexPointers[setIndex] >= setIndices[setIndex].length) continue;
                        currentIndex = Math.min(currentIndex, setIndices[setIndex][indexPointers[setIndex]]);
                    }
                    if (currentIndex % sampleDistance != 0.0) {
                        currentIndex += sampleDistance;
                        currentIndex -= currentIndex % sampleDistance;
                    }
                    currentIndex -= sampleDistance;
                }
            }
            creator.commit();
            if (++exampleCounter % 10000 != 0) continue;
            this.checkForStop();
        }
        ExampleSet resultSet = creator.finish();
        for (String role : attributeRoles.keySet()) {
            Attribute attribute = resultSet.getAttributes().get((String)attributeRoles.get(role));
            resultSet.getAttributes().setSpecialAttribute(attribute, role);
        }
        this.exampleSetOutputPort.deliver((IOObject)resultSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_TIME_INDEX_ATTRIBUTE, "The name of the time stamp attributes in all sets. They specify the time index of each example in the respective set. Needs to be numerical or date type.", (MetaDataProvider)new PortExtenderMetaDataProvider(this.exampleSetInputExtender, true), false, new int[]{2, 10, 11, 9}));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_INTERPOLATION_METHOD, "The interpolation method for real and numeric attributes. Timestamps will always be linearly interpolated and nominals and integer always with the last known value.", INTERPOLATION_METHODS, 0, false));
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_SAMPLE_DISTANCE, "The time distance between two new sample positions. Is in the original time index attribute's scale and unit.", Double.MIN_VALUE, Double.MAX_VALUE, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_INCLUDE_SPECIAL, "Also resample special attributes. Otherwise result set wil only contain regular attributes. Roles will be restored so that first special get's role.", false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_DIVIDE_BY_GAPS, "If checked, the gaps between signals will be omitted and instead an attribute with the counter will be increase.", false));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_GAP_DISTANCE, "The minimal time distance between two sample positions, so that it will be treated as gap. Is in the original time index attribute's scale and unit.", Double.MIN_VALUE, Double.MAX_VALUE, true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DIVIDE_BY_GAPS, true, true));
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_GAP_COUNTER, "The name for the attribute containing the index of the current signal span.", "SpanIndex", false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_DIVIDE_BY_GAPS, true, true));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_DUPLICATE_SUFFIX, "If two sets contain duplicate attribute names the second occuring will be renamed and this suffix will be attached plus a counter.", "_"));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

