/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.series.audio;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class PlayAudioOperator
extends LicensedOperator {
    private InputPort fileObjectInputPort = this.getInputPorts().createPort("file object", FileObject.class);
    private OneToOneExtender throughPorts = new OneToOneExtender("through", this.getInputPorts(), this.getOutputPorts());

    public PlayAudioOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(this.throughPorts.makePassThroughRule());
        this.throughPorts.start();
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(((FileObject)this.fileObjectInputPort.getData(FileObject.class)).openStream()));){
            final Clip clip = AudioSystem.getClip();
            clip.open(audioInputStream);
            clip.start();
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        clip.close();
                    }
                }
            });
        }
        catch (IOException e) {
            throw new OperatorException("io_error_while_playing", (Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new UserError((Operator)this, (Throwable)e, "unsupported_audio_format");
        }
        catch (LineUnavailableException e) {
            throw new UserError((Operator)this, (Throwable)e, "no_audio_device_available");
        }
        this.throughPorts.passDataThrough();
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitJackhammerExtension.PRODUCT_INFORMATION;
    }
}

