/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process;

import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.PortUserError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.RepositoryBlobObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DebugProcess
extends Process {
    private HashMap<String, String> macroOverrides = new HashMap();
    private IOObject[] portOverrides = new IOObject[0];

    public DebugProcess(String xml, HashMap<String, String> macroOverrrides, IOObject[] portOverrides) throws IOException, XMLException {
        super(xml);
        if (macroOverrrides != null) {
            this.macroOverrides = macroOverrrides;
        }
        if (portOverrides != null) {
            this.portOverrides = portOverrides;
        }
    }

    protected void loadInitialData(int firstPort, ProgressListener progressListener) throws UserError {
        ProcessContext context = this.getContext();
        if (context.getInputRepositoryLocations().isEmpty()) {
            return;
        }
        this.getLogger().info("Loading initial data" + (firstPort > 0 ? " (starting at port " + (firstPort + 1) + ")" : "") + ".");
        if (progressListener != null) {
            progressListener.setTotal(context.getInputRepositoryLocations().size());
            progressListener.setCompleted(0);
        }
        for (int i = firstPort; i < context.getInputRepositoryLocations().size(); ++i) {
            block21: {
                if (i < this.portOverrides.length) {
                    OutputPort port = (OutputPort)this.getRootOperator().getSubprocess(0).getInnerSources().getPortByIndex(i);
                    if (this.portOverrides[i] != null) {
                        port.deliver(this.portOverrides[i].copy());
                    } else {
                        port.deliver(null);
                    }
                } else {
                    String location = (String)context.getInputRepositoryLocations().get(i);
                    if (location == null || location.length() == 0) {
                        this.getLogger().fine("Input #" + (i + 1) + " not specified.");
                    } else if (i >= this.getRootOperator().getSubprocess(0).getInnerSources().getNumberOfPorts()) {
                        this.getLogger().warning("No input port available for process input #" + (i + 1) + ": " + location);
                    } else {
                        RepositoryLocation loc;
                        OutputPort port = (OutputPort)this.getRootOperator().getSubprocess(0).getInnerSources().getPortByIndex(i);
                        try {
                            loc = this.resolveRepositoryLocation(location);
                        }
                        catch (MalformedRepositoryLocationException e1) {
                            throw new PortUserError((Port)port, 325, new Object[]{e1.getMessage()});
                        }
                        catch (UserError e1) {
                            throw new PortUserError((Port)port, 325, new Object[]{e1.getMessage()});
                        }
                        try {
                            Entry entry = loc.locateEntry();
                            if (entry == null) {
                                throw new PortUserError((Port)port, 312, new Object[]{loc, "Entry does not exist."});
                            }
                            if (entry instanceof IOObjectEntry) {
                                this.getLogger().info("Assigning " + loc + " to input port " + port.getSpec() + ".");
                                if (port.isConnected()) {
                                    port.deliver(((IOObjectEntry)entry).retrieveData(null));
                                }
                                break block21;
                            }
                            if (entry instanceof BlobEntry) {
                                this.getLogger().info("Assigning " + loc + " to input port " + port.getSpec() + ".");
                                if (port.isConnected()) {
                                    port.deliver((IOObject)new RepositoryBlobObject(loc));
                                }
                                break block21;
                            }
                            this.getLogger().info("Cannot assigning " + loc + " to input port " + port.getSpec() + ": Repository location does not reference an IOObject entry.");
                            throw new PortUserError((Port)port, 312, new Object[]{loc, "Not an IOObject entry."});
                        }
                        catch (RepositoryException e) {
                            throw new PortUserError((Port)port, 312, new Object[]{loc, e.getMessage()});
                        }
                    }
                }
            }
            progressListener.setCompleted(i + 1);
        }
    }

    public void applyContextMacros() {
        super.applyContextMacros();
        for (Map.Entry<String, String> entry : this.macroOverrides.entrySet()) {
            this.getMacroHandler().addMacro(entry.getKey(), entry.getValue());
        }
    }
}

