/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NamedPortPairExtender
implements PortExtender {
    private final String inputName;
    private final String outputName;
    private final InputPorts inPorts;
    private final OutputPorts outPorts;
    private final List<NamedPortPair> managedPairs = new LinkedList<NamedPortPair>();
    private final MetaData preconditionMetaData;
    private boolean isChanging = false;
    private int runningId = 0;
    private final Observer<Port> observer = new Observer<Port>(){

        public void update(Observable<Port> observable, Port arg) {
            NamedPortPairExtender.this.updatePorts();
        }
    };
    private int minNumber = 0;

    public NamedPortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts) {
        this(name, inPorts, outPorts, null);
    }

    public NamedPortPairExtender(String name, InputPorts inPorts, OutputPorts outPorts, MetaData preconditionMetaData) {
        this(name, name, inPorts, outPorts, preconditionMetaData);
    }

    public NamedPortPairExtender(String inputName, String outputName, InputPorts inPorts, OutputPorts outPorts, MetaData preconditionMetaData) {
        this.inputName = inputName;
        this.outputName = outputName;
        this.inPorts = inPorts;
        this.outPorts = outPorts;
        this.preconditionMetaData = preconditionMetaData;
        inPorts.registerPortExtender((PortExtender)this);
        outPorts.registerPortExtender((PortExtender)this);
    }

    private void updatePorts() {
        if (!this.isChanging) {
            this.isChanging = true;
            boolean first = true;
            NamedPortPair foundDisconnected = null;
            Iterator<NamedPortPair> i = this.managedPairs.iterator();
            while (i.hasNext()) {
                NamedPortPair pair = i.next();
                if (pair.getInputPort().isConnected() || pair.getInputPort().isLocked() || pair.getOutputPort().isConnected() || pair.getOutputPort().isLocked()) continue;
                if (first) {
                    first = false;
                    foundDisconnected = pair;
                    continue;
                }
                if (this.minNumber != 0) continue;
                this.deletePorts(pair);
                i.remove();
            }
            if (foundDisconnected == null || this.managedPairs.size() < this.minNumber) {
                do {
                    this.managedPairs.add(this.createPort());
                } while (this.managedPairs.size() < this.minNumber);
            } else if (this.minNumber == 0) {
                this.managedPairs.remove(foundDisconnected);
                this.managedPairs.add(foundDisconnected);
                this.inPorts.pushDown((Port)foundDisconnected.getInputPort());
                this.outPorts.pushDown((Port)foundDisconnected.getOutputPort());
            }
            this.fixNames();
            this.isChanging = false;
        }
    }

    public void start() {
        this.managedPairs.add(this.createPort());
        this.fixNames();
        this.inPorts.addObserver(this.observer, false);
        this.outPorts.addObserver(this.observer, false);
    }

    private NamedPortPair createPort() {
        ++this.runningId;
        InputPort in = (InputPort)this.inPorts.createPassThroughPort(this.inputName + " " + this.runningId);
        if (this.preconditionMetaData != null) {
            in.addPrecondition((Precondition)new SimplePrecondition(in, this.preconditionMetaData, false));
        }
        OutputPort out = (OutputPort)this.outPorts.createPassThroughPort(this.outputName + " " + this.runningId);
        return new NamedPortPair(in, out);
    }

    private void deletePorts(NamedPortPair pair) {
        if (pair.outputPort.isConnected()) {
            pair.outputPort.disconnect();
        }
        this.inPorts.removePort((Port)pair.inputPort);
        this.outPorts.removePort((Port)pair.outputPort);
    }

    private void fixNames() {
        this.runningId = 0;
        for (NamedPortPair pair : this.managedPairs) {
            ++this.runningId;
            this.inPorts.renamePort((Port)pair.inputPort, this.inputName + "_tmp_" + this.runningId);
            this.outPorts.renamePort((Port)pair.outputPort, this.outputName + "_tmp_" + this.runningId);
        }
        this.runningId = 0;
        for (NamedPortPair pair : this.managedPairs) {
            ++this.runningId;
            this.inPorts.renamePort((Port)pair.inputPort, this.inputName + " " + this.runningId);
            this.outPorts.renamePort((Port)pair.outputPort, this.outputName + " " + this.runningId);
        }
    }

    public MDTransformationRule makePassThroughRule() {
        return new MDTransformationRule(){

            public void transformMD() {
                for (NamedPortPair pair : NamedPortPairExtender.this.managedPairs) {
                    MetaData inData = pair.inputPort.getMetaData();
                    if (inData != null) {
                        inData = NamedPortPairExtender.this.transformMetaData(inData.clone());
                        inData.addToHistory(pair.getOutputPort());
                        pair.outputPort.deliverMD(inData);
                        continue;
                    }
                    pair.outputPort.deliverMD(null);
                }
            }
        };
    }

    protected MetaData transformMetaData(MetaData md) {
        return md;
    }

    public void passDataThrough() {
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getAnyDataOrNull();
            pair.outputPort.deliver(data);
        }
    }

    public void passCloneThrough() {
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getAnyDataOrNull();
            if (data != null) {
                pair.outputPort.deliver(data.copy());
                continue;
            }
            pair.outputPort.deliver(null);
        }
    }

    public List<NamedPortPair> getManagedPairs() {
        return Collections.unmodifiableList(this.managedPairs);
    }

    @Deprecated
    public <T extends IOObject> List<T> getData() throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getDataOrNull();
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public <T extends IOObject> List<T> getData(Class<T> desiredClass) throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.inputPort.getDataOrNull(desiredClass);
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    @Deprecated
    public <T extends IOObject> List<T> getOutputData() throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.outputPort.getDataOrNull();
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public <T extends IOObject> List<T> getOutputData(Class<T> desiredClass) throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (NamedPortPair pair : this.managedPairs) {
            IOObject data = pair.outputPort.getDataOrNull(desiredClass);
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public void deliver(List<? extends IOObject> ioObjectList) {
        Iterator<NamedPortPair> portIterator = this.getManagedPairs().iterator();
        for (IOObject iOObject : ioObjectList) {
            NamedPortPair pair = portIterator.next();
            IOObject data = pair.inputPort.getAnyDataOrNull();
            while (data == null) {
                data = portIterator.next().inputPort.getAnyDataOrNull();
            }
            pair.outputPort.deliver(iOObject);
        }
    }

    public String getNamePrefix() {
        return this.inputName + " ";
    }

    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    public static class NamedPortPair {
        private final InputPort inputPort;
        private final OutputPort outputPort;

        private NamedPortPair(InputPort inputPort, OutputPort outputPort) {
            this.inputPort = inputPort;
            this.outputPort = outputPort;
        }

        public InputPort getInputPort() {
            return this.inputPort;
        }

        public OutputPort getOutputPort() {
            return this.outputPort;
        }
    }
}

