/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process.ports;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class OneToManyExtender
implements PortExtender {
    private final String name;
    private final Ports<InputPort> oneInputPorts;
    private final ArrayList<Ports<OutputPort>> manyOutputPorts;
    private final MetaData preconditionMetaData;
    private int minNumber = 0;
    protected final List<PortRow> managedRows = new LinkedList<PortRow>();
    private boolean isChanging = false;
    private final Observer<Port> observer = new Observer<Port>(){

        public void update(Observable<Port> observable, Port arg) {
            OneToManyExtender.this.updatePorts();
        }
    };

    public OneToManyExtender(String name, InputPorts inputPorts, OutputPorts[] multiOutputPorts) {
        this(name, inputPorts, multiOutputPorts, null);
    }

    public OneToManyExtender(String name, InputPorts inputPorts, OutputPorts[] multiOutputPorts, MetaData preconditionMetaData) {
        this.name = name;
        this.oneInputPorts = inputPorts;
        this.preconditionMetaData = preconditionMetaData;
        this.manyOutputPorts = new ArrayList<OutputPorts>(Arrays.asList(multiOutputPorts));
        inputPorts.registerPortExtender((PortExtender)this);
        for (OutputPorts ports : multiOutputPorts) {
            ports.registerPortExtender((PortExtender)this);
        }
    }

    public <T extends IOObject> List<T> getData(Class<T> desiredClass) throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (PortRow row : this.managedRows) {
            IOObject data = row.getInputPort().getDataOrNull(desiredClass);
            if (data == null) continue;
            results.add(data);
        }
        return results;
    }

    public <T extends IOObject> List<T> getDataOrNull(Class<T> desiredClass) throws UserError {
        LinkedList<IOObject> results = new LinkedList<IOObject>();
        for (PortRow row : this.managedRows) {
            IOObject data = row.getInputPort().getDataOrNull(desiredClass);
            results.add(data);
        }
        return results;
    }

    public void start() {
        this.managedRows.add(this.createPortRow(1));
        this.oneInputPorts.addObserver(this.observer, false);
        for (Ports<OutputPort> ports : this.manyOutputPorts) {
            ports.addObserver(this.observer, false);
        }
    }

    public OneToManyExtender startAndReturn() {
        this.start();
        return this;
    }

    public void deliver(List<? extends IOObject> objects) {
        int i = 0;
        for (IOObject iOObject : objects) {
            if (iOObject != null && this.managedRows.size() > i) {
                for (OutputPort port : this.managedRows.get((int)i).manyOutputPorts) {
                    port.deliver(iOObject);
                }
            }
            ++i;
        }
    }

    public String getNamePrefix() {
        return this.name + " ";
    }

    public void ensureMinimumNumberOfPorts(int minNumber) {
        this.minNumber = minNumber;
        this.updatePorts();
    }

    private synchronized void updatePorts() {
        if (!this.isChanging) {
            int minNumber = Math.max(0, this.minNumber - 1);
            int i = 1;
            for (PortRow managedRow : this.managedRows) {
                boolean isUsed = managedRow.getInputPort().isConnected() || managedRow.getInputPort().isLocked();
                for (OutputPort port : managedRow.getOutputPorts()) {
                    isUsed |= port.isConnected() || port.isLocked();
                }
                if (isUsed && i > minNumber) {
                    minNumber = i;
                }
                ++i;
            }
            this.isChanging = true;
            if (this.managedRows.size() > ++minNumber) {
                ListIterator<PortRow> iterator = this.managedRows.listIterator(minNumber);
                while (iterator.hasNext()) {
                    PortRow row = iterator.next();
                    this.deletePortRow(row);
                    iterator.remove();
                }
            } else {
                for (int j = this.managedRows.size(); j < minNumber; ++j) {
                    this.managedRows.add(this.createPortRow(j + 1));
                }
            }
            this.isChanging = false;
        }
    }

    private PortRow createPortRow(int number) {
        InputPort newOneInputPort = (InputPort)this.oneInputPorts.createPassThroughPort(this.name + " " + number);
        if (this.preconditionMetaData != null) {
            newOneInputPort.addPrecondition((Precondition)new SimplePrecondition(newOneInputPort, this.preconditionMetaData, false));
        }
        ArrayList<OutputPort> newManyOutputPorts = new ArrayList<OutputPort>(this.manyOutputPorts.size());
        for (Ports<OutputPort> ports : this.manyOutputPorts) {
            OutputPort newManyOutputPort = (OutputPort)ports.createPassThroughPort(this.name + " " + number);
            newManyOutputPorts.add(newManyOutputPort);
        }
        return new PortRow(newOneInputPort, newManyOutputPorts);
    }

    private void deletePortRow(PortRow row) {
        this.oneInputPorts.removePort((Port)row.oneInputPort);
        for (OutputPort outputPort : row.manyOutputPorts) {
            if (outputPort.isConnected()) {
                outputPort.disconnect();
            }
            outputPort.getPorts().removePort((Port)outputPort);
        }
    }

    public boolean isConnected(OutputPorts ports) {
        for (PortRow pair : this.managedRows) {
            for (OutputPort port : pair.manyOutputPorts) {
                if (port.getPorts() != ports || !port.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnected() {
        for (PortRow pair : this.managedRows) {
            for (OutputPort port : pair.manyOutputPorts) {
                if (!port.isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    public MDTransformationRule makePassThroughRule() {
        return new MDTransformationRule(){

            public void transformMD() {
                for (PortRow row : OneToManyExtender.this.managedRows) {
                    MetaData metaData = row.oneInputPort.getMetaData();
                    for (OutputPort outputPort : row.manyOutputPorts) {
                        MetaData clonedMetaData = null;
                        if (metaData != null) {
                            clonedMetaData = metaData.clone();
                            clonedMetaData.addToHistory(outputPort);
                        }
                        outputPort.deliverMD(clonedMetaData);
                    }
                }
            }
        };
    }

    public List<PortRow> getPortRows() {
        return this.managedRows;
    }

    public void passDataThrough() {
        for (PortRow row : this.managedRows) {
            IOObject data = row.oneInputPort.getAnyDataOrNull();
            for (OutputPort out : row.manyOutputPorts) {
                out.deliver(data);
            }
        }
    }

    protected MetaData transformMetaData(MetaData md) {
        return md;
    }

    public class PortRow {
        protected InputPort oneInputPort;
        protected ArrayList<OutputPort> manyOutputPorts;

        public PortRow(InputPort singlePort, ArrayList<OutputPort> multiPorts) {
            this.oneInputPort = singlePort;
            this.manyOutputPorts = multiPorts;
        }

        public boolean isDisconnected() {
            if (this.oneInputPort.isConnected() || this.oneInputPort.isLocked()) {
                return false;
            }
            for (Port port : this.manyOutputPorts) {
                if (!port.isConnected() && !port.isLocked()) continue;
                return false;
            }
            return true;
        }

        public InputPort getInputPort() {
            return this.oneInputPort;
        }

        public List<OutputPort> getOutputPorts() {
            return this.manyOutputPorts;
        }
    }
}

