/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.gc.iotools.stream.os.OutputStreamToInputStream;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.owc.repository.WebDAVEntry;
import com.owc.repository.WebDAVFolder;
import com.owc.repository.WebDAVRepository;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.RepositoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;

public class WebDAVBinaryEntry
extends WebDAVEntry
implements BlobEntry {
    public static final QName QNAME_MIME = new QName("http://oldworldcomputing.com/namespaces/dav-repository", "mime", "dr");
    private long date;
    private int revision;
    private long size;
    private String mime;

    public WebDAVBinaryEntry(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, String entryName, String owner, String description, long date, boolean isReadOnly) {
        super(repository, sardine, containingFolder, entryName, "blob", owner, description, isReadOnly);
    }

    public WebDAVBinaryEntry(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, DavResource resource) {
        super(repository, sardine, containingFolder, resource.getName(), resource.getCustomPropsNS().get(QNAME_TYPE), null, resource.getCustomPropsNS().get(QNAME_DESCRIPTION), false);
        try {
            this.owner = sardine.getAcl(this.getDAVURL()).getOwner();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.size = resource.getContentLength();
        this.date = resource.getCreation().getTime();
    }

    public long getDate() {
        return this.date;
    }

    public int getRevision() {
        return this.revision;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream openInputStream() throws RepositoryException {
        try {
            return this.sardine.get(this.getDAVURL());
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't access binary data in DAV.", (Throwable)e);
        }
    }

    public OutputStream openOutputStream(String mimeType) throws RepositoryException {
        this.mime = mimeType;
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(QNAME_MIME, mimeType);
        try {
            this.sardine.patch(this.getDAVURL(), properties);
        }
        catch (IOException e) {
            throw new RepositoryException("Couldn't store mime type in DAV", (Throwable)e);
        }
        OutputStreamToInputStream<Void> out = new OutputStreamToInputStream<Void>(){

            @Override
            protected Void doRead(InputStream istream) throws Exception {
                WebDAVBinaryEntry.this.sardine.put(WebDAVBinaryEntry.this.getDAVURL(), istream);
                return null;
            }
        };
        return out;
    }

    public String getMimeType() {
        return this.mime;
    }
}

