/*
 * Decompiled with CFR 0.152.
 */
package com.owc.repository;

import com.github.sardine.Sardine;
import com.owc.repository.WebDAVFolder;
import com.owc.repository.WebDAVRepository;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.xml.namespace.QName;

public abstract class WebDAVEntry
implements Entry {
    public static final QName QNAME_DESCRIPTION = new QName("http://oldworldcomputing.com/namespaces/dav-repository", "description", "dr");
    public static final QName QNAME_TYPE = new QName("http://oldworldcomputing.com/dav-repository/type", "type", "dr");
    protected WebDAVRepository repository;
    protected Sardine sardine;
    protected WebDAVFolder containingFolder;
    protected String entryName;
    protected String type;
    protected String owner;
    protected String description;
    protected boolean isReadOnly;

    public WebDAVEntry(WebDAVRepository repository, Sardine sardine, WebDAVFolder containingFolder, String entryName, String type, String owner, String description, boolean isReadOnly) {
        this.sardine = sardine;
        this.containingFolder = containingFolder;
        this.entryName = entryName;
        this.type = type;
        this.owner = owner;
        this.description = description;
        this.isReadOnly = isReadOnly;
        this.repository = repository;
    }

    public String getName() {
        return this.entryName;
    }

    public String getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean rename(String newName) throws RepositoryException {
        try {
            this.sardine.move(this.getDAVURL(), this.containingFolder.getDAVURL() + "/" + newName);
            this.entryName = newName;
            this.repository.fireEntryRenamed(this);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not rename entry.", (Throwable)e);
        }
        return true;
    }

    public boolean move(Folder newParent) throws RepositoryException {
        try {
            this.sardine.move(this.getDAVURL(), ((WebDAVFolder)newParent).getDAVURL() + "/" + this.entryName);
            this.containingFolder.removeEntry(this);
            this.containingFolder = (WebDAVFolder)newParent;
            this.containingFolder.addEntry(this);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not move entry.", (Throwable)e);
        }
        return true;
    }

    public boolean move(Folder newParent, String newName) throws RepositoryException {
        try {
            this.sardine.move(this.getDAVURL(), ((WebDAVFolder)newParent).getDAVURL() + "/" + newName);
            this.entryName = newName;
            this.containingFolder.removeEntry(this);
            this.containingFolder = (WebDAVFolder)newParent;
            this.containingFolder.addEntry(this);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not move entry.", (Throwable)e);
        }
        return true;
    }

    public Folder getContainingFolder() {
        return this.containingFolder;
    }

    public boolean willBlock() {
        return true;
    }

    public RepositoryLocation getLocation() {
        try {
            if (this.containingFolder != null) {
                return new RepositoryLocation(this.containingFolder.getLocation(), this.entryName);
            }
            return new RepositoryLocation("//" + this.entryName + "/");
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException("This my not happen", e);
        }
    }

    public void delete() throws RepositoryException {
        try {
            this.sardine.delete(this.getDAVURL());
            this.containingFolder.removeEntry(this);
        }
        catch (IOException e) {
            throw new RepositoryException("Could not delete entry.", (Throwable)e);
        }
    }

    public Collection<Action> getCustomActions() {
        return new LinkedList<Action>();
    }

    public String getDAVURL() {
        if (this.containingFolder != null) {
            return this.containingFolder.getDAVURL() + "/" + this.entryName;
        }
        return this.repository.getBaseURL();
    }
}

