/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.SetRelation;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public final class ExampleSetCreator
implements Serializable {
    private static final long serialVersionUID = -7714624000570742711L;
    private static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    private DateFormat dateFormat;
    private DoubleArrayDataRow dataRow;
    private MemoryExampleTable exampleTable;
    private Map<String, Attribute> attributeMap;
    private ExampleSetMetaData exampleSetMetaData;
    private boolean isPreMappingBinominals;
    private boolean isReopened;
    private DoubleArrayDataRow nextDataRow;

    public ExampleSetCreator(String[] attributeNames, int[] valueTypes) {
        DEFAULT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat = (DateFormat)DEFAULT_DATE_FORMAT.clone();
        this.init(attributeNames, valueTypes, true);
    }

    public ExampleSetCreator(Map<String, Integer> nameAndTypes) {
        DEFAULT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat = (DateFormat)DEFAULT_DATE_FORMAT.clone();
        String[] attributeNames = new String[nameAndTypes.size()];
        int[] attributeTypes = new int[nameAndTypes.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : nameAndTypes.entrySet()) {
            attributeNames[i] = entry.getKey();
            attributeTypes[i++] = entry.getValue();
        }
        this.init(attributeNames, attributeTypes, true);
    }

    public ExampleSetCreator(String[] attributeNames, int[] valueTypes, boolean preMapBinominal) {
        DEFAULT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat = (DateFormat)DEFAULT_DATE_FORMAT.clone();
        this.init(attributeNames, valueTypes, preMapBinominal);
    }

    private void init(String[] attributeNames, int[] valueTypes, boolean preMapBinominal) {
        this.exampleTable = new MemoryExampleTable(new Attribute[0]);
        this.attributeMap = new HashMap<String, Attribute>();
        this.exampleSetMetaData = new ExampleSetMetaData();
        this.isPreMappingBinominals = preMapBinominal;
        int i = 0;
        for (String attributeName : attributeNames) {
            Attribute attribute = AttributeFactory.createAttribute((String)attributeName, (int)valueTypes[i]);
            if (attribute.getValueType() == 6 && preMapBinominal) {
                attribute.getMapping().setMapping("false", 0);
                attribute.getMapping().setMapping("true", 1);
            }
            this.exampleTable.addAttribute(attribute);
            this.attributeMap.put(attributeName, attribute);
            AttributeMetaData amd = new AttributeMetaData(attributeName, valueTypes[i]);
            if (attribute.getValueType() == 6 && preMapBinominal) {
                HashSet<String> valueSet = new HashSet<String>(2);
                valueSet.add("true");
                valueSet.add("false");
                amd.setValueSet(valueSet, SetRelation.EQUAL);
            }
            this.exampleSetMetaData.addAttribute(amd);
            ++i;
        }
        double[] values = new double[this.attributeMap.size()];
        Arrays.fill(values, Double.NaN);
        this.dataRow = new DoubleArrayDataRow(values);
        MDInteger mdInteger = new MDInteger();
        mdInteger.increaseByUnknownAmount();
        this.exampleSetMetaData.setNumberOfExamples(mdInteger);
    }

    public ExampleSetCreator(ExampleSet exampleSet) {
        this(ExampleSetCreator.getAttributeNames(exampleSet), ExampleSetCreator.getTypes(exampleSet), false);
    }

    public ExampleSetCreator(List<AttributeRole> roles) {
        this(ExampleSetCreator.getAttributeNames(roles), ExampleSetCreator.getTypes(roles));
    }

    public ExampleSetCreator getInstance() {
        String[] attributeNames = new String[this.exampleTable.getAttributes().length];
        int[] valueTypes = new int[this.exampleTable.getAttributes().length];
        for (int i = 0; i < attributeNames.length; ++i) {
            Attribute attribute = this.exampleTable.getAttributes()[i];
            attributeNames[i] = attribute.getName();
            valueTypes[i] = attribute.getValueType();
        }
        return new ExampleSetCreator(attributeNames, valueTypes, this.isPreMappingBinominals);
    }

    public ExampleSetCreator getExtendedInstance(String[] additionalAttributes, int[] types) throws OperatorException {
        int i;
        for (String additionalName : additionalAttributes) {
            if (!this.attributeMap.containsKey(additionalName)) continue;
            throw new OperatorException("Duplicate attribute names");
        }
        int thisNumerOfAttributes = this.exampleTable.getAttributes().length;
        String[] attributeNames = new String[thisNumerOfAttributes + additionalAttributes.length];
        int[] valueTypes = new int[thisNumerOfAttributes + types.length];
        for (i = 0; i < thisNumerOfAttributes; ++i) {
            Attribute attribute = this.exampleTable.getAttributes()[i];
            attributeNames[i] = attribute.getName();
            valueTypes[i] = attribute.getValueType();
        }
        for (i = thisNumerOfAttributes; i < attributeNames.length; ++i) {
            attributeNames[i] = additionalAttributes[i - thisNumerOfAttributes];
            valueTypes[i] = types[i - thisNumerOfAttributes];
        }
        return new ExampleSetCreator(attributeNames, valueTypes, this.isPreMappingBinominals);
    }

    public final void setValue(String attributeName, double value) {
        this.dataRow.set(this.attributeMap.get(attributeName), value);
    }

    public final void setValue(String attributeName, Date value) {
        this.dataRow.set(this.attributeMap.get(attributeName), (double)value.getTime());
    }

    public final void setValue(String attributeName, boolean value) {
        Attribute attribute = this.attributeMap.get(attributeName);
        if (value) {
            this.dataRow.set(attribute, (double)attribute.getMapping().mapString("true"));
        } else {
            this.dataRow.set(attribute, (double)attribute.getMapping().mapString("false"));
        }
    }

    public final void setStringValue(String attributeName, String stringValue) throws ParseException {
        Attribute attribute = this.attributeMap.get(attributeName);
        int valueType = attribute.getValueType();
        if (valueType == 7 || valueType == 6 || valueType == 1 || valueType == 5) {
            this.dataRow.set(attribute, (double)attribute.getMapping().mapString(stringValue));
        } else if (valueType == 3) {
            this.dataRow.set(attribute, (double)((int)Double.parseDouble(stringValue)));
        } else if (valueType == 2 || valueType == 4) {
            this.dataRow.set(attribute, Double.parseDouble(stringValue));
        } else if (valueType == 10 || valueType == 9 || valueType == 11) {
            this.dataRow.set(attribute, (double)this.dateFormat.parse(stringValue).toInstant().toEpochMilli());
        }
        this.dataRow.set(attribute, (double)attribute.getMapping().mapString(stringValue));
    }

    public final void setValue(String attributeName, String value) {
        Attribute attribute = this.attributeMap.get(attributeName);
        this.dataRow.set(attribute, (double)attribute.getMapping().mapString(value));
    }

    public final void setMissing(String attributeName) {
        Attribute attribute = this.attributeMap.get(attributeName);
        this.dataRow.set(attribute, Double.NaN);
    }

    public void setValuesByExample(Example example) {
        Iterator attributesIterator = example.getAttributes().allAttributes();
        while (attributesIterator.hasNext()) {
            Attribute attribute = (Attribute)attributesIterator.next();
            double exampleValue = example.getValue(attribute);
            if (Double.isNaN(exampleValue)) {
                this.setValue(attribute.getName(), Double.NaN);
                continue;
            }
            if (attribute.isNominal()) {
                this.setValue(attribute.getName(), example.getValueAsString(attribute));
                continue;
            }
            this.setValue(attribute.getName(), exampleValue);
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void reopen(int index) {
        this.nextDataRow = this.dataRow;
        this.dataRow = (DoubleArrayDataRow)this.exampleTable.getDataRow(index);
        this.isReopened = true;
    }

    public int size() {
        return this.exampleTable.size();
    }

    public void commit() {
        if (!this.isReopened) {
            this.exampleTable.addDataRow((DataRow)this.dataRow);
            double[] values = new double[this.attributeMap.size()];
            Arrays.fill(values, Double.NaN);
            this.dataRow = new DoubleArrayDataRow(values);
        } else {
            this.isReopened = false;
            this.dataRow = this.nextDataRow;
            this.nextDataRow = null;
        }
    }

    public void commitAndKeep() {
        this.exampleTable.addDataRow((DataRow)this.dataRow);
        double[] values = new double[this.attributeMap.size()];
        System.arraycopy(this.dataRow.getData(), 0, values, 0, values.length);
        this.dataRow = new DoubleArrayDataRow(values);
    }

    public void resetRow() {
        Arrays.fill(this.dataRow.getData(), Double.NaN);
    }

    public void resetValue(String attributeName) {
        Attribute attribute = this.attributeMap.get(attributeName);
        this.dataRow.set(attribute, Double.NaN);
    }

    public ExampleSet finish() {
        return this.exampleTable.createExampleSet();
    }

    public ExampleSet finishAndReset() {
        ExampleSet set = this.exampleTable.createExampleSet();
        this.init(ExampleSetCreator.getAttributeNames(set), ExampleSetCreator.getTypes(set), false);
        return set;
    }

    public ExampleSetMetaData getMetaData() {
        return this.exampleSetMetaData;
    }

    private static int[] getTypes(ExampleSet set) {
        int i = 0;
        int[] types = new int[set.getAttributes().allSize()];
        Iterator allAttributesIterator = set.getAttributes().allAttributes();
        while (allAttributesIterator.hasNext()) {
            types[i] = ((Attribute)allAttributesIterator.next()).getValueType();
            ++i;
        }
        return types;
    }

    private static String[] getAttributeNames(ExampleSet set) {
        int i = 0;
        String[] names = new String[set.getAttributes().allSize()];
        Iterator allAttributesIterator = set.getAttributes().allAttributes();
        while (allAttributesIterator.hasNext()) {
            names[i] = ((Attribute)allAttributesIterator.next()).getName();
            ++i;
        }
        return names;
    }

    private static String[] getAttributeNames(List<AttributeRole> roles) {
        String[] names = new String[roles.size()];
        int i = 0;
        for (AttributeRole role : roles) {
            names[i] = role.getAttribute().getName();
            ++i;
        }
        return names;
    }

    private static int[] getTypes(List<AttributeRole> roles) {
        int[] types = new int[roles.size()];
        int i = 0;
        for (AttributeRole role : roles) {
            types[i] = role.getAttribute().getValueType();
            ++i;
        }
        return types;
    }
}

