/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import java.util.Iterator;

public class ExampleSetMaterializer {
    public static ExampleSet materializeExampleSet(ExampleSet sourceSet) {
        return ExampleSetMaterializer.materializeExampleSetOnHeap(sourceSet);
    }

    public static ExampleSet materializeExampleSetOnHeap(ExampleSet sourceSet) {
        int i;
        DataRow targetRow;
        Attribute[] sourceAttributes = new Attribute[sourceSet.getAttributes().allSize()];
        Attribute[] targetAttributes = new Attribute[sourceSet.getAttributes().allSize()];
        String[] targetRoles = new String[targetAttributes.length];
        Iterator iterator = sourceSet.getAttributes().allAttributeRoles();
        for (int i2 = 0; i2 < sourceAttributes.length; ++i2) {
            AttributeRole sourceRole = (AttributeRole)iterator.next();
            sourceAttributes[i2] = sourceRole.getAttribute();
            targetAttributes[i2] = AttributeFactory.createAttribute((String)sourceAttributes[i2].getName(), (int)sourceAttributes[i2].getValueType());
            if (sourceAttributes[i2].isNominal()) {
                targetAttributes[i2].setMapping((NominalMapping)sourceAttributes[i2].getMapping().clone());
            }
            if (sourceRole.isSpecial()) {
                targetRoles[i2] = sourceRole.getSpecialName();
            }
            targetAttributes[i2].getAnnotations().addAll(sourceAttributes[i2].getAnnotations());
        }
        int dataRowType = ExampleSetMaterializer.findDataRowType(sourceSet);
        boolean isDataRowTypeSparse = ExampleSetMaterializer.isSparseType(dataRowType);
        MemoryExampleTable targetTable = new MemoryExampleTable(targetAttributes);
        DataRowFactory rowFactory = new DataRowFactory(dataRowType, '.');
        if (isDataRowTypeSparse) {
            for (Example example : sourceSet) {
                targetRow = rowFactory.create(targetAttributes.length);
                for (i = 0; i < sourceAttributes.length; ++i) {
                    double value = example.getValue(sourceAttributes[i]);
                    if (value == 0.0) continue;
                    targetRow.set(targetAttributes[i], value);
                }
                targetTable.addDataRow(targetRow);
            }
        } else {
            for (Example example : sourceSet) {
                targetRow = rowFactory.create(targetAttributes.length);
                for (i = 0; i < sourceAttributes.length; ++i) {
                    targetRow.set(targetAttributes[i], example.getValue(sourceAttributes[i]));
                }
                targetTable.addDataRow(targetRow);
            }
        }
        ExampleSet createdSet = targetTable.createExampleSet();
        for (int i3 = 0; i3 < targetAttributes.length; ++i3) {
            createdSet.getAttributes().setSpecialAttribute(targetAttributes[i3], targetRoles[i3]);
        }
        createdSet.getAnnotations().addAll(sourceSet.getAnnotations());
        return createdSet;
    }

    private static boolean isSparseType(int dataRowType) {
        switch (dataRowType) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private static int findDataRowType(ExampleSet sourceSet) {
        int dataRowType = 0;
        if (sourceSet.size() > 0) {
            DataRow usedRow = sourceSet.getExample(0).getDataRow();
            for (int i = 0; i < 15; ++i) {
                if (!new DataRowFactory(i, '.').create(1).getClass().isInstance(usedRow)) continue;
                dataRowType = i;
                break;
            }
        }
        return dataRowType;
    }
}

