/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.owc.tools.StringTools;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExampleSetModifier {
    public static final String[][] ORDER_OPTIONS = new String[][]{{"Group_Attribute", "Attribute_Group"}, {"Attribute_Specifier", "Specifier_Attribute"}, {"Group_Attribute_Specifier", "Group_Specifier_Attribute", "Attribute_Group_Specifier", "Attribute_Specifier_Group", "Specifier_Group_Attribute", "Specifier_Attribute_Group"}};
    public static final Integer[][][] CAPTURING_GROUP = new Integer[][][]{{{1, 2}, {2, 1}}, {{1, 2}, {2, 1}}, {{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {3, 1, 2}, {2, 3, 1}, {3, 2, 1}}};

    public static final Attribute createAttribute(ExampleSet exampleSet, String attributeName, int attributeType, boolean init) {
        Attribute attribute = AttributeFactory.createAttribute((String)attributeName, (int)attributeType);
        exampleSet.getExampleTable().addAttribute(attribute);
        exampleSet.getAttributes().addRegular(attribute);
        if (init) {
            for (Example example : exampleSet) {
                example.setValue(attribute, Double.NaN);
            }
        }
        return attribute;
    }

    public static Map<String, String> getBestPracticeNameTranslations(Operator operator, List<String> attributeNames) throws UserError {
        return ExampleSetModifier.getBestPracticeNameTranslations(operator, attributeNames, "[\\W_]", null, null, 0);
    }

    public static Map<String, String> getBestPracticeNameTranslations(Operator operator, List<String> attributeNameList, String splitString, String groupDelimiter, String specifierDelimiter, int order) throws UserError {
        try {
            boolean enableSpecifier;
            Pattern splitPattern = Pattern.compile(splitString);
            HashMap<String, String> attributeNameMap = new HashMap<String, String>();
            boolean enableGroup = groupDelimiter != null;
            boolean bl = enableSpecifier = specifierDelimiter != null;
            if (enableGroup && enableSpecifier) {
                Pattern replaceWhatPattern = order < 3 ? Pattern.compile("(.*)" + Pattern.quote(groupDelimiter) + "(.*)" + Pattern.quote(specifierDelimiter) + "(.*)") : Pattern.compile("(.*)" + Pattern.quote(specifierDelimiter) + "(.*)" + Pattern.quote(groupDelimiter) + "(.*)");
                for (String attributeName : attributeNameList) {
                    if (Pattern.matches(replaceWhatPattern.toString(), attributeName)) {
                        String group = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[2][order][0]);
                        String specifier = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[2][order][2]);
                        String att = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[2][order][1]);
                        attributeNameMap.put(attributeName, StringTools.toCamelCase(group, splitPattern) + "::" + StringTools.toCamelCase(att, splitPattern) + "_" + StringTools.toCamelCase(specifier, splitPattern));
                        continue;
                    }
                    throw new UserError(operator, "toolkit.make_names_great_again.no_match", new Object[]{attributeName});
                }
            } else if (enableGroup) {
                Pattern replaceWhatPattern = Pattern.compile("(.*)" + Pattern.quote(groupDelimiter) + "(.*)");
                for (String attributeName : attributeNameList) {
                    if (Pattern.matches(replaceWhatPattern.toString(), attributeName)) {
                        String group = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[0][order][0]);
                        String att = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[0][order][1]);
                        attributeNameMap.put(attributeName, StringTools.toCamelCase(group, splitPattern) + "::" + StringTools.toCamelCase(att, splitPattern));
                        continue;
                    }
                    throw new UserError(operator, "toolkit.make_names_great_again.no_match", new Object[]{attributeName});
                }
            } else if (enableSpecifier) {
                Pattern replaceWhatPattern = Pattern.compile("(.*)" + Pattern.quote(specifierDelimiter) + "(.*)");
                for (String attributeName : attributeNameList) {
                    if (Pattern.matches(replaceWhatPattern.toString(), attributeName)) {
                        String specifier = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[1][order][1]);
                        String att = replaceWhatPattern.matcher(attributeName).replaceAll("$" + CAPTURING_GROUP[1][order][0]);
                        attributeNameMap.put(attributeName, StringTools.toCamelCase(att, splitPattern) + "_" + StringTools.toCamelCase(specifier, splitPattern));
                        continue;
                    }
                    attributeNameMap.put(attributeName, StringTools.toCamelCase(attributeName, splitPattern));
                }
            } else {
                Iterator<String> iterator = attributeNameList.iterator();
                while (iterator.hasNext()) {
                    String attributeName;
                    String att = attributeName = iterator.next();
                    attributeNameMap.put(attributeName, StringTools.toCamelCase(att, splitPattern));
                }
            }
            return attributeNameMap;
        }
        catch (PatternSyntaxException e) {
            throw new UserError(operator, 206, new Object[]{splitString, e});
        }
    }
}

