/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.FileObject;

public class RemoteFileSystemOperations {
    private static RemoteFileSystemOperations instance;

    private RemoteFileSystemOperations() {
    }

    public static RemoteFileSystemOperations getInstance() {
        if (instance == null) {
            instance = new RemoteFileSystemOperations();
        }
        return instance;
    }

    public <T> T performRemoteFileSystemTask(Operator op, RemoteFileSystemTask<T> task, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, OperatorException {
        int counter = 0;
        while (counter <= numberOfRetries) {
            if (op != null) {
                op.checkForStop();
            }
            ++counter;
            String errorMessage = "unknown";
            try {
                return task.performRemoteTask(op, delayMillis, numberOfRetries);
            }
            catch (RemoteFileSystemTaskFailedException e) {
                if (counter > numberOfRetries) {
                    throw e;
                }
                UserError ue = e.getUserError();
                if (ue != null) {
                    errorMessage = ue.getMessage();
                }
                if (delayMillis > 0L) {
                    long timeNow = System.currentTimeMillis();
                    for (long remaingTime = delayMillis; remaingTime > 0L; remaingTime -= System.currentTimeMillis() - timeNow) {
                        try {
                            Thread.sleep(remaingTime);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (op == null) continue;
                op.getLog().logWarning("Retrying operation ''" + task.getDescription() + "'' on remote filesystem for the " + counter + " time, after it failed because of ''" + errorMessage + "''.");
            }
        }
        throw new UserError(op, "toolkit.remote_file.task.fail.unknown");
    }

    public void performRemoteFileSystemCheck(Operator op, RemoteFileSystemCheck check, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, OperatorException {
        int counter = 0;
        while (counter <= numberOfRetries) {
            op.checkForStop();
            ++counter;
            String errorMessage = "unknown";
            try {
                check.performRemoteCheck(op, delayMillis, numberOfRetries, remoteFile);
                break;
            }
            catch (RemoteFileSystemTaskFailedException e) {
                if (counter > numberOfRetries) {
                    throw e;
                }
                UserError ue = e.getUserError();
                if (ue != null) {
                    errorMessage = ue.getMessage();
                }
                if (delayMillis > 0L) {
                    long timeNow = System.currentTimeMillis();
                    for (long remaingTime = delayMillis; remaingTime > 0L; remaingTime -= System.currentTimeMillis() - timeNow) {
                        try {
                            Thread.sleep(remaingTime);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                op.getLog().logWarning("Retrying operation ''" + check.getDescription() + "'' on remote filesystem for the " + counter + " time, after it failed because of ''" + errorMessage + "''.");
            }
        }
    }
}

