/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.configuration;

import com.owc.gui.renderer.actions.RemoteFileConnectionTestAction;
import com.owc.tools.files.remote.configuration.RemoteFileConnectionConfigurator;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.config.AbstractConfigurable;
import com.rapidminer.tools.config.TestConfigurableAction;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;

public class RemoteFileConnectionConfigurable
extends AbstractConfigurable {
    public static final String TYPE_ID = "RemoteFileConnection";

    public String getTypeId() {
        return TYPE_ID;
    }

    public FileSystemOptions getVfsOptions() throws UserError {
        String choosenRoot;
        String password;
        String username;
        String connectionType = this.getParameter("connection_type");
        String host = this.getParameter("host");
        if (host != null && host.isEmpty()) {
            host = null;
        }
        if ((username = this.getParameter("username")) != null && username.isEmpty()) {
            username = null;
        }
        if ((password = this.getParameter("password")) != null && password.isEmpty()) {
            password = null;
        }
        if ((choosenRoot = this.getParameter("root_directory")) == null) {
            choosenRoot = "";
        }
        FileSystemOptions options = new FileSystemOptions();
        if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[0])) {
            FtpFileSystemConfigBuilder.getInstance().setPassiveMode(options, true);
            FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, false);
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[1])) {
            SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, false);
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[2])) {
            FtpsFileSystemConfigBuilder.getInstance().setPassiveMode(options, true);
            FtpsFileSystemConfigBuilder.getInstance().setDataChannelProtectionLevel(options, FtpsDataChannelProtectionLevel.P);
            FtpsFileSystemConfigBuilder.getInstance().setFtpsMode(options, FtpsMode.EXPLICIT);
            FtpsFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, false);
        } else {
            throw new UserError(null, "toolkit.remote_files.configurable.unknown_protocol", new Object[]{connectionType});
        }
        if (host == null) {
            throw new UserError(null, "toolkit.remote_files.configurable.missing_parameter", new Object[]{"host", this.getName()});
        }
        if (username == null) {
            throw new UserError(null, "toolkit.remote_files.configurable.missing_parameter", new Object[]{"username", this.getName()});
        }
        StaticUserAuthenticator auth = new StaticUserAuthenticator("", username, password);
        try {
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(options, auth);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            throw new UserError(null, "");
        }
        return options;
    }

    public String getVfsUri() throws UserError {
        String choosenRoot;
        String password;
        String username;
        String connectionType = this.getParameter("connection_type");
        String host = this.getParameter("host");
        if (host != null && host.isEmpty()) {
            host = null;
        }
        if ((username = this.getParameter("username")) != null && username.isEmpty()) {
            username = null;
        }
        if ((password = this.getParameter("password")) != null && password.isEmpty()) {
            password = null;
        }
        if ((choosenRoot = this.getParameter("root_directory")) == null) {
            choosenRoot = "";
        }
        String port = null;
        if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[0])) {
            port = this.getParameter("port_ftp");
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[1])) {
            port = this.getParameter("port_sftp");
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[2])) {
            port = this.getParameter("port_ftps");
        }
        String prefix = "";
        if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[0])) {
            prefix = "ftp";
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[1])) {
            prefix = "sftp";
        } else if (connectionType.equals(RemoteFileConnectionConfigurator.connection_types[2])) {
            prefix = "ftps";
        } else {
            throw new UserError(null, "toolkit.remote_files.configurable.unknown_protocol", new Object[]{connectionType});
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(prefix);
        urlBuilder.append("://");
        urlBuilder.append(host);
        if (port != null && !port.isEmpty()) {
            urlBuilder.append(":");
            urlBuilder.append(port);
        }
        urlBuilder.append(choosenRoot);
        return urlBuilder.toString();
    }

    public TestConfigurableAction getTestAction() {
        return new RemoteFileConnectionTestAction(this);
    }
}

