/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemManager;

public class CreateTempFileTask
extends RemoteFileSystemTask<File> {
    String localName;

    public CreateTempFileTask(FileSystemManager manager, String localName) {
        super(manager, "toolkit.create_temp_file", localName);
        this.localName = localName;
    }

    @Override
    public File performRemoteTask(Operator op, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, UserError, OperatorException, ProcessStoppedException {
        File file;
        try {
            file = File.createTempFile("tmp" + this.localName, "");
            file.deleteOnExit();
        }
        catch (IOException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, 303, new Object[]{this.localName, e.getMessage()}));
        }
        return file;
    }
}

