/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.objects.files.RemoteFileObject;
import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;

public class DeliverRemoteFileObjectToOutputport
extends RemoteFileSystemCheck {
    OutputPort outputport;

    public DeliverRemoteFileObjectToOutputport(FileSystemManager manager, OutputPort outputport) {
        super(manager);
        this.outputport = outputport;
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, UserError, OperatorException, ProcessStoppedException {
        RemoteFileObject remoteFileObject = new RemoteFileObject(remoteFile, remoteFile.getName().getBaseName(), numberOfRetries, delayMillis);
        this.addAnnotation(remoteFileObject);
        this.outputport.deliver((IOObject)remoteFileObject);
    }

    private void addAnnotation(RemoteFileObject remoteFileObject) throws OperatorException {
        Annotations annotations = remoteFileObject.getAnnotations();
        annotations.setAnnotation("Filename", remoteFileObject.getFilename());
        annotations.setAnnotation("Source", remoteFileObject.getSource());
    }
}

